/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.ExceptionResultsBlock;
import org.apache.pinot.core.operator.combine.merger.ResultsBlockMerger;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.QueryMultiThreadingUtils;
import org.apache.pinot.core.util.trace.TraceRunnable;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.accounting.ThreadExecutionContext;
import org.apache.pinot.spi.accounting.ThreadResourceUsageProvider;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.apache.pinot.spi.trace.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCombineOperator<T extends BaseResultsBlock>
extends BaseOperator<BaseResultsBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseCombineOperator.class);
    protected final ResultsBlockMerger<T> _resultsBlockMerger;
    protected final List<Operator> _operators;
    protected final int _numOperators;
    protected final QueryContext _queryContext;
    protected final ExecutorService _executorService;
    protected final int _numTasks;
    protected final Phaser _phaser;
    protected final Future[] _futures;
    protected final AtomicInteger _nextOperatorId = new AtomicInteger();
    protected final AtomicReference<Throwable> _processingException = new AtomicReference();
    protected final AtomicLong _totalWorkerThreadCpuTimeNs = new AtomicLong(0L);

    protected BaseCombineOperator(ResultsBlockMerger<T> resultsBlockMerger, List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        this._resultsBlockMerger = resultsBlockMerger;
        this._operators = operators;
        this._numOperators = this._operators.size();
        this._queryContext = queryContext;
        this._executorService = executorService;
        this._numTasks = QueryMultiThreadingUtils.getNumTasksForQuery(operators.size(), queryContext.getMaxExecutionThreads());
        this._phaser = new Phaser(1);
        this._futures = new Future[this._numTasks];
    }

    protected void startProcess() {
        Tracing.activeRecording().setNumTasks(this._numTasks);
        final ThreadExecutionContext parentContext = Tracing.getThreadAccountant().getThreadExecutionContext();
        for (int i = 0; i < this._numTasks; ++i) {
            final int taskId = i;
            this._futures[i] = this._executorService.submit(new TraceRunnable(){

                @Override
                public void runJob() {
                    ThreadResourceUsageProvider threadResourceUsageProvider = new ThreadResourceUsageProvider();
                    Tracing.ThreadAccountantOps.setupWorker((int)taskId, (ThreadResourceUsageProvider)threadResourceUsageProvider, (ThreadExecutionContext)parentContext);
                    if (BaseCombineOperator.this._phaser.register() < 0) {
                        Tracing.ThreadAccountantOps.clear();
                        return;
                    }
                    try {
                        BaseCombineOperator.this.processSegments();
                    }
                    catch (EarlyTerminationException earlyTerminationException) {
                    }
                    catch (Throwable t) {
                        if (t instanceof Exception) {
                            LOGGER.error("Caught exception while processing query: {}", (Object)BaseCombineOperator.this._queryContext, (Object)t);
                        } else {
                            LOGGER.error("Caught serious error while processing query: {}", (Object)BaseCombineOperator.this._queryContext, (Object)t);
                        }
                        BaseCombineOperator.this.onProcessSegmentsException(t);
                    }
                    finally {
                        BaseCombineOperator.this.onProcessSegmentsFinish();
                        BaseCombineOperator.this._phaser.arriveAndDeregister();
                        Tracing.ThreadAccountantOps.clear();
                    }
                    BaseCombineOperator.this._totalWorkerThreadCpuTimeNs.getAndAdd(threadResourceUsageProvider.getThreadTimeNs());
                }
            });
        }
    }

    protected void stopProcess() {
        for (Future future : this._futures) {
            if (future == null || future.isDone()) continue;
            future.cancel(true);
        }
        this._phaser.awaitAdvance(this._phaser.arriveAndDeregister());
    }

    protected ExceptionResultsBlock getTimeoutResultsBlock(int numBlocksMerged) {
        LOGGER.error("Timed out while polling results block, numBlocksMerged: {} (query: {})", (Object)numBlocksMerged, (Object)this._queryContext);
        return new ExceptionResultsBlock(QueryException.EXECUTION_TIMEOUT_ERROR, new TimeoutException("Timed out while polling results block"));
    }

    @Override
    public List<Operator> getChildOperators() {
        return this._operators;
    }

    protected abstract void processSegments();

    protected abstract void onProcessSegmentsException(Throwable var1);

    protected abstract void onProcessSegmentsFinish();

    protected static RuntimeException wrapOperatorException(Operator operator, RuntimeException e) {
        if (e instanceof EarlyTerminationException) {
            return e;
        }
        IndexSegment segment = operator.getIndexSegment();
        if (segment == null) {
            return e;
        }
        throw new RuntimeException("Caught exception while doing operator: " + operator.getClass() + " on segment: " + segment.getSegmentName(), e);
    }
}

