/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.IntermediateRecord;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.operator.AcquireReleaseColumnsSegmentOperator;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.ExceptionResultsBlock;
import org.apache.pinot.core.operator.blocks.results.GroupByResultsBlock;
import org.apache.pinot.core.operator.combine.BaseSingleBlockCombineOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.spi.trace.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByCombineOperator
extends BaseSingleBlockCombineOperator<GroupByResultsBlock> {
    public static final int MAX_TRIM_THRESHOLD = 1000000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupByCombineOperator.class);
    private static final String EXPLAIN_NAME = "COMBINE_GROUP_BY";
    private final int _numAggregationFunctions;
    private final int _numGroupByExpressions;
    private final int _numColumns;
    private final CountDownLatch _operatorLatch;
    private volatile IndexedTable _indexedTable;
    private volatile boolean _numGroupsLimitReached;

    public GroupByCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        super(null, operators, GroupByCombineOperator.overrideMaxExecutionThreads(queryContext, operators.size()), executorService);
        AggregationFunction[] aggregationFunctions = this._queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null);
        this._numAggregationFunctions = aggregationFunctions.length;
        assert (this._queryContext.getGroupByExpressions() != null);
        this._numGroupByExpressions = this._queryContext.getGroupByExpressions().size();
        this._numColumns = this._numGroupByExpressions + this._numAggregationFunctions;
        this._operatorLatch = new CountDownLatch(this._numTasks);
    }

    private static QueryContext overrideMaxExecutionThreads(QueryContext queryContext, int numOperators) {
        int maxExecutionThreads = queryContext.getMaxExecutionThreads();
        if (maxExecutionThreads <= 0) {
            queryContext.setMaxExecutionThreads(numOperators);
        }
        return queryContext;
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSegments() {
        int operatorId;
        while (this._processingException.get() == null && (operatorId = this._nextOperatorId.getAndIncrement()) < this._numOperators) {
            Operator operator = (Operator)this._operators.get(operatorId);
            try {
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).acquire();
                }
                GroupByResultsBlock resultsBlock = (GroupByResultsBlock)operator.nextBlock();
                if (this._indexedTable == null) {
                    GroupByCombineOperator groupByCombineOperator = this;
                    synchronized (groupByCombineOperator) {
                        if (this._indexedTable == null) {
                            this._indexedTable = GroupByUtils.createIndexedTableForCombineOperator(resultsBlock, this._queryContext, this._numTasks);
                        }
                    }
                }
                if (resultsBlock.isNumGroupsLimitReached()) {
                    this._numGroupsLimitReached = true;
                }
                Collection<IntermediateRecord> intermediateRecords = resultsBlock.getIntermediateRecords();
                int mergedKeys = 0;
                if (intermediateRecords == null) {
                    AggregationGroupByResult aggregationGroupByResult = resultsBlock.getAggregationGroupByResult();
                    if (aggregationGroupByResult == null) continue;
                    Iterator<GroupKeyGenerator.GroupKey> dicGroupKeyIterator = aggregationGroupByResult.getGroupKeyIterator();
                    while (dicGroupKeyIterator.hasNext()) {
                        GroupKeyGenerator.GroupKey groupKey = dicGroupKeyIterator.next();
                        Object[] keys = groupKey._keys;
                        Object[] values = Arrays.copyOf(keys, this._numColumns);
                        int groupId = groupKey._groupId;
                        for (int i = 0; i < this._numAggregationFunctions; ++i) {
                            values[this._numGroupByExpressions + i] = aggregationGroupByResult.getResultForGroupId(i, groupId);
                        }
                        this._indexedTable.upsert(new Key(keys), new Record(values));
                        Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)mergedKeys);
                        ++mergedKeys;
                    }
                    continue;
                }
                for (IntermediateRecord intermediateResult : intermediateRecords) {
                    this._indexedTable.upsert(intermediateResult._key, intermediateResult._record);
                    Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)mergedKeys);
                    ++mergedKeys;
                }
            }
            catch (RuntimeException e) {
                throw GroupByCombineOperator.wrapOperatorException(operator, e);
            }
            finally {
                if (!(operator instanceof AcquireReleaseColumnsSegmentOperator)) continue;
                ((AcquireReleaseColumnsSegmentOperator)operator).release();
            }
        }
    }

    @Override
    public void onProcessSegmentsException(Throwable t) {
        this._processingException.compareAndSet(null, t);
    }

    @Override
    public void onProcessSegmentsFinish() {
        this._operatorLatch.countDown();
    }

    @Override
    public BaseResultsBlock mergeResults() throws Exception {
        long timeoutMs = this._queryContext.getEndTimeMs() - System.currentTimeMillis();
        boolean opCompleted = this._operatorLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
        if (!opCompleted) {
            String errorMessage = String.format("Timed out while combining group-by order-by results after %dms, queryContext = %s", timeoutMs, this._queryContext);
            LOGGER.error(errorMessage);
            return new ExceptionResultsBlock(new TimeoutException(errorMessage));
        }
        Throwable processingException = (Throwable)this._processingException.get();
        if (processingException != null) {
            return new ExceptionResultsBlock(processingException);
        }
        IndexedTable indexedTable = this._indexedTable;
        if (this._queryContext.isServerReturnFinalResult()) {
            indexedTable.finish(true, true);
        } else if (this._queryContext.isServerReturnFinalResultKeyUnpartitioned()) {
            indexedTable.finish(false, true);
        } else {
            indexedTable.finish(false);
        }
        GroupByResultsBlock mergedBlock = new GroupByResultsBlock(indexedTable, this._queryContext);
        mergedBlock.setNumGroupsLimitReached(this._numGroupsLimitReached);
        mergedBlock.setNumResizes(indexedTable.getNumResizes());
        mergedBlock.setResizeTimeMs(indexedTable.getResizeTimeMs());
        return mergedBlock;
    }
}

