/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.operator.combine.BaseSingleBlockCombineOperator;
import org.apache.pinot.core.operator.combine.CombineOperatorUtils;
import org.apache.pinot.core.operator.combine.merger.SelectionOnlyResultsBlockMerger;
import org.apache.pinot.core.query.request.context.QueryContext;

public class SelectionOnlyCombineOperator
extends BaseSingleBlockCombineOperator<SelectionResultsBlock> {
    private static final String EXPLAIN_NAME = "COMBINE_SELECT";
    private final int _numRowsToKeep;

    public SelectionOnlyCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService) {
        super(new SelectionOnlyResultsBlockMerger(queryContext), operators, queryContext, executorService);
        this._numRowsToKeep = queryContext.getLimit();
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    protected BaseResultsBlock getNextBlock() {
        if (this._numRowsToKeep == 0) {
            BaseResultsBlock resultsBlock = (BaseResultsBlock)((Operator)this._operators.get(0)).nextBlock();
            CombineOperatorUtils.setExecutionStatistics(resultsBlock, this._operators, 0L, 1);
            return resultsBlock;
        }
        return super.getNextBlock();
    }
}

