/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine.merger;

import java.util.List;
import org.apache.pinot.core.operator.blocks.results.AggregationResultsBlock;
import org.apache.pinot.core.operator.combine.merger.ResultsBlockMerger;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;

public class AggregationResultsBlockMerger
implements ResultsBlockMerger<AggregationResultsBlock> {
    public AggregationResultsBlockMerger(QueryContext queryContext) {
    }

    @Override
    public void mergeResultsBlocks(AggregationResultsBlock mergedBlock, AggregationResultsBlock blockToMerge) {
        AggregationFunction[] aggregationFunctions = mergedBlock.getAggregationFunctions();
        List<Object> mergedResults = mergedBlock.getResults();
        List<Object> resultsToMerge = blockToMerge.getResults();
        assert (aggregationFunctions != null && mergedResults != null && resultsToMerge != null);
        if (mergedBlock.getNumRows() == 0 && blockToMerge.getNumRows() == 0) {
            return;
        }
        int numAggregationFunctions = aggregationFunctions.length;
        for (int i = 0; i < numAggregationFunctions; ++i) {
            mergedResults.set(i, aggregationFunctions[i].merge(mergedResults.get(i), resultsToMerge.get(i)));
        }
    }
}

