/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine.merger;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.TimeSeriesBuilderBlock;
import org.apache.pinot.core.operator.blocks.results.TimeSeriesResultsBlock;
import org.apache.pinot.core.operator.combine.merger.ResultsBlockMerger;
import org.apache.pinot.tsdb.spi.AggInfo;
import org.apache.pinot.tsdb.spi.series.BaseTimeSeriesBuilder;
import org.apache.pinot.tsdb.spi.series.TimeSeriesBuilderFactory;

public class TimeSeriesAggResultsBlockMerger
implements ResultsBlockMerger<TimeSeriesResultsBlock> {
    private final TimeSeriesBuilderFactory _seriesBuilderFactory;
    private final AggInfo _aggInfo;
    private final int _maxSeriesLimit;
    private final long _maxDataPointsLimit;

    public TimeSeriesAggResultsBlockMerger(TimeSeriesBuilderFactory seriesBuilderFactory, AggInfo aggInfo) {
        this._seriesBuilderFactory = seriesBuilderFactory;
        this._aggInfo = aggInfo;
        this._maxSeriesLimit = this._seriesBuilderFactory.getMaxUniqueSeriesPerServerLimit();
        this._maxDataPointsLimit = this._seriesBuilderFactory.getMaxDataPointsPerServerLimit();
    }

    @Override
    public void mergeResultsBlocks(TimeSeriesResultsBlock mergedBlock, TimeSeriesResultsBlock blockToMerge) {
        TimeSeriesBuilderBlock currentTimeSeriesBlock = mergedBlock.getTimeSeriesBuilderBlock();
        TimeSeriesBuilderBlock seriesBlockToMerge = blockToMerge.getTimeSeriesBuilderBlock();
        for (Map.Entry<Long, BaseTimeSeriesBuilder> entry : seriesBlockToMerge.getSeriesBuilderMap().entrySet()) {
            long seriesHash = entry.getKey();
            BaseTimeSeriesBuilder currentTimeSeriesBuilder = currentTimeSeriesBlock.getSeriesBuilderMap().get(seriesHash);
            BaseTimeSeriesBuilder newTimeSeriesToMerge = entry.getValue();
            if (currentTimeSeriesBuilder == null) {
                currentTimeSeriesBlock.getSeriesBuilderMap().put(seriesHash, newTimeSeriesToMerge);
                long currentUniqueSeries = currentTimeSeriesBlock.getSeriesBuilderMap().size();
                long numBuckets = currentTimeSeriesBlock.getTimeBuckets().getNumBuckets();
                Preconditions.checkState((currentUniqueSeries * numBuckets <= this._maxDataPointsLimit ? 1 : 0) != 0, (String)"Max data points limit reached in combine operator. Limit: %s. Current count: %s", (long)this._maxDataPointsLimit, (long)(currentUniqueSeries * numBuckets));
                Preconditions.checkState((currentUniqueSeries <= (long)this._maxSeriesLimit ? 1 : 0) != 0, (String)"Max series limit reached in combine operator. Limit: %s. Current Size: %s", (int)this._maxSeriesLimit, (int)currentTimeSeriesBlock.getSeriesBuilderMap().size());
                continue;
            }
            currentTimeSeriesBuilder.mergeAlignedSeriesBuilder(newTimeSeriesToMerge);
        }
    }
}

