/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.docidsets;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.operator.dociditerators.BitmapBasedDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.BitmapDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.OrDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.SortedDocIdIterator;
import org.apache.pinot.spi.utils.Pairs;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class OrDocIdSet
implements BlockDocIdSet {
    private final AtomicReference<List<BlockDocIdSet>> _scanBasedDocIdSets = new AtomicReference();
    private final int _numDocs;
    private List<BlockDocIdSet> _docIdSets;
    private volatile long _numEntriesScannedInFilter = 0L;

    public OrDocIdSet(List<BlockDocIdSet> docIdSets, int numDocs) {
        this._docIdSets = docIdSets;
        this._numDocs = numDocs;
    }

    @Override
    public BlockDocIdIterator iterator() {
        int numDocIdSets = this._docIdSets.size();
        BlockDocIdIterator[] allDocIdIterators = new BlockDocIdIterator[numDocIdSets];
        ArrayList<SortedDocIdIterator> sortedDocIdIterators = new ArrayList<SortedDocIdIterator>();
        ArrayList bitmapBasedDocIdIterators = new ArrayList();
        ArrayList<BlockDocIdIterator> remainingDocIdIterators = new ArrayList<BlockDocIdIterator>();
        long numEntriesScannedForNonScanBasedDocIdSets = 0L;
        ArrayList<BlockDocIdSet> scanBasedDocIdSets = new ArrayList<BlockDocIdSet>();
        for (int i = 0; i < numDocIdSets; ++i) {
            BlockDocIdIterator docIdIterator;
            BlockDocIdSet docIdSet = this._docIdSets.get(i);
            allDocIdIterators[i] = docIdIterator = docIdSet.iterator();
            if (docIdIterator instanceof SortedDocIdIterator) {
                sortedDocIdIterators.add((SortedDocIdIterator)docIdIterator);
                numEntriesScannedForNonScanBasedDocIdSets += docIdSet.getNumEntriesScannedInFilter();
                continue;
            }
            if (docIdIterator instanceof BitmapBasedDocIdIterator) {
                numEntriesScannedForNonScanBasedDocIdSets += docIdSet.getNumEntriesScannedInFilter();
                continue;
            }
            remainingDocIdIterators.add(docIdIterator);
            scanBasedDocIdSets.add(docIdSet);
        }
        this._docIdSets = null;
        this._numEntriesScannedInFilter = numEntriesScannedForNonScanBasedDocIdSets;
        this._scanBasedDocIdSets.set(scanBasedDocIdSets);
        int numSortedDocIdIterators = sortedDocIdIterators.size();
        int numBitmapBasedDocIdIterators = bitmapBasedDocIdIterators.size();
        if (numSortedDocIdIterators + numBitmapBasedDocIdIterators > 1) {
            MutableRoaringBitmap docIds = new MutableRoaringBitmap();
            for (SortedDocIdIterator sortedDocIdIterator : sortedDocIdIterators) {
                for (Pairs.IntPair docIdRange : sortedDocIdIterator.getDocIdRanges()) {
                    docIds.add((long)docIdRange.getLeft(), (long)docIdRange.getRight() + 1L);
                }
            }
            for (BitmapBasedDocIdIterator bitmapBasedDocIdIterator : bitmapBasedDocIdIterators) {
                docIds.or(bitmapBasedDocIdIterator.getDocIds());
            }
            BitmapDocIdIterator bitmapDocIdIterator = new BitmapDocIdIterator((ImmutableRoaringBitmap)docIds, this._numDocs);
            int numRemainingDocIdIterators = remainingDocIdIterators.size();
            if (numRemainingDocIdIterators == 0) {
                return bitmapDocIdIterator;
            }
            BlockDocIdIterator[] docIdIterators = new BlockDocIdIterator[numRemainingDocIdIterators + 1];
            docIdIterators[0] = bitmapDocIdIterator;
            for (int i = 0; i < numRemainingDocIdIterators; ++i) {
                docIdIterators[i + 1] = (BlockDocIdIterator)remainingDocIdIterators.get(i);
            }
            return new OrDocIdIterator(docIdIterators);
        }
        return new OrDocIdIterator(allDocIdIterators);
    }

    @Override
    public long getNumEntriesScannedInFilter() {
        List<BlockDocIdSet> scanBasedDocIdSets = this._scanBasedDocIdSets.get();
        long numEntriesScannedForScanBasedDocIdSets = 0L;
        if (scanBasedDocIdSets != null) {
            for (BlockDocIdSet scanBasedDocIdSet : scanBasedDocIdSets) {
                numEntriesScannedForScanBasedDocIdSets += scanBasedDocIdSet.getNumEntriesScannedInFilter();
            }
        }
        return this._numEntriesScannedInFilter + numEntriesScannedForScanBasedDocIdSets;
    }
}

