/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.docvalsets;

import java.math.BigDecimal;
import javax.annotation.Nullable;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.util.DataBlockExtractUtils;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class DataBlockValSet
implements BlockValSet {
    private final FieldSpec.DataType _dataType;
    private final FieldSpec.DataType _storedType;
    private final DataBlock _dataBlock;
    private final int _colId;
    private final RoaringBitmap _nullBitmap;

    public DataBlockValSet(DataSchema.ColumnDataType columnDataType, DataBlock dataBlock, int colId) {
        this._dataType = columnDataType.toDataType();
        this._storedType = this._dataType.getStoredType();
        this._dataBlock = dataBlock;
        this._colId = colId;
        this._nullBitmap = dataBlock.getNullRowIds(colId);
    }

    @Override
    @Nullable
    public RoaringBitmap getNullBitmap() {
        return this._nullBitmap;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return this._dataType;
    }

    @Override
    public boolean isSingleValue() {
        return true;
    }

    @Override
    @Nullable
    public Dictionary getDictionary() {
        return null;
    }

    @Override
    public int[] getDictionaryIdsSV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getIntValuesSV() {
        return DataBlockExtractUtils.extractIntColumn(this._storedType, this._dataBlock, this._colId, this._nullBitmap);
    }

    @Override
    public long[] getLongValuesSV() {
        return DataBlockExtractUtils.extractLongColumn(this._storedType, this._dataBlock, this._colId, this._nullBitmap);
    }

    @Override
    public float[] getFloatValuesSV() {
        return DataBlockExtractUtils.extractFloatColumn(this._storedType, this._dataBlock, this._colId, this._nullBitmap);
    }

    @Override
    public double[] getDoubleValuesSV() {
        return DataBlockExtractUtils.extractDoubleColumn(this._storedType, this._dataBlock, this._colId, this._nullBitmap);
    }

    @Override
    public BigDecimal[] getBigDecimalValuesSV() {
        return DataBlockExtractUtils.extractBigDecimalColumn(this._storedType, this._dataBlock, this._colId, this._nullBitmap);
    }

    @Override
    public String[] getStringValuesSV() {
        return DataBlockExtractUtils.extractStringColumn(this._storedType, this._dataBlock, this._colId, this._nullBitmap);
    }

    @Override
    public byte[][] getBytesValuesSV() {
        return DataBlockExtractUtils.extractBytesColumn(this._storedType, this._dataBlock, this._colId, this._nullBitmap);
    }

    @Override
    public int[][] getDictionaryIdsMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] getIntValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[][] getLongValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[][] getFloatValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[][] getDoubleValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[][] getStringValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[][][] getBytesValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getNumMVEntries() {
        throw new UnsupportedOperationException();
    }
}

