/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.docvalsets;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.CommonConstants;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class FilteredRowBasedBlockValSet
implements BlockValSet {
    private final FieldSpec.DataType _dataType;
    private final FieldSpec.DataType _storedType;
    private final List<Object[]> _rows;
    private final int _colId;
    private final int _numMatchedRows;
    private final RoaringBitmap _matchedBitmap;
    private final RoaringBitmap _matchedNullBitmap;

    public FilteredRowBasedBlockValSet(DataSchema.ColumnDataType columnDataType, List<Object[]> rows, int colId, int numMatchedRows, RoaringBitmap matchedBitmap, boolean nullHandlingEnabled) {
        this._dataType = columnDataType.toDataType();
        this._storedType = this._dataType.getStoredType();
        this._rows = rows;
        this._colId = colId;
        this._numMatchedRows = numMatchedRows;
        this._matchedBitmap = matchedBitmap;
        if (nullHandlingEnabled) {
            RoaringBitmap matchedNullBitmap = new RoaringBitmap();
            PeekableIntIterator iterator = matchedBitmap.getIntIterator();
            for (int i = 0; i < numMatchedRows; ++i) {
                int rowId = iterator.next();
                if (rows.get(rowId)[colId] != null) continue;
                matchedNullBitmap.add(i);
            }
            this._matchedNullBitmap = !matchedNullBitmap.isEmpty() ? matchedNullBitmap : null;
        } else {
            this._matchedNullBitmap = null;
        }
    }

    @Override
    @Nullable
    public RoaringBitmap getNullBitmap() {
        return this._matchedNullBitmap;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return this._dataType;
    }

    @Override
    public boolean isSingleValue() {
        return true;
    }

    @Override
    @Nullable
    public Dictionary getDictionary() {
        return null;
    }

    @Override
    public int[] getDictionaryIdsSV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getIntValuesSV() {
        Preconditions.checkState((this._dataType == FieldSpec.DataType.UNKNOWN || this._storedType.isNumeric() || this._storedType == FieldSpec.DataType.STRING ? 1 : 0) != 0, (String)"Cannot read int values from data type: %s", (Object)this._dataType);
        int[] values = new int[this._numMatchedRows];
        if (this._numMatchedRows == 0 || this._dataType == FieldSpec.DataType.UNKNOWN) {
            return values;
        }
        PeekableIntIterator iterator = this._matchedBitmap.getIntIterator();
        for (int matchedRowId = 0; matchedRowId < this._numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            if (this._matchedNullBitmap != null && this._matchedNullBitmap.contains(matchedRowId)) continue;
            values[matchedRowId] = this._storedType.isNumeric() ? ((Number)this._rows.get(rowId)[this._colId]).intValue() : Integer.parseInt((String)this._rows.get(rowId)[this._colId]);
        }
        return values;
    }

    @Override
    public long[] getLongValuesSV() {
        Preconditions.checkState((this._dataType == FieldSpec.DataType.UNKNOWN || this._storedType.isNumeric() || this._storedType == FieldSpec.DataType.STRING ? 1 : 0) != 0, (String)"Cannot read long values from data type: %s", (Object)this._dataType);
        long[] values = new long[this._numMatchedRows];
        if (this._numMatchedRows == 0 || this._dataType == FieldSpec.DataType.UNKNOWN) {
            return values;
        }
        PeekableIntIterator iterator = this._matchedBitmap.getIntIterator();
        for (int matchedRowId = 0; matchedRowId < this._numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            if (this._matchedNullBitmap != null && this._matchedNullBitmap.contains(matchedRowId)) continue;
            values[matchedRowId] = this._storedType.isNumeric() ? ((Number)this._rows.get(rowId)[this._colId]).longValue() : Long.parseLong((String)this._rows.get(rowId)[this._colId]);
        }
        return values;
    }

    @Override
    public float[] getFloatValuesSV() {
        Preconditions.checkState((this._dataType == FieldSpec.DataType.UNKNOWN || this._storedType.isNumeric() || this._storedType == FieldSpec.DataType.STRING ? 1 : 0) != 0, (String)"Cannot read float values from data type: %s", (Object)this._dataType);
        float[] values = new float[this._numMatchedRows];
        if (this._numMatchedRows == 0 || this._dataType == FieldSpec.DataType.UNKNOWN) {
            return values;
        }
        PeekableIntIterator iterator = this._matchedBitmap.getIntIterator();
        for (int matchedRowId = 0; matchedRowId < this._numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            if (this._matchedNullBitmap != null && this._matchedNullBitmap.contains(matchedRowId)) continue;
            values[matchedRowId] = this._storedType.isNumeric() ? ((Number)this._rows.get(rowId)[this._colId]).floatValue() : Float.parseFloat((String)this._rows.get(rowId)[this._colId]);
        }
        return values;
    }

    @Override
    public double[] getDoubleValuesSV() {
        Preconditions.checkState((this._dataType == FieldSpec.DataType.UNKNOWN || this._storedType.isNumeric() || this._storedType == FieldSpec.DataType.STRING ? 1 : 0) != 0, (String)"Cannot read double values from data type: %s", (Object)this._dataType);
        double[] values = new double[this._numMatchedRows];
        if (this._numMatchedRows == 0 || this._dataType == FieldSpec.DataType.UNKNOWN) {
            return values;
        }
        PeekableIntIterator iterator = this._matchedBitmap.getIntIterator();
        for (int matchedRowId = 0; matchedRowId < this._numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            if (this._matchedNullBitmap != null && this._matchedNullBitmap.contains(matchedRowId)) continue;
            values[matchedRowId] = this._storedType.isNumeric() ? ((Number)this._rows.get(rowId)[this._colId]).doubleValue() : Double.parseDouble((String)this._rows.get(rowId)[this._colId]);
        }
        return values;
    }

    @Override
    public BigDecimal[] getBigDecimalValuesSV() {
        Object[] values = new BigDecimal[this._numMatchedRows];
        if (this._numMatchedRows == 0) {
            return values;
        }
        if (this._dataType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill(values, CommonConstants.NullValuePlaceHolder.BIG_DECIMAL);
            return values;
        }
        PeekableIntIterator iterator = this._matchedBitmap.getIntIterator();
        block6: for (int matchedRowId = 0; matchedRowId < this._numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            if (this._matchedNullBitmap != null && this._matchedNullBitmap.contains(matchedRowId)) {
                values[matchedRowId] = CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                continue;
            }
            switch (this._storedType) {
                case INT: 
                case LONG: {
                    values[matchedRowId] = BigDecimal.valueOf(((Number)this._rows.get(rowId)[this._colId]).longValue());
                    continue block6;
                }
                case FLOAT: 
                case DOUBLE: 
                case STRING: {
                    values[matchedRowId] = new BigDecimal(this._rows.get(rowId)[this._colId].toString());
                    continue block6;
                }
                case BIG_DECIMAL: {
                    values[matchedRowId] = (BigDecimal)this._rows.get(rowId)[this._colId];
                    continue block6;
                }
                case BYTES: {
                    values[matchedRowId] = BigDecimalUtils.deserialize((ByteArray)((ByteArray)this._rows.get(rowId)[this._colId]));
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Cannot read BigDecimal values from data type: " + this._dataType);
                }
            }
        }
        return values;
    }

    @Override
    public String[] getStringValuesSV() {
        Object[] values = new String[this._numMatchedRows];
        if (this._numMatchedRows == 0) {
            return values;
        }
        if (this._dataType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill(values, "");
            return values;
        }
        PeekableIntIterator iterator = this._matchedBitmap.getIntIterator();
        for (int matchedRowId = 0; matchedRowId < this._numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            boolean isNull = this._matchedNullBitmap != null && this._matchedNullBitmap.contains(matchedRowId);
            values[matchedRowId] = !isNull ? this._rows.get(rowId)[this._colId].toString() : "";
        }
        return values;
    }

    @Override
    public byte[][] getBytesValuesSV() {
        byte[][] values = new byte[this._numMatchedRows][];
        if (this._numMatchedRows == 0) {
            return values;
        }
        if (this._dataType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill((Object[])values, CommonConstants.NullValuePlaceHolder.BYTES);
            return values;
        }
        PeekableIntIterator iterator = this._matchedBitmap.getIntIterator();
        for (int matchedRowId = 0; matchedRowId < this._numMatchedRows; ++matchedRowId) {
            int rowId = iterator.next();
            boolean isNull = this._matchedNullBitmap != null && this._matchedNullBitmap.contains(matchedRowId);
            values[matchedRowId] = !isNull ? ((ByteArray)this._rows.get(rowId)[this._colId]).getBytes() : CommonConstants.NullValuePlaceHolder.BYTES;
        }
        return values;
    }

    @Override
    public int[][] getDictionaryIdsMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] getIntValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[][] getLongValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[][] getFloatValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[][] getDoubleValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[][] getStringValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[][][] getBytesValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getNumMVEntries() {
        throw new UnsupportedOperationException();
    }
}

