/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.docvalsets;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ArrayCopyUtils;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.CommonConstants;
import org.roaringbitmap.RoaringBitmap;

public class RowBasedBlockValSet
implements BlockValSet {
    private final FieldSpec.DataType _dataType;
    private final FieldSpec.DataType _storedType;
    private final List<Object[]> _rows;
    private final int _colId;
    private final RoaringBitmap _nullBitmap;
    private final Object _nullPlaceHolder;

    public RowBasedBlockValSet(DataSchema.ColumnDataType columnDataType, List<Object[]> rows, int colId, boolean nullHandlingEnabled) {
        this._dataType = columnDataType.toDataType();
        this._storedType = this._dataType.getStoredType();
        this._rows = rows;
        this._colId = colId;
        this._nullPlaceHolder = columnDataType.getNullPlaceholder();
        if (nullHandlingEnabled) {
            RoaringBitmap nullBitmap;
            int numRows = rows.size();
            if (this._dataType == FieldSpec.DataType.UNKNOWN) {
                nullBitmap = new RoaringBitmap();
                nullBitmap.add(0L, (long)numRows);
            } else {
                nullBitmap = new RoaringBitmap();
                for (int i = 0; i < numRows; ++i) {
                    if (rows.get(i)[colId] != null) continue;
                    nullBitmap.add(i);
                }
            }
            this._nullBitmap = nullBitmap.isEmpty() ? null : nullBitmap;
        } else {
            this._nullBitmap = null;
        }
    }

    @Override
    @Nullable
    public RoaringBitmap getNullBitmap() {
        return this._nullBitmap;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return this._dataType;
    }

    @Override
    public boolean isSingleValue() {
        return true;
    }

    @Override
    @Nullable
    public Dictionary getDictionary() {
        return null;
    }

    @Override
    public int[] getDictionaryIdsSV() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int[] getIntValuesSV() {
        int numRows = this._rows.size();
        int[] values = new int[numRows];
        if (numRows == 0 || this._dataType == FieldSpec.DataType.UNKNOWN) {
            return values;
        }
        if (this._nullBitmap == null) {
            if (this._storedType.isNumeric()) {
                for (int i = 0; i < numRows; ++i) {
                    values[i] = ((Number)this._rows.get(i)[this._colId]).intValue();
                }
                return values;
            } else {
                if (this._storedType != FieldSpec.DataType.STRING) throw new IllegalStateException("Cannot read int values from data type: " + this._dataType);
                for (int i = 0; i < numRows; ++i) {
                    values[i] = Integer.parseInt((String)this._rows.get(i)[this._colId]);
                }
            }
            return values;
        } else if (this._storedType.isNumeric()) {
            for (int i = 0; i < numRows; ++i) {
                Number value = (Number)this._rows.get(i)[this._colId];
                if (value == null) continue;
                values[i] = value.intValue();
            }
            return values;
        } else {
            if (this._storedType != FieldSpec.DataType.STRING) throw new IllegalStateException("Cannot read int values from data type: " + this._dataType);
            for (int i = 0; i < numRows; ++i) {
                String value = (String)this._rows.get(i)[this._colId];
                if (value == null) continue;
                values[i] = Integer.parseInt(value);
            }
        }
        return values;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long[] getLongValuesSV() {
        int numRows = this._rows.size();
        long[] values = new long[numRows];
        if (numRows == 0 || this._dataType == FieldSpec.DataType.UNKNOWN) {
            return values;
        }
        if (this._nullBitmap == null) {
            if (this._storedType.isNumeric()) {
                for (int i = 0; i < numRows; ++i) {
                    values[i] = ((Number)this._rows.get(i)[this._colId]).longValue();
                }
                return values;
            } else {
                if (this._storedType != FieldSpec.DataType.STRING) throw new IllegalStateException("Cannot read long values from data type: " + this._dataType);
                for (int i = 0; i < numRows; ++i) {
                    values[i] = Long.parseLong((String)this._rows.get(i)[this._colId]);
                }
            }
            return values;
        } else if (this._storedType.isNumeric()) {
            for (int i = 0; i < numRows; ++i) {
                Number value = (Number)this._rows.get(i)[this._colId];
                if (value == null) continue;
                values[i] = value.longValue();
            }
            return values;
        } else {
            if (this._storedType != FieldSpec.DataType.STRING) throw new IllegalStateException("Cannot read long values from data type: " + this._dataType);
            for (int i = 0; i < numRows; ++i) {
                String value = (String)this._rows.get(i)[this._colId];
                if (value == null) continue;
                values[i] = Long.parseLong(value);
            }
        }
        return values;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public float[] getFloatValuesSV() {
        int numRows = this._rows.size();
        float[] values = new float[numRows];
        if (numRows == 0 || this._dataType == FieldSpec.DataType.UNKNOWN) {
            return values;
        }
        if (this._nullBitmap == null) {
            if (this._storedType.isNumeric()) {
                for (int i = 0; i < numRows; ++i) {
                    values[i] = ((Number)this._rows.get(i)[this._colId]).floatValue();
                }
                return values;
            } else {
                if (this._storedType != FieldSpec.DataType.STRING) throw new IllegalStateException("Cannot read float values from data type: " + this._dataType);
                for (int i = 0; i < numRows; ++i) {
                    values[i] = Float.parseFloat((String)this._rows.get(i)[this._colId]);
                }
            }
            return values;
        } else if (this._storedType.isNumeric()) {
            for (int i = 0; i < numRows; ++i) {
                Number value = (Number)this._rows.get(i)[this._colId];
                if (value == null) continue;
                values[i] = value.floatValue();
            }
            return values;
        } else {
            if (this._storedType != FieldSpec.DataType.STRING) throw new IllegalStateException("Cannot read float values from data type: " + this._dataType);
            for (int i = 0; i < numRows; ++i) {
                String value = (String)this._rows.get(i)[this._colId];
                if (value == null) continue;
                values[i] = Float.parseFloat(value);
            }
        }
        return values;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double[] getDoubleValuesSV() {
        int numRows = this._rows.size();
        double[] values = new double[numRows];
        if (numRows == 0 || this._dataType == FieldSpec.DataType.UNKNOWN) {
            return values;
        }
        if (this._nullBitmap == null) {
            if (this._storedType.isNumeric()) {
                for (int i = 0; i < numRows; ++i) {
                    values[i] = ((Number)this._rows.get(i)[this._colId]).doubleValue();
                }
                return values;
            } else {
                if (this._storedType != FieldSpec.DataType.STRING) throw new IllegalStateException("Cannot read double values from data type: " + this._dataType);
                for (int i = 0; i < numRows; ++i) {
                    values[i] = Double.parseDouble((String)this._rows.get(i)[this._colId]);
                }
            }
            return values;
        } else if (this._storedType.isNumeric()) {
            for (int i = 0; i < numRows; ++i) {
                Number value = (Number)this._rows.get(i)[this._colId];
                if (value == null) continue;
                values[i] = value.doubleValue();
            }
            return values;
        } else {
            if (this._storedType != FieldSpec.DataType.STRING) throw new IllegalStateException("Cannot read double values from data type: " + this._dataType);
            for (int i = 0; i < numRows; ++i) {
                String value = (String)this._rows.get(i)[this._colId];
                if (value == null) continue;
                values[i] = Double.parseDouble(value);
            }
        }
        return values;
    }

    @Override
    public BigDecimal[] getBigDecimalValuesSV() {
        Object[] values;
        block23: {
            int numRows;
            block22: {
                numRows = this._rows.size();
                values = new BigDecimal[numRows];
                if (numRows == 0) {
                    return values;
                }
                if (this._dataType == FieldSpec.DataType.UNKNOWN) {
                    Arrays.fill(values, CommonConstants.NullValuePlaceHolder.BIG_DECIMAL);
                    return values;
                }
                if (this._nullBitmap != null) break block22;
                switch (this._storedType) {
                    case INT: 
                    case LONG: {
                        for (int i = 0; i < numRows; ++i) {
                            values[i] = BigDecimal.valueOf(((Number)this._rows.get(i)[this._colId]).longValue());
                        }
                        break block23;
                    }
                    case FLOAT: 
                    case DOUBLE: 
                    case STRING: {
                        for (int i = 0; i < numRows; ++i) {
                            values[i] = new BigDecimal(this._rows.get(i)[this._colId].toString());
                        }
                        break block23;
                    }
                    case BIG_DECIMAL: {
                        for (int i = 0; i < numRows; ++i) {
                            values[i] = (BigDecimal)this._rows.get(i)[this._colId];
                        }
                        break block23;
                    }
                    case BYTES: {
                        for (int i = 0; i < numRows; ++i) {
                            values[i] = BigDecimalUtils.deserialize((ByteArray)((ByteArray)this._rows.get(i)[this._colId]));
                        }
                        break block23;
                    }
                    default: {
                        throw new IllegalStateException("Cannot read BigDecimal values from data type: " + this._dataType);
                    }
                }
            }
            switch (this._storedType) {
                case INT: 
                case LONG: {
                    for (int i = 0; i < numRows; ++i) {
                        Number value = (Number)this._rows.get(i)[this._colId];
                        values[i] = value != null ? BigDecimal.valueOf(value.longValue()) : CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                    }
                    break;
                }
                case FLOAT: 
                case DOUBLE: 
                case STRING: {
                    for (int i = 0; i < numRows; ++i) {
                        Object value = this._rows.get(i)[this._colId];
                        values[i] = value != null ? new BigDecimal(value.toString()) : CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                    }
                    break;
                }
                case BIG_DECIMAL: {
                    for (int i = 0; i < numRows; ++i) {
                        BigDecimal value = (BigDecimal)this._rows.get(i)[this._colId];
                        values[i] = value != null ? value : CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                    }
                    break;
                }
                case BYTES: {
                    for (int i = 0; i < numRows; ++i) {
                        ByteArray value = (ByteArray)this._rows.get(i)[this._colId];
                        values[i] = value != null ? BigDecimalUtils.deserialize((ByteArray)value) : CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot read BigDecimal values from data type: " + this._dataType);
                }
            }
        }
        return values;
    }

    @Override
    public String[] getStringValuesSV() {
        int numRows = this._rows.size();
        Object[] values = new String[numRows];
        if (numRows == 0) {
            return values;
        }
        if (this._dataType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill(values, "");
            return values;
        }
        if (this._nullBitmap == null) {
            for (int i = 0; i < numRows; ++i) {
                values[i] = this._rows.get(i)[this._colId].toString();
            }
        } else {
            for (int i = 0; i < numRows; ++i) {
                Object value = this._rows.get(i)[this._colId];
                values[i] = value != null ? value.toString() : "";
            }
        }
        return values;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[][] getBytesValuesSV() {
        int numRows = this._rows.size();
        byte[][] values = new byte[numRows][];
        if (numRows == 0) {
            return values;
        }
        if (this._dataType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill((Object[])values, CommonConstants.NullValuePlaceHolder.BYTES);
            return values;
        }
        if (this._nullBitmap == null) {
            if (this._storedType != FieldSpec.DataType.BYTES) throw new IllegalStateException("Cannot read bytes values from data type: " + this._dataType);
            for (int i = 0; i < numRows; ++i) {
                values[i] = ((ByteArray)this._rows.get(i)[this._colId]).getBytes();
            }
            return values;
        } else {
            if (this._storedType != FieldSpec.DataType.BYTES) throw new IllegalStateException("Cannot read bytes values from data type: " + this._dataType);
            for (int i = 0; i < numRows; ++i) {
                ByteArray value = (ByteArray)this._rows.get(i)[this._colId];
                values[i] = value != null ? value.getBytes() : CommonConstants.NullValuePlaceHolder.BYTES;
            }
        }
        return values;
    }

    @Override
    public int[][] getDictionaryIdsMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] getIntValuesMV() {
        int numRows = this._rows.size();
        int[][] values = new int[numRows][];
        if (numRows == 0) {
            return values;
        }
        if (this._dataType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill((Object[])values, new int[0]);
            return values;
        }
        for (int i = 0; i < numRows; ++i) {
            Object storedValue = this._rows.get(i)[this._colId];
            if (storedValue instanceof int[]) {
                values[i] = (int[])storedValue;
                continue;
            }
            if (storedValue instanceof long[]) {
                long[] longArray = (long[])storedValue;
                values[i] = new int[longArray.length];
                ArrayCopyUtils.copy((long[])longArray, (int[])values[i], (int)longArray.length);
                continue;
            }
            if (storedValue instanceof float[]) {
                float[] floatArray = (float[])storedValue;
                values[i] = new int[floatArray.length];
                ArrayCopyUtils.copy((float[])floatArray, (int[])values[i], (int)floatArray.length);
                continue;
            }
            if (storedValue instanceof double[]) {
                double[] doubleArray = (double[])storedValue;
                values[i] = new int[doubleArray.length];
                ArrayCopyUtils.copy((double[])doubleArray, (int[])values[i], (int)doubleArray.length);
                continue;
            }
            if (storedValue instanceof String[]) {
                String[] stringArray = (String[])storedValue;
                values[i] = new int[stringArray.length];
                for (int j = 0; j < stringArray.length; ++j) {
                    values[i][j] = Integer.parseInt(stringArray[j]);
                }
                continue;
            }
            throw new IllegalStateException("Unsupported data type: " + storedValue.getClass().getName());
        }
        return values;
    }

    @Override
    public long[][] getLongValuesMV() {
        int numRows = this._rows.size();
        long[][] values = new long[numRows][];
        if (numRows == 0) {
            return values;
        }
        if (this._dataType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill((Object[])values, new long[0]);
            return values;
        }
        for (int i = 0; i < numRows; ++i) {
            Object storedValue = this._rows.get(i)[this._colId];
            if (storedValue instanceof int[]) {
                int[] intArray = (int[])storedValue;
                values[i] = new long[intArray.length];
                ArrayCopyUtils.copy((int[])intArray, (long[])values[i], (int)intArray.length);
                continue;
            }
            if (storedValue instanceof long[]) {
                values[i] = (long[])storedValue;
                continue;
            }
            if (storedValue instanceof float[]) {
                float[] floatArray = (float[])storedValue;
                values[i] = new long[floatArray.length];
                ArrayCopyUtils.copy((float[])floatArray, (long[])values[i], (int)floatArray.length);
                continue;
            }
            if (storedValue instanceof double[]) {
                double[] doubleArray = (double[])storedValue;
                values[i] = new long[doubleArray.length];
                ArrayCopyUtils.copy((double[])doubleArray, (long[])values[i], (int)doubleArray.length);
                continue;
            }
            if (storedValue instanceof String[]) {
                String[] stringArray = (String[])storedValue;
                values[i] = new long[stringArray.length];
                for (int j = 0; j < stringArray.length; ++j) {
                    values[i][j] = Long.parseLong(stringArray[j]);
                }
                continue;
            }
            throw new IllegalStateException("Unsupported data type: " + storedValue.getClass().getName());
        }
        return values;
    }

    @Override
    public float[][] getFloatValuesMV() {
        int numRows = this._rows.size();
        float[][] values = new float[numRows][];
        if (numRows == 0) {
            return values;
        }
        if (this._dataType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill((Object[])values, new float[0]);
            return values;
        }
        for (int i = 0; i < numRows; ++i) {
            Object storedValue = this._rows.get(i)[this._colId];
            if (storedValue instanceof int[]) {
                int[] intArray = (int[])storedValue;
                values[i] = new float[intArray.length];
                ArrayCopyUtils.copy((int[])intArray, (float[])values[i], (int)intArray.length);
                continue;
            }
            if (storedValue instanceof long[]) {
                long[] longArray = (long[])storedValue;
                values[i] = new float[longArray.length];
                ArrayCopyUtils.copy((long[])longArray, (float[])values[i], (int)longArray.length);
                continue;
            }
            if (storedValue instanceof float[]) {
                values[i] = (float[])storedValue;
                continue;
            }
            if (storedValue instanceof double[]) {
                double[] doubleArray = (double[])storedValue;
                values[i] = new float[doubleArray.length];
                ArrayCopyUtils.copy((double[])doubleArray, (float[])values[i], (int)doubleArray.length);
                continue;
            }
            if (storedValue instanceof String[]) {
                String[] stringArray = (String[])storedValue;
                values[i] = new float[stringArray.length];
                for (int j = 0; j < stringArray.length; ++j) {
                    values[i][j] = Float.parseFloat(stringArray[j]);
                }
                continue;
            }
            throw new IllegalStateException("Unsupported data type: " + storedValue.getClass().getName());
        }
        return values;
    }

    @Override
    public double[][] getDoubleValuesMV() {
        int numRows = this._rows.size();
        double[][] values = new double[numRows][];
        if (numRows == 0) {
            return values;
        }
        if (this._dataType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill((Object[])values, new double[0]);
            return values;
        }
        for (int i = 0; i < numRows; ++i) {
            Object storedValue = this._rows.get(i)[this._colId];
            if (storedValue instanceof int[]) {
                int[] intArray = (int[])storedValue;
                values[i] = new double[intArray.length];
                ArrayCopyUtils.copy((int[])intArray, (double[])values[i], (int)intArray.length);
                continue;
            }
            if (storedValue instanceof long[]) {
                long[] longArray = (long[])storedValue;
                values[i] = new double[longArray.length];
                ArrayCopyUtils.copy((long[])longArray, (double[])values[i], (int)longArray.length);
                continue;
            }
            if (storedValue instanceof float[]) {
                float[] floatArray = (float[])storedValue;
                values[i] = new double[floatArray.length];
                ArrayCopyUtils.copy((float[])floatArray, (double[])values[i], (int)floatArray.length);
                continue;
            }
            if (storedValue instanceof double[]) {
                values[i] = (double[])storedValue;
                continue;
            }
            if (storedValue instanceof String[]) {
                String[] stringArray = (String[])storedValue;
                values[i] = new double[stringArray.length];
                for (int j = 0; j < stringArray.length; ++j) {
                    values[i][j] = Double.parseDouble(stringArray[j]);
                }
                continue;
            }
            throw new IllegalStateException("Unsupported data type: " + storedValue.getClass().getName());
        }
        return values;
    }

    @Override
    public String[][] getStringValuesMV() {
        int numRows = this._rows.size();
        String[][] values = new String[numRows][];
        if (numRows == 0) {
            return values;
        }
        if (this._dataType == FieldSpec.DataType.UNKNOWN) {
            Arrays.fill((Object[])values, new String[0]);
            return values;
        }
        for (int i = 0; i < numRows; ++i) {
            int j;
            Object storedValue = this._rows.get(i)[this._colId];
            if (storedValue instanceof int[]) {
                int[] intArray = (int[])storedValue;
                values[i] = new String[intArray.length];
                for (j = 0; j < intArray.length; ++j) {
                    values[i][j] = Integer.toString(intArray[j]);
                }
                continue;
            }
            if (storedValue instanceof long[]) {
                long[] longArray = (long[])storedValue;
                values[i] = new String[longArray.length];
                for (j = 0; j < longArray.length; ++j) {
                    values[i][j] = Long.toString(longArray[j]);
                }
                continue;
            }
            if (storedValue instanceof float[]) {
                float[] floatArray = (float[])storedValue;
                values[i] = new String[floatArray.length];
                for (j = 0; j < floatArray.length; ++j) {
                    values[i][j] = Float.toString(floatArray[j]);
                }
                continue;
            }
            if (storedValue instanceof double[]) {
                double[] doubleArray = (double[])storedValue;
                values[i] = new String[doubleArray.length];
                for (j = 0; j < doubleArray.length; ++j) {
                    values[i][j] = Double.toString(doubleArray[j]);
                }
                continue;
            }
            if (storedValue instanceof String[]) {
                values[i] = (String[])storedValue;
                continue;
            }
            throw new IllegalStateException("Unsupported data type: " + storedValue.getClass().getName());
        }
        return values;
    }

    @Override
    public byte[][][] getBytesValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getNumMVEntries() {
        throw new UnsupportedOperationException();
    }
}

