/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.operator.docidsets.AndDocIdSet;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.docidsets.EmptyDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public abstract class BaseColumnFilterOperator
extends BaseFilterOperator {
    protected final QueryContext _queryContext;
    protected final DataSource _dataSource;

    protected BaseColumnFilterOperator(QueryContext queryContext, DataSource dataSource, int numDocs) {
        super(numDocs, queryContext.isNullHandlingEnabled());
        this._queryContext = queryContext;
        this._dataSource = dataSource;
    }

    protected abstract BlockDocIdSet getNextBlockWithoutNullHandling();

    @Override
    protected BlockDocIdSet getTrues() {
        ImmutableRoaringBitmap nullBitmap;
        if (this._nullHandlingEnabled && (nullBitmap = this.getNullBitmap()) != null && !nullBitmap.isEmpty()) {
            return this.excludeNulls(this.getNextBlockWithoutNullHandling(), nullBitmap);
        }
        return this.getNextBlockWithoutNullHandling();
    }

    @Override
    protected BlockDocIdSet getNulls() {
        ImmutableRoaringBitmap nullBitmap = this.getNullBitmap();
        if (nullBitmap != null && !nullBitmap.isEmpty()) {
            return new BitmapDocIdSet(nullBitmap, this._numDocs);
        }
        return EmptyDocIdSet.getInstance();
    }

    private BlockDocIdSet excludeNulls(BlockDocIdSet blockDocIdSet, ImmutableRoaringBitmap nullBitmap) {
        return new AndDocIdSet(Arrays.asList(blockDocIdSet, new BitmapDocIdSet((ImmutableRoaringBitmap)ImmutableRoaringBitmap.flip((ImmutableRoaringBitmap)nullBitmap, (long)0L, (long)this._numDocs), this._numDocs)), this._queryContext.getQueryOptions());
    }

    @Nullable
    private ImmutableRoaringBitmap getNullBitmap() {
        NullValueVectorReader nullValueVector = this._dataSource.getNullValueVector();
        if (nullValueVector != null) {
            return nullValueVector.getNullBitmap();
        }
        return null;
    }
}

