/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Arrays;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.EmptyDocIdSet;
import org.apache.pinot.core.operator.docidsets.MatchAllDocIdSet;
import org.apache.pinot.core.operator.docidsets.NotDocIdSet;
import org.apache.pinot.core.operator.docidsets.OrDocIdSet;
import org.apache.pinot.core.operator.filter.BitmapCollection;

public abstract class BaseFilterOperator
extends BaseOperator<FilterBlock> {
    protected final int _numDocs;
    protected final boolean _nullHandlingEnabled;

    public BaseFilterOperator(int numDocs, boolean nullHandlingEnabled) {
        this._numDocs = numDocs;
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    public boolean isResultEmpty() {
        return false;
    }

    public boolean isResultMatchingAll() {
        return false;
    }

    public boolean canOptimizeCount() {
        return false;
    }

    public int getNumMatchingDocs() {
        throw new UnsupportedOperationException();
    }

    public boolean canProduceBitmaps() {
        return false;
    }

    public BitmapCollection getBitmaps() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected FilterBlock getNextBlock() {
        return new FilterBlock(this.getTrues());
    }

    protected abstract BlockDocIdSet getTrues();

    protected BlockDocIdSet getNulls() {
        return EmptyDocIdSet.getInstance();
    }

    protected BlockDocIdSet getFalses() {
        BlockDocIdSet nulls;
        BlockDocIdSet trues = this.getTrues();
        if (trues instanceof MatchAllDocIdSet) {
            return EmptyDocIdSet.getInstance();
        }
        if (this._nullHandlingEnabled && !((nulls = this.getNulls()) instanceof EmptyDocIdSet)) {
            return new NotDocIdSet(new OrDocIdSet(Arrays.asList(trues, nulls), this._numDocs), this._numDocs);
        }
        if (trues instanceof EmptyDocIdSet) {
            return new MatchAllDocIdSet(this._numDocs);
        }
        return new NotDocIdSet(trues, this._numDocs);
    }
}

