/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import com.google.common.base.CaseFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.ExplainAttributeBuilder;
import org.apache.pinot.core.operator.dociditerators.ExpressionScanDocIdIterator;
import org.apache.pinot.core.operator.docidsets.ExpressionDocIdSet;
import org.apache.pinot.core.operator.docidsets.NotDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluatorProvider;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunctionFactory;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class ExpressionFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_EXPRESSION";
    private final QueryContext _queryContext;
    private final Map<String, DataSource> _dataSourceMap;
    private final TransformFunction _transformFunction;
    private final Predicate.Type _predicateType;
    private final PredicateEvaluator _predicateEvaluator;

    public ExpressionFilterOperator(IndexSegment segment, QueryContext queryContext, Predicate predicate, int numDocs) {
        super(numDocs, queryContext.isNullHandlingEnabled());
        this._queryContext = queryContext;
        HashSet columns = new HashSet();
        ExpressionContext lhs = predicate.getLhs();
        lhs.getColumns(columns);
        int mapCapacity = HashUtil.getHashMapCapacity((int)columns.size());
        this._dataSourceMap = new HashMap<String, DataSource>(mapCapacity);
        HashMap<String, ColumnContext> columnContextMap = new HashMap<String, ColumnContext>(mapCapacity);
        columns.forEach(column -> {
            DataSource dataSource = segment.getDataSource(column);
            this._dataSourceMap.put((String)column, dataSource);
            columnContextMap.put((String)column, ColumnContext.fromDataSource(dataSource));
        });
        this._transformFunction = TransformFunctionFactory.get(lhs, columnContextMap, this._queryContext);
        this._predicateType = predicate.getType();
        this._predicateEvaluator = this._predicateType == Predicate.Type.IS_NULL || this._predicateType == Predicate.Type.IS_NOT_NULL ? null : PredicateEvaluatorProvider.getPredicateEvaluator(predicate, this._transformFunction.getDictionary(), this._transformFunction.getResultMetadata().getDataType());
    }

    @Override
    protected BlockDocIdSet getTrues() {
        if (this._predicateType == Predicate.Type.IS_NULL) {
            return this.getNulls();
        }
        if (this._predicateType == Predicate.Type.IS_NOT_NULL) {
            return new NotDocIdSet(this.getNulls(), this._numDocs);
        }
        return new ExpressionDocIdSet(this._transformFunction, this._predicateEvaluator, this._dataSourceMap, this._numDocs, this._queryContext.isNullHandlingEnabled(), ExpressionScanDocIdIterator.PredicateEvaluationResult.TRUE);
    }

    @Override
    protected BlockDocIdSet getNulls() {
        return new ExpressionDocIdSet(this._transformFunction, null, this._dataSourceMap, this._numDocs, this._queryContext.isNullHandlingEnabled(), ExpressionScanDocIdIterator.PredicateEvaluationResult.NULL);
    }

    @Override
    protected BlockDocIdSet getFalses() {
        if (this._predicateType == Predicate.Type.IS_NULL) {
            return new NotDocIdSet(this.getNulls(), this._numDocs);
        }
        if (this._predicateType == Predicate.Type.IS_NOT_NULL) {
            return this.getNulls();
        }
        return new ExpressionDocIdSet(this._transformFunction, this._predicateEvaluator, this._dataSourceMap, this._numDocs, this._queryContext.isNullHandlingEnabled(), ExpressionScanDocIdIterator.PredicateEvaluationResult.FALSE);
    }

    @Override
    public List<Operator<?>> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(operator:").append(this._predicateEvaluator.getPredicateType());
        stringBuilder.append(",predicate:").append(this._predicateEvaluator.getPredicate().toString());
        return stringBuilder.append(')').toString();
    }

    @Override
    protected String getExplainName() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, EXPLAIN_NAME);
    }

    @Override
    protected void explainAttributes(ExplainAttributeBuilder attributeBuilder) {
        super.explainAttributes(attributeBuilder);
        attributeBuilder.putString("operator", this._predicateEvaluator.getPredicateType().name());
        attributeBuilder.putString("predicate", this._predicateEvaluator.getPredicate().toString());
    }
}

