/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.filter.AndFilterOperator;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapBasedFilterOperator;
import org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.core.operator.filter.ExpressionFilterOperator;
import org.apache.pinot.core.operator.filter.H3InclusionIndexFilterOperator;
import org.apache.pinot.core.operator.filter.H3IndexFilterOperator;
import org.apache.pinot.core.operator.filter.InvertedIndexFilterOperator;
import org.apache.pinot.core.operator.filter.JsonMatchFilterOperator;
import org.apache.pinot.core.operator.filter.MatchAllFilterOperator;
import org.apache.pinot.core.operator.filter.NotFilterOperator;
import org.apache.pinot.core.operator.filter.OrFilterOperator;
import org.apache.pinot.core.operator.filter.PrioritizedFilterOperator;
import org.apache.pinot.core.operator.filter.RangeIndexBasedFilterOperator;
import org.apache.pinot.core.operator.filter.ScanBasedFilterOperator;
import org.apache.pinot.core.operator.filter.SortedIndexBasedFilterOperator;
import org.apache.pinot.core.operator.filter.TextContainsFilterOperator;
import org.apache.pinot.core.operator.filter.TextMatchFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class FilterOperatorUtils {
    private static Implementation _instance = new DefaultImplementation();

    private FilterOperatorUtils() {
    }

    public static void setImplementation(Implementation newImplementation) {
        _instance = newImplementation;
    }

    public static BaseFilterOperator getLeafFilterOperator(QueryContext queryContext, PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        return _instance.getLeafFilterOperator(queryContext, predicateEvaluator, dataSource, numDocs);
    }

    public static BaseFilterOperator getAndFilterOperator(QueryContext queryContext, List<BaseFilterOperator> filterOperators, int numDocs) {
        return _instance.getAndFilterOperator(queryContext, filterOperators, numDocs);
    }

    public static BaseFilterOperator getOrFilterOperator(QueryContext queryContext, List<BaseFilterOperator> filterOperators, int numDocs) {
        return _instance.getOrFilterOperator(queryContext, filterOperators, numDocs);
    }

    public static BaseFilterOperator getNotFilterOperator(QueryContext queryContext, BaseFilterOperator filterOperator, int numDocs) {
        return _instance.getNotFilterOperator(queryContext, filterOperator, numDocs);
    }

    public static class DefaultImplementation
    implements Implementation {
        @Override
        public BaseFilterOperator getLeafFilterOperator(QueryContext queryContext, PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
            if (predicateEvaluator.isAlwaysFalse()) {
                return EmptyFilterOperator.getInstance();
            }
            if (predicateEvaluator.isAlwaysTrue()) {
                ImmutableRoaringBitmap nullBitmap;
                NullValueVectorReader nullValueVectorReader;
                if (queryContext.isNullHandlingEnabled() && (nullValueVectorReader = dataSource.getNullValueVector()) != null && (nullBitmap = nullValueVectorReader.getNullBitmap()) != null && !nullBitmap.isEmpty()) {
                    return new BitmapBasedFilterOperator(nullBitmap, true, numDocs);
                }
                return new MatchAllFilterOperator(numDocs);
            }
            Predicate.Type predicateType = predicateEvaluator.getPredicateType();
            if (predicateType == Predicate.Type.RANGE) {
                if (dataSource.getDataSourceMetadata().isSorted() && dataSource.getDictionary() != null && queryContext.isIndexUseAllowed(dataSource, FieldConfig.IndexType.SORTED)) {
                    return new SortedIndexBasedFilterOperator(queryContext, predicateEvaluator, dataSource, numDocs);
                }
                if (RangeIndexBasedFilterOperator.canEvaluate(predicateEvaluator, dataSource) && queryContext.isIndexUseAllowed(dataSource, FieldConfig.IndexType.RANGE)) {
                    return new RangeIndexBasedFilterOperator(queryContext, predicateEvaluator, dataSource, numDocs);
                }
                return new ScanBasedFilterOperator(queryContext, predicateEvaluator, dataSource, numDocs);
            }
            if (predicateType == Predicate.Type.REGEXP_LIKE) {
                if (dataSource.getFSTIndex() != null && dataSource.getDataSourceMetadata().isSorted() && queryContext.isIndexUseAllowed(dataSource, FieldConfig.IndexType.SORTED)) {
                    return new SortedIndexBasedFilterOperator(queryContext, predicateEvaluator, dataSource, numDocs);
                }
                if (dataSource.getFSTIndex() != null && dataSource.getInvertedIndex() != null && queryContext.isIndexUseAllowed(dataSource, FieldConfig.IndexType.INVERTED)) {
                    return new InvertedIndexFilterOperator(queryContext, predicateEvaluator, dataSource, numDocs);
                }
                return new ScanBasedFilterOperator(queryContext, predicateEvaluator, dataSource, numDocs);
            }
            if (dataSource.getDataSourceMetadata().isSorted() && dataSource.getDictionary() != null && queryContext.isIndexUseAllowed(dataSource, FieldConfig.IndexType.SORTED)) {
                return new SortedIndexBasedFilterOperator(queryContext, predicateEvaluator, dataSource, numDocs);
            }
            if (dataSource.getInvertedIndex() != null && queryContext.isIndexUseAllowed(dataSource, FieldConfig.IndexType.INVERTED)) {
                return new InvertedIndexFilterOperator(queryContext, predicateEvaluator, dataSource, numDocs);
            }
            if (RangeIndexBasedFilterOperator.canEvaluate(predicateEvaluator, dataSource) && queryContext.isIndexUseAllowed(dataSource, FieldConfig.IndexType.RANGE)) {
                return new RangeIndexBasedFilterOperator(queryContext, predicateEvaluator, dataSource, numDocs);
            }
            return new ScanBasedFilterOperator(queryContext, predicateEvaluator, dataSource, numDocs);
        }

        @Override
        public BaseFilterOperator getAndFilterOperator(QueryContext queryContext, List<BaseFilterOperator> filterOperators, int numDocs) {
            ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(filterOperators.size());
            for (BaseFilterOperator filterOperator : filterOperators) {
                if (filterOperator.isResultEmpty()) {
                    return EmptyFilterOperator.getInstance();
                }
                if (filterOperator.isResultMatchingAll()) continue;
                childFilterOperators.add(filterOperator);
            }
            int numChildFilterOperators = childFilterOperators.size();
            if (numChildFilterOperators == 0) {
                return new MatchAllFilterOperator(numDocs);
            }
            if (numChildFilterOperators == 1) {
                return (BaseFilterOperator)childFilterOperators.get(0);
            }
            this.reorderAndFilterChildOperators(queryContext, childFilterOperators);
            return new AndFilterOperator(childFilterOperators, queryContext.getQueryOptions(), numDocs, queryContext.isNullHandlingEnabled());
        }

        @Override
        public BaseFilterOperator getOrFilterOperator(QueryContext queryContext, List<BaseFilterOperator> filterOperators, int numDocs) {
            ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(filterOperators.size());
            for (BaseFilterOperator filterOperator : filterOperators) {
                if (filterOperator.isResultMatchingAll()) {
                    return new MatchAllFilterOperator(numDocs);
                }
                if (filterOperator.isResultEmpty()) continue;
                childFilterOperators.add(filterOperator);
            }
            int numChildFilterOperators = childFilterOperators.size();
            if (numChildFilterOperators == 0) {
                return EmptyFilterOperator.getInstance();
            }
            if (numChildFilterOperators == 1) {
                return (BaseFilterOperator)childFilterOperators.get(0);
            }
            return new OrFilterOperator(childFilterOperators, queryContext.getQueryOptions(), numDocs, queryContext.isNullHandlingEnabled());
        }

        @Override
        public BaseFilterOperator getNotFilterOperator(QueryContext queryContext, BaseFilterOperator filterOperator, int numDocs) {
            if (filterOperator.isResultMatchingAll()) {
                return EmptyFilterOperator.getInstance();
            }
            if (filterOperator.isResultEmpty()) {
                return new MatchAllFilterOperator(numDocs);
            }
            return new NotFilterOperator(filterOperator, numDocs, queryContext.isNullHandlingEnabled());
        }

        protected void reorderAndFilterChildOperators(final QueryContext queryContext, List<BaseFilterOperator> filterOperators) {
            filterOperators.sort(new Comparator<BaseFilterOperator>(){

                @Override
                public int compare(BaseFilterOperator o1, BaseFilterOperator o2) {
                    return this.getPriority(o1) - this.getPriority(o2);
                }

                int getPriority(BaseFilterOperator filterOperator) {
                    OptionalInt priority;
                    if (filterOperator instanceof PrioritizedFilterOperator && (priority = ((PrioritizedFilterOperator)((Object)filterOperator)).getPriority()).isPresent()) {
                        return priority.getAsInt();
                    }
                    if (filterOperator instanceof SortedIndexBasedFilterOperator) {
                        return 0;
                    }
                    if (filterOperator instanceof BitmapBasedFilterOperator || filterOperator instanceof InvertedIndexFilterOperator) {
                        return 100;
                    }
                    if (filterOperator instanceof RangeIndexBasedFilterOperator || filterOperator instanceof TextContainsFilterOperator || filterOperator instanceof TextMatchFilterOperator || filterOperator instanceof JsonMatchFilterOperator || filterOperator instanceof H3IndexFilterOperator || filterOperator instanceof H3InclusionIndexFilterOperator) {
                        return 200;
                    }
                    if (filterOperator instanceof AndFilterOperator) {
                        return 300;
                    }
                    if (filterOperator instanceof OrFilterOperator) {
                        return 400;
                    }
                    if (filterOperator instanceof NotFilterOperator) {
                        return this.getPriority(((NotFilterOperator)filterOperator).getChildFilterOperator());
                    }
                    if (filterOperator instanceof ScanBasedFilterOperator) {
                        int basePriority = 500;
                        return DefaultImplementation.getScanBasedFilterPriority(queryContext, (ScanBasedFilterOperator)filterOperator, basePriority);
                    }
                    if (filterOperator instanceof ExpressionFilterOperator) {
                        return 1000;
                    }
                    return 10000;
                }
            });
        }

        public static int getScanBasedFilterPriority(QueryContext queryContext, ScanBasedFilterOperator scanBasedFilterOperator, int basePriority) {
            if (queryContext.isSkipScanFilterReorder()) {
                return basePriority;
            }
            if (scanBasedFilterOperator.getDataSourceMetadata().isSingleValue()) {
                return basePriority;
            }
            return basePriority + 50;
        }
    }

    public static interface Implementation {
        public BaseFilterOperator getLeafFilterOperator(QueryContext var1, PredicateEvaluator var2, DataSource var3, int var4);

        public BaseFilterOperator getAndFilterOperator(QueryContext var1, List<BaseFilterOperator> var2, int var3);

        public BaseFilterOperator getOrFilterOperator(QueryContext var1, List<BaseFilterOperator> var2, int var3);

        public BaseFilterOperator getNotFilterOperator(QueryContext var1, BaseFilterOperator var2, int var3);
    }
}

