/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import com.google.common.base.CaseFormat;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.ExplainPlanRows;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.ExplainAttributeBuilder;
import org.apache.pinot.core.operator.docidsets.MatchAllDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;

public class MatchAllFilterOperator
extends BaseFilterOperator {
    public static final String EXPLAIN_NAME = "FILTER_MATCH_ENTIRE_SEGMENT";

    public MatchAllFilterOperator(int numDocs) {
        super(numDocs, false);
    }

    @Override
    public final boolean isResultMatchingAll() {
        return true;
    }

    @Override
    protected BlockDocIdSet getTrues() {
        return new MatchAllDocIdSet(this._numDocs);
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public boolean canOptimizeCount() {
        return true;
    }

    @Override
    public int getNumMatchingDocs() {
        return this._numDocs;
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME + "(docs:" + this._numDocs + ')';
    }

    @Override
    protected String getExplainName() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, EXPLAIN_NAME);
    }

    @Override
    protected void explainAttributes(ExplainAttributeBuilder attributeBuilder) {
        super.explainAttributes(attributeBuilder);
        attributeBuilder.putLong("numDocs", this._numDocs);
    }

    @Override
    public void prepareForExplainPlan(ExplainPlanRows explainPlanRows) {
        explainPlanRows.setHasMatchAllFilter(true);
    }
}

