/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.ExplainAttributeBuilder;
import org.apache.pinot.core.operator.docidsets.SortedDocIdSet;
import org.apache.pinot.core.operator.filter.BaseColumnFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapCollection;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.RangePredicateEvaluatorFactory;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.SortedIndexReader;
import org.apache.pinot.spi.utils.Pairs;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class SortedIndexBasedFilterOperator
extends BaseColumnFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_SORTED_INDEX";
    private final PredicateEvaluator _predicateEvaluator;
    private final SortedIndexReader<?> _sortedIndexReader;

    SortedIndexBasedFilterOperator(QueryContext queryContext, PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        super(queryContext, dataSource, numDocs);
        this._predicateEvaluator = predicateEvaluator;
        this._sortedIndexReader = (SortedIndexReader)dataSource.getInvertedIndex();
    }

    @Override
    protected BlockDocIdSet getNextBlockWithoutNullHandling() {
        if (this._predicateEvaluator instanceof RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator) {
            RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator rangePredicateEvaluator = (RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator)this._predicateEvaluator;
            int startDocId = ((Pairs.IntPair)this._sortedIndexReader.getDocIds(rangePredicateEvaluator.getStartDictId())).getLeft();
            int endDocId = ((Pairs.IntPair)this._sortedIndexReader.getDocIds(rangePredicateEvaluator.getEndDictId() - 1)).getRight();
            return new SortedDocIdSet(Collections.singletonList(new Pairs.IntPair(startDocId, endDocId)));
        }
        boolean exclusive = this._predicateEvaluator.isExclusive();
        int[] dictIds = exclusive ? this._predicateEvaluator.getNonMatchingDictIds() : this._predicateEvaluator.getMatchingDictIds();
        int numDictIds = dictIds.length;
        Preconditions.checkState((numDictIds > 0 ? 1 : 0) != 0);
        if (numDictIds == 1) {
            Pairs.IntPair docIdRange = (Pairs.IntPair)this._sortedIndexReader.getDocIds(dictIds[0]);
            if (exclusive) {
                int lastDocId;
                ArrayList<Pairs.IntPair> docIdRanges = new ArrayList<Pairs.IntPair>(2);
                int firstDocId = docIdRange.getLeft();
                if (firstDocId > 0) {
                    docIdRanges.add(new Pairs.IntPair(0, firstDocId - 1));
                }
                if ((lastDocId = docIdRange.getRight()) < this._numDocs - 1) {
                    docIdRanges.add(new Pairs.IntPair(lastDocId + 1, this._numDocs - 1));
                }
                return new SortedDocIdSet(docIdRanges);
            }
            return new SortedDocIdSet(Collections.singletonList(docIdRange));
        }
        ArrayList<Pairs.IntPair> docIdRanges = new ArrayList<Pairs.IntPair>();
        Pairs.IntPair lastDocIdRange = (Pairs.IntPair)this._sortedIndexReader.getDocIds(dictIds[0]);
        for (int i = 1; i < numDictIds; ++i) {
            Pairs.IntPair docIdRange = (Pairs.IntPair)this._sortedIndexReader.getDocIds(dictIds[i]);
            if (docIdRange.getLeft() == lastDocIdRange.getRight() + 1) {
                lastDocIdRange.setRight(docIdRange.getRight());
                continue;
            }
            docIdRanges.add(lastDocIdRange);
            lastDocIdRange = docIdRange;
        }
        docIdRanges.add(lastDocIdRange);
        if (exclusive) {
            int numDocIdRanges = docIdRanges.size();
            ArrayList<Pairs.IntPair> invertedDocIdRanges = new ArrayList<Pairs.IntPair>(numDocIdRanges + 1);
            int firstDocId = ((Pairs.IntPair)docIdRanges.get(0)).getLeft();
            if (firstDocId > 0) {
                invertedDocIdRanges.add(new Pairs.IntPair(0, firstDocId - 1));
            }
            for (int i = 0; i < numDocIdRanges - 1; ++i) {
                invertedDocIdRanges.add(new Pairs.IntPair(((Pairs.IntPair)docIdRanges.get(i)).getRight() + 1, ((Pairs.IntPair)docIdRanges.get(i + 1)).getLeft() - 1));
            }
            int lastDocId = ((Pairs.IntPair)docIdRanges.get(numDocIdRanges - 1)).getRight();
            if (lastDocId < this._numDocs - 1) {
                invertedDocIdRanges.add(new Pairs.IntPair(lastDocId + 1, this._numDocs - 1));
            }
            docIdRanges = invertedDocIdRanges;
        }
        return new SortedDocIdSet(docIdRanges);
    }

    @Override
    public boolean canOptimizeCount() {
        return true;
    }

    @Override
    public int getNumMatchingDocs() {
        int count = 0;
        boolean exclusive = this._predicateEvaluator.isExclusive();
        if (this._predicateEvaluator instanceof RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator) {
            RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator rangePredicateEvaluator = (RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator)this._predicateEvaluator;
            int startDocId = ((Pairs.IntPair)this._sortedIndexReader.getDocIds(rangePredicateEvaluator.getStartDictId())).getLeft();
            int endDocId = ((Pairs.IntPair)this._sortedIndexReader.getDocIds(rangePredicateEvaluator.getEndDictId() - 1)).getRight();
            count = endDocId - startDocId + 1;
        } else {
            int[] dictIds = exclusive ? this._predicateEvaluator.getNonMatchingDictIds() : this._predicateEvaluator.getMatchingDictIds();
            int numDictIds = dictIds.length;
            Preconditions.checkState((numDictIds > 0 ? 1 : 0) != 0);
            if (numDictIds == 1) {
                Pairs.IntPair docIdRange = (Pairs.IntPair)this._sortedIndexReader.getDocIds(dictIds[0]);
                count = docIdRange.getRight() - docIdRange.getLeft() + 1;
            } else {
                Pairs.IntPair lastDocIdRange = (Pairs.IntPair)this._sortedIndexReader.getDocIds(dictIds[0]);
                for (int i = 1; i < numDictIds; ++i) {
                    Pairs.IntPair docIdRange = (Pairs.IntPair)this._sortedIndexReader.getDocIds(dictIds[i]);
                    if (docIdRange.getLeft() == lastDocIdRange.getRight() + 1) {
                        lastDocIdRange.setRight(docIdRange.getRight());
                        continue;
                    }
                    count += lastDocIdRange.getRight() - lastDocIdRange.getLeft() + 1;
                    lastDocIdRange = docIdRange;
                }
                count += lastDocIdRange.getRight() - lastDocIdRange.getLeft() + 1;
            }
        }
        return exclusive ? this._numDocs - count : count;
    }

    @Override
    public boolean canProduceBitmaps() {
        return true;
    }

    @Override
    public BitmapCollection getBitmaps() {
        MutableRoaringBitmap bitmap = new MutableRoaringBitmap();
        boolean exclusive = this._predicateEvaluator.isExclusive();
        if (this._predicateEvaluator instanceof RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator) {
            RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator rangePredicateEvaluator = (RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator)this._predicateEvaluator;
            int startDocId = ((Pairs.IntPair)this._sortedIndexReader.getDocIds(rangePredicateEvaluator.getStartDictId())).getLeft();
            int endDocId = ((Pairs.IntPair)this._sortedIndexReader.getDocIds(rangePredicateEvaluator.getEndDictId() - 1)).getRight();
            bitmap.add((long)startDocId, (long)endDocId + 1L);
        } else {
            int[] dictIds = exclusive ? this._predicateEvaluator.getNonMatchingDictIds() : this._predicateEvaluator.getMatchingDictIds();
            int numDictIds = dictIds.length;
            Preconditions.checkState((numDictIds > 0 ? 1 : 0) != 0);
            if (numDictIds == 1) {
                Pairs.IntPair docIdRange = (Pairs.IntPair)this._sortedIndexReader.getDocIds(dictIds[0]);
                bitmap.add((long)docIdRange.getLeft(), (long)docIdRange.getRight() + 1L);
            } else {
                Pairs.IntPair lastDocIdRange = (Pairs.IntPair)this._sortedIndexReader.getDocIds(dictIds[0]);
                for (int i = 1; i < numDictIds; ++i) {
                    Pairs.IntPair docIdRange = (Pairs.IntPair)this._sortedIndexReader.getDocIds(dictIds[i]);
                    if (docIdRange.getLeft() == lastDocIdRange.getRight() + 1) {
                        lastDocIdRange.setRight(docIdRange.getRight());
                        continue;
                    }
                    bitmap.add((long)lastDocIdRange.getLeft(), (long)lastDocIdRange.getRight() + 1L);
                    lastDocIdRange = docIdRange;
                }
                bitmap.add((long)lastDocIdRange.getLeft(), (long)lastDocIdRange.getRight() + 1L);
            }
        }
        return new BitmapCollection(this._numDocs, exclusive, new ImmutableRoaringBitmap[]{bitmap});
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(indexLookUp:sorted_index");
        stringBuilder.append(",operator:").append(this._predicateEvaluator.getPredicateType());
        stringBuilder.append(",predicate:").append(this._predicateEvaluator.getPredicate().toString());
        return stringBuilder.append(')').toString();
    }

    @Override
    protected String getExplainName() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, EXPLAIN_NAME);
    }

    @Override
    protected void explainAttributes(ExplainAttributeBuilder attributeBuilder) {
        super.explainAttributes(attributeBuilder);
        attributeBuilder.putString("indexLookUp", "sorted_index");
        attributeBuilder.putString("operator", this._predicateEvaluator.getPredicateType().name());
        attributeBuilder.putString("predicate", this._predicateEvaluator.getPredicate().toString());
    }
}

