/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.docidsets.EmptyDocIdSet;
import org.apache.pinot.core.operator.docidsets.MatchAllDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;

public class TestFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_TEST";
    private final int[] _trueDocIds;
    private final int[] _nullDocIds;

    public TestFilterOperator(int[] trueDocIds, int[] nullDocIds, int numDocs) {
        super(numDocs, true);
        this._trueDocIds = trueDocIds;
        this._nullDocIds = nullDocIds;
    }

    public TestFilterOperator(int[] docIds, int numDocs) {
        super(numDocs, false);
        this._trueDocIds = docIds;
        this._nullDocIds = new int[0];
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    protected BlockDocIdSet getTrues() {
        if (this._trueDocIds.length == this._numDocs) {
            return new MatchAllDocIdSet(this._numDocs);
        }
        if (this._trueDocIds.length == 0) {
            return EmptyDocIdSet.getInstance();
        }
        return new TestBlockDocIdSet(this._trueDocIds);
    }

    @Override
    protected BlockDocIdSet getNulls() {
        if (this._nullDocIds.length == 0) {
            return EmptyDocIdSet.getInstance();
        }
        return new TestBlockDocIdSet(this._nullDocIds);
    }

    private static class TestBlockDocIdSet
    implements BlockDocIdSet {
        private final int[] _docIds;

        public TestBlockDocIdSet(int[] docIds) {
            this._docIds = docIds;
        }

        @Override
        public BlockDocIdIterator iterator() {
            return new BlockDocIdIterator(){
                private final int _numDocIds;
                private int _nextIndex;
                {
                    this._numDocIds = _docIds.length;
                    this._nextIndex = 0;
                }

                @Override
                public int next() {
                    if (this._nextIndex < this._numDocIds) {
                        return _docIds[this._nextIndex++];
                    }
                    return Integer.MIN_VALUE;
                }

                @Override
                public int advance(int targetDocId) {
                    while (this._nextIndex < this._numDocIds) {
                        int docId;
                        if ((docId = _docIds[this._nextIndex++]) < targetDocId) continue;
                        return docId;
                    }
                    return Integer.MIN_VALUE;
                }
            };
        }

        @Override
        public long getNumEntriesScannedInFilter() {
            return 0L;
        }
    }
}

