/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import com.google.common.base.CaseFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.predicate.VectorSimilarityPredicate;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.ExplainAttributeBuilder;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapCollection;
import org.apache.pinot.segment.spi.index.reader.VectorIndexReader;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.trace.FilterType;
import org.apache.pinot.spi.trace.InvocationRecording;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class VectorSimilarityFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "VECTOR_SIMILARITY_INDEX";
    private final VectorIndexReader _vectorIndexReader;
    private final VectorSimilarityPredicate _predicate;
    private ImmutableRoaringBitmap _matches;

    public VectorSimilarityFilterOperator(VectorIndexReader vectorIndexReader, VectorSimilarityPredicate predicate, int numDocs) {
        super(numDocs, false);
        this._vectorIndexReader = vectorIndexReader;
        this._predicate = predicate;
        this._matches = null;
    }

    @Override
    protected BlockDocIdSet getTrues() {
        if (this._matches == null) {
            this._matches = this._vectorIndexReader.getDocIds(this._predicate.getValue(), this._predicate.getTopK());
        }
        return new BitmapDocIdSet(this._matches, this._numDocs);
    }

    @Override
    public int getNumMatchingDocs() {
        if (this._matches == null) {
            this._matches = this._vectorIndexReader.getDocIds(this._predicate.getValue(), this._predicate.getTopK());
        }
        return this._matches.getCardinality();
    }

    @Override
    public boolean canProduceBitmaps() {
        return true;
    }

    @Override
    public BitmapCollection getBitmaps() {
        if (this._matches == null) {
            this._matches = this._vectorIndexReader.getDocIds(this._predicate.getValue(), this._predicate.getTopK());
        }
        this.record(this._matches);
        return new BitmapCollection(this._numDocs, false, this._matches);
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        return "VECTOR_SIMILARITY_INDEX(indexLookUp:vector_index, operator:" + this._predicate.getType() + ", vector identifier:" + this._predicate.getLhs().getIdentifier() + ", vector literal:" + Arrays.toString(this._predicate.getValue()) + ", topK to search:" + this._predicate.getTopK() + ")";
    }

    @Override
    protected String getExplainName() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, EXPLAIN_NAME);
    }

    @Override
    protected void explainAttributes(ExplainAttributeBuilder attributeBuilder) {
        super.explainAttributes(attributeBuilder);
        attributeBuilder.putString("indexLookUp", "vector_index");
        attributeBuilder.putString("operator", this._predicate.getType().name());
        attributeBuilder.putString("vectorIdentifier", this._predicate.getLhs().getIdentifier());
        attributeBuilder.putString("vectorLiteral", Arrays.toString(this._predicate.getValue()));
        attributeBuilder.putLongIdempotent("topKtoSearch", this._predicate.getTopK());
    }

    private void record(ImmutableRoaringBitmap matches) {
        InvocationRecording recording = Tracing.activeRecording();
        if (recording.isEnabled()) {
            recording.setNumDocsMatchingAfterFilter(matches.getCardinality());
            recording.setColumnName(this._predicate.getLhs().getIdentifier());
            recording.setFilter(FilterType.INDEX, "VECTOR_SIMILARITY");
            recording.setInputDataType(FieldSpec.DataType.FLOAT, false);
            recording.setNumDocsMatchingAfterFilter(matches.getCardinality());
        }
    }
}

