/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.common.utils.RegexpPatternConverterUtils;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class FSTBasedRegexpPredicateEvaluatorFactory {
    private FSTBasedRegexpPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newFSTBasedEvaluator(RegexpLikePredicate regexpLikePredicate, TextIndexReader fstIndexReader, Dictionary dictionary) {
        return new FSTBasedRegexpPredicateEvaluator(regexpLikePredicate, fstIndexReader, dictionary);
    }

    private static class FSTBasedRegexpPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final ImmutableRoaringBitmap _matchingDictIdBitmap;

        public FSTBasedRegexpPredicateEvaluator(RegexpLikePredicate regexpLikePredicate, TextIndexReader fstIndexReader, Dictionary dictionary) {
            super((Predicate)regexpLikePredicate, dictionary);
            String searchQuery = RegexpPatternConverterUtils.regexpLikeToLuceneRegExp((String)regexpLikePredicate.getValue());
            this._matchingDictIdBitmap = fstIndexReader.getDictIds(searchQuery);
            int numMatchingDictIds = this._matchingDictIdBitmap.getCardinality();
            if (numMatchingDictIds == 0) {
                this._alwaysFalse = true;
            } else if (dictionary.length() == numMatchingDictIds) {
                this._alwaysTrue = true;
            }
        }

        @Override
        protected int[] calculateMatchingDictIds() {
            return this._matchingDictIdBitmap.toArray();
        }

        @Override
        public boolean applySV(int dictId) {
            return this._matchingDictIdBitmap.contains(dictId);
        }

        @Override
        public int applySV(int limit, int[] docIds, int[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                int value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }
}

