/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.pinot.common.request.context.predicate.NotEqPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateUtils;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MultiValueVisitor;
import org.apache.pinot.spi.data.SingleValueVisitor;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.TimestampUtils;

public class NotEqualsPredicateEvaluatorFactory {
    private NotEqualsPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(NotEqPredicate notEqPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
        return new DictionaryBasedNeqPredicateEvaluator(notEqPredicate, dictionary, dataType);
    }

    public static NeqRawPredicateEvaluator newRawValueBasedEvaluator(NotEqPredicate notEqPredicate, FieldSpec.DataType dataType) {
        String value = notEqPredicate.getValue();
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedNeqPredicateEvaluator(notEqPredicate, Integer.parseInt(value));
            }
            case LONG: {
                return new LongRawValueBasedNeqPredicateEvaluator(notEqPredicate, Long.parseLong(value));
            }
            case FLOAT: {
                return new FloatRawValueBasedNeqPredicateEvaluator(notEqPredicate, Float.parseFloat(value));
            }
            case DOUBLE: {
                return new DoubleRawValueBasedNeqPredicateEvaluator(notEqPredicate, Double.parseDouble(value));
            }
            case BIG_DECIMAL: {
                return new BigDecimalRawValueBasedNeqPredicateEvaluator(notEqPredicate, new BigDecimal(value));
            }
            case BOOLEAN: {
                return new IntRawValueBasedNeqPredicateEvaluator(notEqPredicate, BooleanUtils.toInt((String)value));
            }
            case TIMESTAMP: {
                return new LongRawValueBasedNeqPredicateEvaluator(notEqPredicate, TimestampUtils.toMillisSinceEpoch((String)value));
            }
            case STRING: 
            case JSON: {
                return new StringRawValueBasedNeqPredicateEvaluator(notEqPredicate, value);
            }
            case BYTES: {
                return new BytesRawValueBasedNeqPredicateEvaluator(notEqPredicate, BytesUtils.toBytes((String)value));
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType);
    }

    private static final class BytesRawValueBasedNeqPredicateEvaluator
    extends NeqRawPredicateEvaluator {
        final byte[] _nonMatchingValue;

        BytesRawValueBasedNeqPredicateEvaluator(NotEqPredicate notEqPredicate, byte[] nonMatchingValue) {
            super((Predicate)notEqPredicate);
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public int getNumMatchingItems() {
            return -1;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BYTES;
        }

        @Override
        public boolean applySV(byte[] value) {
            return !Arrays.equals(this._nonMatchingValue, value);
        }

        @Override
        public <R> R accept(SingleValueVisitor<R> visitor) {
            return (R)visitor.visitBytes(this._nonMatchingValue);
        }
    }

    private static final class StringRawValueBasedNeqPredicateEvaluator
    extends NeqRawPredicateEvaluator {
        final String _nonMatchingValue;

        StringRawValueBasedNeqPredicateEvaluator(NotEqPredicate notEqPredicate, String nonMatchingValue) {
            super((Predicate)notEqPredicate);
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public int getNumMatchingItems() {
            return -1;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            return !this._nonMatchingValue.equals(value);
        }

        @Override
        public <R> R accept(SingleValueVisitor<R> visitor) {
            return (R)visitor.visitString(this._nonMatchingValue);
        }
    }

    private static final class BigDecimalRawValueBasedNeqPredicateEvaluator
    extends NeqRawPredicateEvaluator {
        final BigDecimal _nonMatchingValue;

        BigDecimalRawValueBasedNeqPredicateEvaluator(NotEqPredicate notEqPredicate, BigDecimal nonMatchingValue) {
            super((Predicate)notEqPredicate);
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public int getNumMatchingItems() {
            return -1;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BIG_DECIMAL;
        }

        @Override
        public boolean applySV(BigDecimal value) {
            return this._nonMatchingValue.compareTo(value) != 0;
        }

        @Override
        public <R> R accept(SingleValueVisitor<R> visitor) {
            return (R)visitor.visitBigDecimal(this._nonMatchingValue);
        }
    }

    private static final class DoubleRawValueBasedNeqPredicateEvaluator
    extends NeqRawPredicateEvaluator {
        final double _nonMatchingValue;

        DoubleRawValueBasedNeqPredicateEvaluator(NotEqPredicate notEqPredicate, double nonMatchingValue) {
            super((Predicate)notEqPredicate);
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public int getNumMatchingItems() {
            return -1;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.DOUBLE;
        }

        @Override
        public boolean applySV(double value) {
            return this._nonMatchingValue != value;
        }

        @Override
        public int applySV(int limit, int[] docIds, double[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                double value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }

        @Override
        public <R> R accept(SingleValueVisitor<R> visitor) {
            return (R)visitor.visitDouble(this._nonMatchingValue);
        }
    }

    private static final class FloatRawValueBasedNeqPredicateEvaluator
    extends NeqRawPredicateEvaluator {
        final float _nonMatchingValue;

        FloatRawValueBasedNeqPredicateEvaluator(NotEqPredicate notEqPredicate, float nonMatchingValue) {
            super((Predicate)notEqPredicate);
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public int getNumMatchingItems() {
            return -1;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.FLOAT;
        }

        @Override
        public boolean applySV(float value) {
            return this._nonMatchingValue != value;
        }

        @Override
        public int applySV(int limit, int[] docIds, float[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                float value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }

        @Override
        public <R> R accept(SingleValueVisitor<R> visitor) {
            return (R)visitor.visitFloat(this._nonMatchingValue);
        }
    }

    private static final class LongRawValueBasedNeqPredicateEvaluator
    extends NeqRawPredicateEvaluator {
        final long _nonMatchingValue;

        LongRawValueBasedNeqPredicateEvaluator(NotEqPredicate notEqPredicate, long nonMatchingValue) {
            super((Predicate)notEqPredicate);
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public int getNumMatchingItems() {
            return -1;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.LONG;
        }

        @Override
        public boolean applySV(long value) {
            return this._nonMatchingValue != value;
        }

        @Override
        public int applySV(int limit, int[] docIds, long[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                long value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }

        @Override
        public <R> R accept(SingleValueVisitor<R> visitor) {
            return (R)visitor.visitLong(this._nonMatchingValue);
        }
    }

    private static final class IntRawValueBasedNeqPredicateEvaluator
    extends NeqRawPredicateEvaluator {
        final int _nonMatchingValue;

        IntRawValueBasedNeqPredicateEvaluator(NotEqPredicate notEqPredicate, int nonMatchingValue) {
            super((Predicate)notEqPredicate);
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public int getNumMatchingItems() {
            return -1;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.INT;
        }

        @Override
        public boolean applySV(int value) {
            return this._nonMatchingValue != value;
        }

        @Override
        public int applySV(int limit, int[] docIds, int[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                int value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }

        @Override
        public <R> R accept(SingleValueVisitor<R> visitor) {
            return (R)visitor.visitInt(this._nonMatchingValue);
        }
    }

    public static abstract class NeqRawPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        public NeqRawPredicateEvaluator(Predicate predicate) {
            super(predicate);
        }

        public abstract <R> R accept(SingleValueVisitor<R> var1);

        public <R> R accept(MultiValueVisitor<R> visitor) {
            return this.accept(visitor.asSingleValueVisitor());
        }
    }

    private static final class DictionaryBasedNeqPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final int _nonMatchingDictId;

        DictionaryBasedNeqPredicateEvaluator(NotEqPredicate notEqPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
            super((Predicate)notEqPredicate, dictionary);
            String predicateValue = PredicateUtils.getStoredValue(notEqPredicate.getValue(), dataType);
            this._nonMatchingDictId = dictionary.indexOf(predicateValue);
            if (this._nonMatchingDictId >= 0) {
                this._nonMatchingDictIds = new int[]{this._nonMatchingDictId};
                if (dictionary.length() == 1) {
                    this._alwaysFalse = true;
                }
            } else {
                this._nonMatchingDictIds = new int[0];
                this._alwaysTrue = true;
            }
        }

        @Override
        protected int[] calculateMatchingDictIds() {
            return PredicateUtils.getDictIds(this._dictionary.length(), this._nonMatchingDictId);
        }

        @Override
        public int getNumMatchingItems() {
            return -1;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._nonMatchingDictId != dictId;
        }

        @Override
        public int applySV(int limit, int[] docIds, int[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                int value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }
}

