/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.math.BigDecimal;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateUtils;
import org.apache.pinot.core.operator.filter.predicate.traits.DoubleRange;
import org.apache.pinot.core.operator.filter.predicate.traits.FloatRange;
import org.apache.pinot.core.operator.filter.predicate.traits.IntRange;
import org.apache.pinot.core.operator.filter.predicate.traits.LongRange;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.TimestampUtils;

public class RangePredicateEvaluatorFactory {
    private RangePredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(RangePredicate rangePredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
        if (dictionary.isSorted()) {
            return new SortedDictionaryBasedRangePredicateEvaluator(rangePredicate, dictionary, dataType);
        }
        return new UnsortedDictionaryBasedRangePredicateEvaluator(rangePredicate, dictionary, dataType);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(RangePredicate rangePredicate, FieldSpec.DataType dataType) {
        String lowerBound = rangePredicate.getLowerBound();
        String upperBound = rangePredicate.getUpperBound();
        boolean lowerUnbounded = lowerBound.equals("*");
        boolean upperUnbounded = upperBound.equals("*");
        boolean lowerInclusive = lowerUnbounded || rangePredicate.isLowerInclusive();
        boolean upperInclusive = upperUnbounded || rangePredicate.isUpperInclusive();
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? Integer.MIN_VALUE : Integer.parseInt(lowerBound), upperUnbounded ? Integer.MAX_VALUE : Integer.parseInt(upperBound), lowerInclusive, upperInclusive);
            }
            case LONG: {
                return new LongRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? Long.MIN_VALUE : Long.parseLong(lowerBound), upperUnbounded ? Long.MAX_VALUE : Long.parseLong(upperBound), lowerInclusive, upperInclusive);
            }
            case FLOAT: {
                return new FloatRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? Float.NEGATIVE_INFINITY : Float.parseFloat(lowerBound), upperUnbounded ? Float.POSITIVE_INFINITY : Float.parseFloat(upperBound), lowerInclusive, upperInclusive);
            }
            case DOUBLE: {
                return new DoubleRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? Double.NEGATIVE_INFINITY : Double.parseDouble(lowerBound), upperUnbounded ? Double.POSITIVE_INFINITY : Double.parseDouble(upperBound), lowerInclusive, upperInclusive);
            }
            case BIG_DECIMAL: {
                return new BigDecimalRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? null : new BigDecimal(lowerBound), upperUnbounded ? null : new BigDecimal(upperBound), lowerInclusive, upperInclusive);
            }
            case BOOLEAN: {
                return new IntRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? Integer.MIN_VALUE : BooleanUtils.toInt((String)lowerBound), upperUnbounded ? Integer.MAX_VALUE : BooleanUtils.toInt((String)upperBound), lowerInclusive, upperInclusive);
            }
            case TIMESTAMP: {
                return new LongRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? Long.MIN_VALUE : TimestampUtils.toMillisSinceEpoch((String)lowerBound), upperUnbounded ? Long.MAX_VALUE : TimestampUtils.toMillisSinceEpoch((String)upperBound), lowerInclusive, upperInclusive);
            }
            case STRING: {
                return new StringRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? null : lowerBound, upperUnbounded ? null : upperBound, lowerInclusive, upperInclusive);
            }
            case BYTES: {
                return new BytesRawValueBasedRangePredicateEvaluator(rangePredicate, lowerUnbounded ? null : BytesUtils.toBytes((String)lowerBound), upperUnbounded ? null : BytesUtils.toBytes((String)upperBound), lowerInclusive, upperInclusive);
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType);
    }

    private static final class BytesRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final byte[] _lowerBound;
        final byte[] _upperBound;
        final int _lowerComparisonValue;
        final int _upperComparisonValue;

        BytesRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, byte[] lowerBound, byte[] upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            this._lowerBound = lowerBound;
            this._upperBound = upperBound;
            this._lowerComparisonValue = lowerInclusive ? 0 : 1;
            this._upperComparisonValue = upperInclusive ? 0 : -1;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BYTES;
        }

        @Override
        public boolean applySV(byte[] value) {
            return !(this._lowerBound != null && ByteArray.compare((byte[])value, (byte[])this._lowerBound) < this._lowerComparisonValue || this._upperBound != null && ByteArray.compare((byte[])value, (byte[])this._upperBound) > this._upperComparisonValue);
        }
    }

    private static final class StringRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final String _lowerBound;
        final String _upperBound;
        final int _lowerComparisonValue;
        final int _upperComparisonValue;

        StringRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, String lowerBound, String upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            this._lowerBound = lowerBound;
            this._upperBound = upperBound;
            this._lowerComparisonValue = lowerInclusive ? 0 : 1;
            this._upperComparisonValue = upperInclusive ? 0 : -1;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            return !(this._lowerBound != null && value.compareTo(this._lowerBound) < this._lowerComparisonValue || this._upperBound != null && value.compareTo(this._upperBound) > this._upperComparisonValue);
        }
    }

    public static final class BigDecimalRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final BigDecimal _lowerBound;
        final BigDecimal _upperBound;
        final int _lowerComparisonValue;
        final int _upperComparisonValue;

        BigDecimalRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, BigDecimal lowerBound, BigDecimal upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            this._lowerBound = lowerBound;
            this._upperBound = upperBound;
            this._lowerComparisonValue = lowerInclusive ? 0 : 1;
            this._upperComparisonValue = upperInclusive ? 0 : -1;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BIG_DECIMAL;
        }

        @Override
        public boolean applySV(BigDecimal value) {
            return !(this._lowerBound != null && value.compareTo(this._lowerBound) < this._lowerComparisonValue || this._upperBound != null && value.compareTo(this._upperBound) > this._upperComparisonValue);
        }
    }

    private static final class DoubleRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator
    implements DoubleRange {
        final double _inclusiveLowerBound;
        final double _inclusiveUpperBound;

        DoubleRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, double lowerBound, double upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            if (lowerInclusive) {
                this._inclusiveLowerBound = lowerBound;
            } else {
                this._inclusiveLowerBound = Math.nextUp(lowerBound);
                Preconditions.checkArgument((this._inclusiveLowerBound > lowerBound ? 1 : 0) != 0, (String)"Invalid range: %s", (Object)rangePredicate);
            }
            if (upperInclusive) {
                this._inclusiveUpperBound = upperBound;
            } else {
                this._inclusiveUpperBound = Math.nextDown(upperBound);
                Preconditions.checkArgument((this._inclusiveUpperBound < upperBound ? 1 : 0) != 0, (String)"Invalid range: %s", (Object)rangePredicate);
            }
        }

        @Override
        public double getInclusiveLowerBound() {
            return this._inclusiveLowerBound;
        }

        @Override
        public double getInclusiveUpperBound() {
            return this._inclusiveUpperBound;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.DOUBLE;
        }

        @Override
        public boolean applySV(double value) {
            return value >= this._inclusiveLowerBound && value <= this._inclusiveUpperBound;
        }

        @Override
        public int applySV(int limit, int[] docIds, double[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                double value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }

    private static final class FloatRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator
    implements FloatRange {
        final float _inclusiveLowerBound;
        final float _inclusiveUpperBound;

        FloatRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, float lowerBound, float upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            if (lowerInclusive) {
                this._inclusiveLowerBound = lowerBound;
            } else {
                this._inclusiveLowerBound = Math.nextUp(lowerBound);
                Preconditions.checkArgument((this._inclusiveLowerBound > lowerBound ? 1 : 0) != 0, (String)"Invalid range: %s", (Object)rangePredicate);
            }
            if (upperInclusive) {
                this._inclusiveUpperBound = upperBound;
            } else {
                this._inclusiveUpperBound = Math.nextDown(upperBound);
                Preconditions.checkArgument((this._inclusiveUpperBound < upperBound ? 1 : 0) != 0, (String)"Invalid range: %s", (Object)rangePredicate);
            }
        }

        @Override
        public float getInclusiveLowerBound() {
            return this._inclusiveLowerBound;
        }

        @Override
        public float getInclusiveUpperBound() {
            return this._inclusiveUpperBound;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.FLOAT;
        }

        @Override
        public boolean applySV(float value) {
            return value >= this._inclusiveLowerBound && value <= this._inclusiveUpperBound;
        }

        @Override
        public int applySV(int limit, int[] docIds, float[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                float value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }

    private static final class LongRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator
    implements LongRange {
        final long _inclusiveLowerBound;
        final long _inclusiveUpperBound;

        LongRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, long lowerBound, long upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            if (lowerInclusive) {
                this._inclusiveLowerBound = lowerBound;
            } else {
                this._inclusiveLowerBound = lowerBound + 1L;
                Preconditions.checkArgument((this._inclusiveLowerBound > lowerBound ? 1 : 0) != 0, (String)"Invalid range: %s", (Object)rangePredicate);
            }
            if (upperInclusive) {
                this._inclusiveUpperBound = upperBound;
            } else {
                this._inclusiveUpperBound = upperBound - 1L;
                Preconditions.checkArgument((this._inclusiveUpperBound < upperBound ? 1 : 0) != 0, (String)"Invalid range: %s", (Object)rangePredicate);
            }
        }

        @Override
        public long getInclusiveLowerBound() {
            return this._inclusiveLowerBound;
        }

        @Override
        public long getInclusiveUpperBound() {
            return this._inclusiveUpperBound;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.LONG;
        }

        @Override
        public boolean applySV(long value) {
            return value >= this._inclusiveLowerBound && value <= this._inclusiveUpperBound;
        }

        @Override
        public int applySV(int limit, int[] docIds, long[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                long value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }

    private static final class IntRawValueBasedRangePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator
    implements IntRange {
        final int _inclusiveLowerBound;
        final int _inclusiveUpperBound;

        IntRawValueBasedRangePredicateEvaluator(RangePredicate rangePredicate, int lowerBound, int upperBound, boolean lowerInclusive, boolean upperInclusive) {
            super((Predicate)rangePredicate);
            if (lowerInclusive) {
                this._inclusiveLowerBound = lowerBound;
            } else {
                this._inclusiveLowerBound = lowerBound + 1;
                Preconditions.checkArgument((this._inclusiveLowerBound > lowerBound ? 1 : 0) != 0, (String)"Invalid range: %s", (Object)rangePredicate);
            }
            if (upperInclusive) {
                this._inclusiveUpperBound = upperBound;
            } else {
                this._inclusiveUpperBound = upperBound - 1;
                Preconditions.checkArgument((this._inclusiveUpperBound < upperBound ? 1 : 0) != 0, (String)"Invalid range: %s", (Object)rangePredicate);
            }
        }

        @Override
        public int getInclusiveLowerBound() {
            return this._inclusiveLowerBound;
        }

        @Override
        public int getInclusiveUpperBound() {
            return this._inclusiveUpperBound;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.INT;
        }

        @Override
        public boolean applySV(int value) {
            return value >= this._inclusiveLowerBound && value <= this._inclusiveUpperBound;
        }

        @Override
        public int applySV(int limit, int[] docIds, int[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                int value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }

    private static final class UnsortedDictionaryBasedRangePredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        private static final int DICT_ID_SET_BASED_CARDINALITY_THRESHOLD = 1000;
        final boolean _dictIdSetBased;
        final IntSet _matchingDictIdSet;
        final BaseRawValueBasedPredicateEvaluator _rawValueBasedEvaluator;

        UnsortedDictionaryBasedRangePredicateEvaluator(RangePredicate rangePredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
            super((Predicate)rangePredicate, dictionary);
            int cardinality = dictionary.length();
            if (cardinality < 1000) {
                String upperBound;
                this._dictIdSetBased = true;
                this._rawValueBasedEvaluator = null;
                String lowerBound = rangePredicate.getLowerBound();
                if (!lowerBound.equals("*")) {
                    lowerBound = PredicateUtils.getStoredValue(lowerBound, dataType);
                }
                if (!(upperBound = rangePredicate.getUpperBound()).equals("*")) {
                    upperBound = PredicateUtils.getStoredValue(upperBound, dataType);
                }
                this._matchingDictIdSet = dictionary.getDictIdsInRange(lowerBound, upperBound, rangePredicate.isLowerInclusive(), rangePredicate.isUpperInclusive());
                int numMatchingDictIds = this._matchingDictIdSet.size();
                if (numMatchingDictIds == 0) {
                    this._alwaysFalse = true;
                } else if (numMatchingDictIds == cardinality) {
                    this._alwaysTrue = true;
                }
            } else {
                this._dictIdSetBased = false;
                this._matchingDictIdSet = null;
                this._rawValueBasedEvaluator = RangePredicateEvaluatorFactory.newRawValueBasedEvaluator(rangePredicate, dataType);
            }
        }

        @Override
        public int[] getMatchingDictIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getNumMatchingItems() {
            return this._matchingDictIdSet != null ? this._matchingDictIdSet.size() : Integer.MIN_VALUE;
        }

        @Override
        public boolean applySV(int dictId) {
            if (this._dictIdSetBased) {
                return this._matchingDictIdSet.contains(dictId);
            }
            switch (this._dictionary.getValueType()) {
                case INT: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getIntValue(dictId));
                }
                case LONG: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getLongValue(dictId));
                }
                case FLOAT: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getFloatValue(dictId));
                }
                case DOUBLE: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getDoubleValue(dictId));
                }
                case BIG_DECIMAL: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getBigDecimalValue(dictId));
                }
                case STRING: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getStringValue(dictId));
                }
                case BYTES: {
                    return this._rawValueBasedEvaluator.applySV(this._dictionary.getBytesValue(dictId));
                }
            }
            throw new IllegalStateException("Unsupported value type: " + this._dictionary.getValueType());
        }
    }

    public static final class SortedDictionaryBasedRangePredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator
    implements IntRange {
        final int _startDictId;
        final int _endDictId;
        final int _numMatchingDictIds;

        SortedDictionaryBasedRangePredicateEvaluator(RangePredicate rangePredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
            super((Predicate)rangePredicate, dictionary);
            int insertionIndex;
            String lowerBound = rangePredicate.getLowerBound();
            String upperBound = rangePredicate.getUpperBound();
            boolean lowerInclusive = rangePredicate.isLowerInclusive();
            boolean upperInclusive = rangePredicate.isUpperInclusive();
            this._startDictId = lowerBound.equals("*") ? 0 : ((insertionIndex = dictionary.insertionIndexOf(PredicateUtils.getStoredValue(lowerBound, dataType))) < 0 ? -(insertionIndex + 1) : (lowerInclusive ? insertionIndex : insertionIndex + 1));
            this._endDictId = upperBound.equals("*") ? dictionary.length() : ((insertionIndex = dictionary.insertionIndexOf(PredicateUtils.getStoredValue(upperBound, dataType))) < 0 ? -(insertionIndex + 1) : (upperInclusive ? insertionIndex + 1 : insertionIndex));
            this._numMatchingDictIds = Integer.max(this._endDictId - this._startDictId, 0);
            if (this._numMatchingDictIds == 0) {
                this._alwaysFalse = true;
            } else if (dictionary.length() == this._numMatchingDictIds) {
                this._alwaysTrue = true;
            }
        }

        public int getStartDictId() {
            return this._startDictId;
        }

        public int getEndDictId() {
            return this._endDictId;
        }

        @Override
        protected int[] calculateMatchingDictIds() {
            if (this._numMatchingDictIds == 0) {
                return new int[0];
            }
            int[] matchingDictIds = new int[this._numMatchingDictIds];
            for (int i = 0; i < this._numMatchingDictIds; ++i) {
                matchingDictIds[i] = this._startDictId + i;
            }
            return matchingDictIds;
        }

        @Override
        protected int[] calculateNonMatchingDictIds() {
            int dictionarySize = this._dictionary.length();
            if (this._numMatchingDictIds == 0) {
                int[] nonMatchingDictIds = new int[dictionarySize];
                for (int i = 0; i < dictionarySize; ++i) {
                    nonMatchingDictIds[i] = i;
                }
                return nonMatchingDictIds;
            }
            int[] nonMatchingDictIds = new int[dictionarySize - this._numMatchingDictIds];
            int index = 0;
            int i = 0;
            while (i < this._startDictId) {
                nonMatchingDictIds[index++] = i++;
            }
            i = this._endDictId;
            while (i < dictionarySize) {
                nonMatchingDictIds[index++] = i++;
            }
            return nonMatchingDictIds;
        }

        @Override
        public int getNumMatchingItems() {
            return this._numMatchingDictIds;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._startDictId <= dictId && this._endDictId > dictId;
        }

        @Override
        public int applySV(int limit, int[] docIds, int[] dictIds) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                int dictId = dictIds[i];
                if (!this.applySV(dictId)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }

        @Override
        public int getInclusiveLowerBound() {
            return this.getStartDictId();
        }

        @Override
        public int getInclusiveUpperBound() {
            return this.getEndDictId() - 1;
        }
    }
}

