/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import com.google.common.base.Preconditions;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.common.utils.regex.Matcher;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class RegexpLikePredicateEvaluatorFactory {
    private RegexpLikePredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(RegexpLikePredicate regexpLikePredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
        boolean condition = dataType == FieldSpec.DataType.STRING || dataType == FieldSpec.DataType.JSON;
        Preconditions.checkArgument((boolean)condition, (Object)("Unsupported data type: " + dataType));
        return new DictionaryBasedRegexpLikePredicateEvaluator(regexpLikePredicate, dictionary);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(RegexpLikePredicate regexpLikePredicate, FieldSpec.DataType dataType) {
        Preconditions.checkArgument((dataType == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)("Unsupported data type: " + dataType));
        return new RawValueBasedRegexpLikePredicateEvaluator(regexpLikePredicate);
    }

    private static final class RawValueBasedRegexpLikePredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final Matcher _matcher;

        public RawValueBasedRegexpLikePredicateEvaluator(RegexpLikePredicate regexpLikePredicate) {
            super((Predicate)regexpLikePredicate);
            this._matcher = regexpLikePredicate.getPattern().matcher((CharSequence)"");
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            return this._matcher.reset((CharSequence)value).find();
        }
    }

    private static final class DictionaryBasedRegexpLikePredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final Matcher _matcher;

        public DictionaryBasedRegexpLikePredicateEvaluator(RegexpLikePredicate regexpLikePredicate, Dictionary dictionary) {
            super((Predicate)regexpLikePredicate, dictionary);
            this._matcher = regexpLikePredicate.getPattern().matcher((CharSequence)"");
        }

        @Override
        public boolean applySV(int dictId) {
            return this._matcher.reset((CharSequence)this._dictionary.getStringValue(dictId)).find();
        }

        @Override
        public int applySV(int limit, int[] docIds, int[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                int value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }
}

