/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import com.google.common.base.CaseFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.ExplainAttributeBuilder;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.blocks.results.AggregationResultsBlock;
import org.apache.pinot.core.query.aggregation.DefaultAggregationExecutor;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.executor.StarTreeAggregationExecutor;

public class AggregationOperator
extends BaseOperator<AggregationResultsBlock> {
    private static final String EXPLAIN_NAME = "AGGREGATE";
    private final QueryContext _queryContext;
    private final AggregationFunction[] _aggregationFunctions;
    private final BaseProjectOperator<?> _projectOperator;
    private final boolean _useStarTree;
    private final long _numTotalDocs;
    private int _numDocsScanned = 0;

    public AggregationOperator(QueryContext queryContext, AggregationFunctionUtils.AggregationInfo aggregationInfo, long numTotalDocs) {
        this._queryContext = queryContext;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        this._projectOperator = aggregationInfo.getProjectOperator();
        this._useStarTree = aggregationInfo.isUseStarTree();
        this._numTotalDocs = numTotalDocs;
    }

    @Override
    protected AggregationResultsBlock getNextBlock() {
        ValueBlock valueBlock;
        DefaultAggregationExecutor aggregationExecutor = this._useStarTree ? new StarTreeAggregationExecutor(this._aggregationFunctions) : new DefaultAggregationExecutor(this._aggregationFunctions);
        while ((valueBlock = (ValueBlock)this._projectOperator.nextBlock()) != null) {
            this._numDocsScanned += valueBlock.getNumDocs();
            aggregationExecutor.aggregate(valueBlock);
        }
        return new AggregationResultsBlock(this._aggregationFunctions, aggregationExecutor.getResult(), this._queryContext);
    }

    @Override
    public List<BaseProjectOperator<?>> getChildOperators() {
        return Collections.singletonList(this._projectOperator);
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._projectOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._projectOperator.getNumColumnsProjected();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, this._numTotalDocs);
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(aggregations:");
        if (this._aggregationFunctions.length > 0) {
            stringBuilder.append(this._aggregationFunctions[0].toExplainString());
            for (int i = 1; i < this._aggregationFunctions.length; ++i) {
                stringBuilder.append(", ").append(this._aggregationFunctions[i].toExplainString());
            }
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    protected String getExplainName() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, EXPLAIN_NAME);
    }

    @Override
    protected void explainAttributes(ExplainAttributeBuilder attributeBuilder) {
        super.explainAttributes(attributeBuilder);
        if (this._aggregationFunctions.length == 0) {
            return;
        }
        List<String> aggregations = Arrays.stream(this._aggregationFunctions).map(AggregationFunction::toExplainString).collect(Collectors.toList());
        attributeBuilder.putStringList("aggregations", aggregations);
    }
}

