/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import com.google.common.base.CaseFormat;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.ExplainAttributeBuilder;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.blocks.results.DistinctResultsBlock;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.DistinctExecutorFactory;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;

public class DistinctOperator
extends BaseOperator<DistinctResultsBlock> {
    private static final String EXPLAIN_NAME = "DISTINCT";
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;
    private final BaseProjectOperator<?> _projectOperator;
    private int _numDocsScanned = 0;

    public DistinctOperator(IndexSegment indexSegment, QueryContext queryContext, BaseProjectOperator<?> projectOperator) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
        this._projectOperator = projectOperator;
    }

    @Override
    protected DistinctResultsBlock getNextBlock() {
        ValueBlock valueBlock;
        DistinctExecutor executor = DistinctExecutorFactory.getDistinctExecutor(this._projectOperator, this._queryContext);
        while ((valueBlock = (ValueBlock)this._projectOperator.nextBlock()) != null) {
            this._numDocsScanned += valueBlock.getNumDocs();
            if (!executor.process(valueBlock)) continue;
        }
        return new DistinctResultsBlock(executor.getResult(), this._queryContext);
    }

    @Override
    public List<BaseProjectOperator<?>> getChildOperators() {
        return Collections.singletonList(this._projectOperator);
    }

    @Override
    public IndexSegment getIndexSegment() {
        return this._indexSegment;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._projectOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._projectOperator.getNumColumnsProjected();
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, numTotalDocs);
    }

    @Override
    public String toExplainString() {
        List<ExpressionContext> expressions = this._queryContext.getSelectExpressions();
        int numExpressions = expressions.size();
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(keyColumns:");
        stringBuilder.append(expressions.get(0).toString());
        for (int i = 1; i < numExpressions; ++i) {
            stringBuilder.append(", ").append(expressions.get(i).toString());
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    protected String getExplainName() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, EXPLAIN_NAME);
    }

    @Override
    protected void explainAttributes(ExplainAttributeBuilder attributeBuilder) {
        super.explainAttributes(attributeBuilder);
        List<ExpressionContext> selectExpressions = this._queryContext.getSelectExpressions();
        if (selectExpressions.isEmpty()) {
            return;
        }
        List<String> expressions = selectExpressions.stream().map(ExpressionContext::toString).collect(Collectors.toList());
        attributeBuilder.putStringList("keyColumns", expressions);
    }
}

