/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.ExplainAttributeBuilder;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.blocks.results.AggregationResultsBlock;
import org.apache.pinot.core.query.aggregation.DefaultAggregationExecutor;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.executor.StarTreeAggregationExecutor;

public class FilteredAggregationOperator
extends BaseOperator<AggregationResultsBlock> {
    private static final String EXPLAIN_NAME = "AGGREGATE_FILTERED";
    private final QueryContext _queryContext;
    private final AggregationFunction[] _aggregationFunctions;
    private final List<AggregationFunctionUtils.AggregationInfo> _aggregationInfos;
    private final long _numTotalDocs;
    private long _numDocsScanned;
    private long _numEntriesScannedInFilter;
    private long _numEntriesScannedPostFilter;

    public FilteredAggregationOperator(QueryContext queryContext, List<AggregationFunctionUtils.AggregationInfo> aggregationInfos, long numTotalDocs) {
        this._queryContext = queryContext;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        this._aggregationInfos = aggregationInfos;
        this._numTotalDocs = numTotalDocs;
    }

    @Override
    protected AggregationResultsBlock getNextBlock() {
        int numAggregations = this._aggregationFunctions.length;
        Object[] result = new Object[numAggregations];
        IdentityHashMap<AggregationFunction, Integer> resultIndexMap = new IdentityHashMap<AggregationFunction, Integer>(numAggregations);
        for (int i = 0; i < numAggregations; ++i) {
            resultIndexMap.put(this._aggregationFunctions[i], i);
        }
        for (AggregationFunctionUtils.AggregationInfo aggregationInfo : this._aggregationInfos) {
            ValueBlock valueBlock;
            AggregationFunction[] aggregationFunctions = aggregationInfo.getFunctions();
            BaseProjectOperator<?> projectOperator = aggregationInfo.getProjectOperator();
            DefaultAggregationExecutor aggregationExecutor = aggregationInfo.isUseStarTree() ? new StarTreeAggregationExecutor(aggregationFunctions) : new DefaultAggregationExecutor(aggregationFunctions);
            int numDocsScanned = 0;
            while ((valueBlock = (ValueBlock)projectOperator.nextBlock()) != null) {
                aggregationExecutor.aggregate(valueBlock);
                numDocsScanned += valueBlock.getNumDocs();
            }
            List<Object> filteredResult = aggregationExecutor.getResult();
            for (int i = 0; i < aggregationFunctions.length; ++i) {
                result[((Integer)resultIndexMap.get((Object)aggregationFunctions[i])).intValue()] = filteredResult.get(i);
            }
            this._numDocsScanned += (long)numDocsScanned;
            this._numEntriesScannedInFilter += projectOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
            this._numEntriesScannedPostFilter += (long)numDocsScanned * (long)projectOperator.getNumColumnsProjected();
        }
        return new AggregationResultsBlock(this._aggregationFunctions, Arrays.asList(result), this._queryContext);
    }

    @Override
    public List<Operator> getChildOperators() {
        return this._aggregationInfos.stream().map(AggregationFunctionUtils.AggregationInfo::getProjectOperator).collect(Collectors.toList());
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return new ExecutionStatistics(this._numDocsScanned, this._numEntriesScannedInFilter, this._numEntriesScannedPostFilter, this._numTotalDocs);
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    protected void explainAttributes(ExplainAttributeBuilder attributeBuilder) {
        super.explainAttributes(attributeBuilder);
        if (this._aggregationFunctions.length > 0) {
            List<String> aggregations = Arrays.stream(this._aggregationFunctions).map(AggregationFunction::toExplainString).collect(Collectors.toList());
            attributeBuilder.putStringList("aggregations", aggregations);
        }
    }
}

