/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.ExplainAttributeBuilder;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.utils.OrderByComparatorFactory;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public abstract class LinearSelectionOrderByOperator
extends BaseOperator<SelectionResultsBlock> {
    protected final IndexSegment _indexSegment;
    protected final QueryContext _queryContext;
    protected final boolean _nullHandlingEnabled;
    protected final List<ExpressionContext> _expressions;
    protected final List<ExpressionContext> _alreadySorted;
    protected final List<ExpressionContext> _toSort;
    protected final BaseProjectOperator<?> _projectOperator;
    protected final List<OrderByExpressionContext> _orderByExpressions;
    protected final ColumnContext[] _columnContexts;
    protected final int _numRowsToKeep;
    protected final Comparator<Object[]> _comparator;
    protected final Supplier<ListBuilder> _listBuilderSupplier;

    public LinearSelectionOrderByOperator(IndexSegment indexSegment, QueryContext queryContext, List<ExpressionContext> expressions, BaseProjectOperator<?> projectOperator, int numSortedExpressions) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
        this._nullHandlingEnabled = queryContext.isNullHandlingEnabled();
        this._expressions = expressions;
        this._projectOperator = projectOperator;
        this._orderByExpressions = queryContext.getOrderByExpressions();
        assert (this._orderByExpressions != null);
        int numOrderByExpressions = this._orderByExpressions.size();
        this._alreadySorted = expressions.subList(0, numSortedExpressions);
        this._toSort = expressions.subList(numSortedExpressions, numOrderByExpressions);
        this._columnContexts = new ColumnContext[this._expressions.size()];
        for (int i = 0; i < this._columnContexts.length; ++i) {
            ExpressionContext expression = this._expressions.get(i);
            this._columnContexts[i] = this._projectOperator.getResultColumnContext(expression);
        }
        this._numRowsToKeep = queryContext.getOffset() + queryContext.getLimit();
        this._comparator = OrderByComparatorFactory.getComparator(this._orderByExpressions, this._columnContexts, this._nullHandlingEnabled);
        if (this._toSort.isEmpty()) {
            this._listBuilderSupplier = () -> new TotallySortedListBuilder(this._numRowsToKeep);
        } else {
            Comparator<Object[]> sortedComparator = OrderByComparatorFactory.getComparator(this._orderByExpressions, this._columnContexts, this._nullHandlingEnabled, 0, numSortedExpressions);
            Comparator<Object[]> unsortedComparator = OrderByComparatorFactory.getComparator(this._orderByExpressions, this._columnContexts, this._nullHandlingEnabled, numSortedExpressions, numOrderByExpressions);
            this._listBuilderSupplier = () -> new PartiallySortedListBuilder(this._numRowsToKeep, sortedComparator, unsortedComparator);
        }
    }

    @Override
    public IndexSegment getIndexSegment() {
        return this._indexSegment;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._projectOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        int numDocsScanned = this.getNumDocsScanned();
        long numEntriesScannedPostFilter = (long)numDocsScanned * (long)this._projectOperator.getNumColumnsProjected();
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        return new ExecutionStatistics(numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, numTotalDocs);
    }

    protected IntFunction<Object[]> fetchBlock(ValueBlock valueBlock, BlockValSet[] blockValSets) {
        int numExpressions = this._expressions.size();
        for (int i = 0; i < numExpressions; ++i) {
            ExpressionContext expression = this._expressions.get(i);
            blockValSets[i] = valueBlock.getBlockValueSet(expression);
        }
        RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
        if (!this._nullHandlingEnabled) {
            return blockValueFetcher::getRow;
        }
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            nullBitmaps[i] = blockValSets[i].getNullBitmap();
        }
        return docId -> {
            Object[] row = blockValueFetcher.getRow(docId);
            for (int colId = 0; colId < nullBitmaps.length; ++colId) {
                if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(docId)) continue;
                row[colId] = null;
            }
            return row;
        };
    }

    protected abstract int getNumDocsScanned();

    protected abstract List<Object[]> fetch(Supplier<ListBuilder> var1);

    @Override
    public List<BaseProjectOperator<?>> getChildOperators() {
        return Collections.singletonList(this._projectOperator);
    }

    protected abstract String getUpperCaseExplainName();

    @Override
    protected String getExplainName() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.getUpperCaseExplainName());
    }

    @Override
    public String toExplainString() {
        StringBuilder sb = new StringBuilder(this.getUpperCaseExplainName());
        sb.append("(sortedList: ");
        this.concatList(sb, this._alreadySorted);
        sb.append(", unsortedList: ");
        this.concatList(sb, this._toSort);
        sb.append(", rest: ");
        this.concatList(sb, this._expressions.subList(this._alreadySorted.size() + this._toSort.size(), this._expressions.size()));
        sb.append(')');
        return sb.toString();
    }

    @Override
    protected void explainAttributes(ExplainAttributeBuilder attributeBuilder) {
        super.explainAttributes(attributeBuilder);
        List<ExpressionContext> rest = this._expressions.subList(this._alreadySorted.size() + this._toSort.size(), this._expressions.size());
        List<String> sortedList = this._alreadySorted.stream().map(ExpressionContext::toString).collect(Collectors.toList());
        List<String> toSort = this._toSort.stream().map(ExpressionContext::toString).collect(Collectors.toList());
        List<String> restStr = rest.stream().map(ExpressionContext::toString).collect(Collectors.toList());
        attributeBuilder.putStringList("sortedList", sortedList).putStringList("unsortedList", toSort).putStringList("rest", restStr);
    }

    private void concatList(StringBuilder sb, List<?> list) {
        sb.append('(');
        Iterator<?> it = list.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(", ").append(it.next());
            }
        }
        sb.append(')');
    }

    @Override
    protected SelectionResultsBlock getNextBlock() {
        return new SelectionResultsBlock(this.createDataSchema(), this.fetch(this._listBuilderSupplier), this._comparator, this._queryContext);
    }

    protected DataSchema createDataSchema() {
        int i;
        int numExpressions = this._expressions.size();
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (i = 0; i < columnNames.length; ++i) {
            columnNames[i] = this._expressions.get(i).toString();
        }
        for (i = 0; i < numExpressions; ++i) {
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)this._columnContexts[i].getDataType(), (boolean)this._columnContexts[i].isSingleValue());
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    @VisibleForTesting
    static class PartiallySortedListBuilder
    implements ListBuilder {
        private final int _maxNumRows;
        private final Comparator<Object[]> _partitionComparator;
        private final Comparator<Object[]> _unsortedComparator;
        private final ArrayList<Object[]> _rows;
        private PriorityQueue<Object[]> _lastPartitionQueue;
        private Object[] _lastPartitionRow;
        private int _numSortedRows;

        public PartiallySortedListBuilder(int maxNumRows, Comparator<Object[]> partitionComparator, Comparator<Object[]> unsortedComparator) {
            this._maxNumRows = maxNumRows;
            this._partitionComparator = partitionComparator;
            this._unsortedComparator = unsortedComparator;
            this._rows = new ArrayList(Integer.min(maxNumRows, 10000));
        }

        @Override
        public boolean add(Object[] row) {
            if (this._lastPartitionRow == null) {
                this._lastPartitionRow = row;
                this._rows.add(row);
                return false;
            }
            int compareResult = this._partitionComparator.compare(row, this._lastPartitionRow);
            Preconditions.checkState((compareResult >= 0 ? 1 : 0) != 0, (Object)"Rows are not sorted");
            boolean newPartition = compareResult > 0;
            int numRows = this._rows.size();
            if (numRows < this._maxNumRows) {
                if (newPartition) {
                    this._lastPartitionRow = row;
                    if (numRows - this._numSortedRows > 1) {
                        this._rows.subList(this._numSortedRows, numRows).sort(this._unsortedComparator);
                    }
                    this._numSortedRows = numRows;
                }
                this._rows.add(row);
                return false;
            }
            assert (numRows == this._maxNumRows);
            if (newPartition) {
                return true;
            }
            if (this._lastPartitionQueue == null) {
                int numRowsInPriorityQueue = numRows - this._numSortedRows;
                this._lastPartitionQueue = new PriorityQueue<Object[]>(numRowsInPriorityQueue, this._unsortedComparator.reversed());
                this._lastPartitionQueue.addAll(this._rows.subList(this._numSortedRows, numRows));
            }
            if (this._unsortedComparator.compare(row, this._lastPartitionQueue.peek()) < 0) {
                this._lastPartitionQueue.poll();
                this._lastPartitionQueue.offer(row);
            }
            return false;
        }

        @Override
        public List<Object[]> build() {
            int numRows = this._rows.size();
            if (this._lastPartitionQueue == null) {
                if (numRows - this._numSortedRows > 1) {
                    this._rows.subList(this._numSortedRows, numRows).sort(this._unsortedComparator);
                }
            } else {
                assert (numRows == this._maxNumRows && this._lastPartitionQueue.size() == numRows - this._numSortedRows);
                for (int i = numRows - 1; i >= this._numSortedRows; --i) {
                    this._rows.set(i, this._lastPartitionQueue.poll());
                }
            }
            return this._rows;
        }
    }

    @VisibleForTesting
    static class TotallySortedListBuilder
    implements ListBuilder {
        private final ArrayList<Object[]> _list;
        private final int _maxNumRows;

        public TotallySortedListBuilder(int maxNumRows) {
            this._maxNumRows = maxNumRows;
            this._list = new ArrayList(Integer.min(maxNumRows, 10000));
        }

        @Override
        public boolean add(Object[] row) {
            this._list.add(row);
            return this._list.size() == this._maxNumRows;
        }

        @Override
        public List<Object[]> build() {
            return this._list;
        }
    }

    protected static interface ListBuilder {
        public boolean add(Object[] var1);

        public List<Object[]> build();
    }
}

