/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.streaming;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.proto.Plan;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.ExplainAttributeBuilder;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class StreamingSelectionOnlyOperator
extends BaseOperator<SelectionResultsBlock> {
    private static final String EXPLAIN_NAME = "SELECT_STREAMING";
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;
    private final List<ExpressionContext> _expressions;
    private final BaseProjectOperator<?> _projectOperator;
    private final BlockValSet[] _blockValSets;
    private final DataSchema _dataSchema;
    private final int _limit;
    private final boolean _nullHandlingEnabled;
    private final RoaringBitmap[] _nullBitmaps;
    private int _numDocsScanned = 0;

    public StreamingSelectionOnlyOperator(IndexSegment indexSegment, QueryContext queryContext, List<ExpressionContext> expressions, BaseProjectOperator<?> projectOperator) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
        this._expressions = expressions;
        this._projectOperator = projectOperator;
        this._nullHandlingEnabled = queryContext.isNullHandlingEnabled();
        int numExpressions = expressions.size();
        this._blockValSets = new BlockValSet[numExpressions];
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            ExpressionContext expression = expressions.get(i);
            columnNames[i] = expression.toString();
            ColumnContext columnContext = projectOperator.getResultColumnContext(expression);
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)columnContext.getDataType(), (boolean)columnContext.isSingleValue());
        }
        this._dataSchema = new DataSchema(columnNames, columnDataTypes);
        this._nullBitmaps = this._nullHandlingEnabled ? new RoaringBitmap[numExpressions] : null;
        this._limit = queryContext.getLimit();
    }

    @Override
    @Nullable
    protected SelectionResultsBlock getNextBlock() {
        if (this._numDocsScanned >= this._limit) {
            return null;
        }
        ValueBlock valueBlock = (ValueBlock)this._projectOperator.nextBlock();
        if (valueBlock == null) {
            return null;
        }
        int numExpressions = this._expressions.size();
        for (int i = 0; i < numExpressions; ++i) {
            this._blockValSets[i] = valueBlock.getBlockValueSet(this._expressions.get(i));
        }
        RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(this._blockValSets);
        int numDocs = valueBlock.getNumDocs();
        int numDocsToReturn = Math.min(this._limit - this._numDocsScanned, numDocs);
        ArrayList<Object[]> rows = new ArrayList<Object[]>(numDocsToReturn);
        if (this._nullHandlingEnabled) {
            for (int i = 0; i < numExpressions; ++i) {
                this._nullBitmaps[i] = this._blockValSets[i].getNullBitmap();
            }
            for (int docId = 0; docId < numDocsToReturn; ++docId) {
                Object[] values = blockValueFetcher.getRow(docId);
                for (int colId = 0; colId < numExpressions; ++colId) {
                    if (this._nullBitmaps[colId] == null || !this._nullBitmaps[colId].contains(docId)) continue;
                    values[colId] = null;
                }
                rows.add(values);
            }
        } else {
            for (int i = 0; i < numDocsToReturn; ++i) {
                rows.add(blockValueFetcher.getRow(i));
            }
        }
        this._numDocsScanned += numDocs;
        return new SelectionResultsBlock(this._dataSchema, rows, this._queryContext);
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    protected void explainAttributes(ExplainAttributeBuilder attributeBuilder) {
        super.explainAttributes(attributeBuilder);
        String segmentName = this._indexSegment.getSegmentName();
        String tableName = this._indexSegment.getSegmentMetadata().getTableName();
        if (tableName == null && segmentName.indexOf(95) > 0) {
            tableName = segmentName.substring(0, segmentName.indexOf(95));
        }
        attributeBuilder.putString("table", tableName);
        Plan.ExplainNode.AttributeValue segment = Plan.ExplainNode.AttributeValue.newBuilder().setString(segmentName).setMergeType(Plan.ExplainNode.AttributeValue.MergeType.IGNORABLE).build();
        attributeBuilder.putAttribute("segment", segment);
        attributeBuilder.putLong("totalDocs", this._indexSegment.getSegmentMetadata().getTotalDocs());
    }

    @Override
    public List<BaseProjectOperator<?>> getChildOperators() {
        return Collections.singletonList(this._projectOperator);
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._projectOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._projectOperator.getNumColumnsProjected();
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, numTotalDocs);
    }
}

