/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.timeseries;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.TimeSeriesBuilderBlock;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.blocks.results.TimeSeriesResultsBlock;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.tsdb.spi.AggInfo;
import org.apache.pinot.tsdb.spi.TimeBuckets;
import org.apache.pinot.tsdb.spi.series.BaseTimeSeriesBuilder;
import org.apache.pinot.tsdb.spi.series.TimeSeries;
import org.apache.pinot.tsdb.spi.series.TimeSeriesBuilderFactory;

public class TimeSeriesAggregationOperator
extends BaseOperator<TimeSeriesResultsBlock> {
    private static final String EXPLAIN_NAME = "TIME_SERIES_AGGREGATION";
    private final String _timeColumn;
    private final TimeUnit _storedTimeUnit;
    private final long _timeOffset;
    private final AggInfo _aggInfo;
    private final ExpressionContext _valueExpression;
    private final List<String> _groupByExpressions;
    private final BaseProjectOperator<? extends ValueBlock> _projectOperator;
    private final TimeBuckets _timeBuckets;
    private final TimeSeriesBuilderFactory _seriesBuilderFactory;
    private final int _maxSeriesLimit;
    private final long _maxDataPointsLimit;
    private final long _numTotalDocs;
    private long _numDocsScanned = 0L;

    public TimeSeriesAggregationOperator(String timeColumn, TimeUnit timeUnit, @Nullable Long timeOffsetSeconds, AggInfo aggInfo, ExpressionContext valueExpression, List<String> groupByExpressions, TimeBuckets timeBuckets, BaseProjectOperator<? extends ValueBlock> projectOperator, TimeSeriesBuilderFactory seriesBuilderFactory, SegmentMetadata segmentMetadata) {
        this._timeColumn = timeColumn;
        this._storedTimeUnit = timeUnit;
        this._timeOffset = timeOffsetSeconds == null ? 0L : timeUnit.convert(Duration.ofSeconds(timeOffsetSeconds));
        this._aggInfo = aggInfo;
        this._valueExpression = valueExpression;
        this._groupByExpressions = groupByExpressions;
        this._projectOperator = projectOperator;
        this._timeBuckets = timeBuckets;
        this._seriesBuilderFactory = seriesBuilderFactory;
        this._maxSeriesLimit = this._seriesBuilderFactory.getMaxUniqueSeriesPerServerLimit();
        this._maxDataPointsLimit = this._seriesBuilderFactory.getMaxDataPointsPerServerLimit();
        this._numTotalDocs = segmentMetadata.getTotalDocs();
    }

    @Override
    protected TimeSeriesResultsBlock getNextBlock() {
        ValueBlock valueBlock;
        HashMap<Long, BaseTimeSeriesBuilder> seriesBuilderMap = new HashMap<Long, BaseTimeSeriesBuilder>(1024);
        while ((valueBlock = (ValueBlock)this._projectOperator.nextBlock()) != null) {
            int numDocs = valueBlock.getNumDocs();
            this._numDocsScanned += (long)numDocs;
            BlockValSet blockValSet = valueBlock.getBlockValueSet(this._timeColumn);
            long[] timeValues = blockValSet.getLongValuesSV();
            this.applyTimeOffset(timeValues, numDocs);
            int[] timeValueIndexes = this.getTimeValueIndex(timeValues, numDocs);
            Object[][] tagValues = new Object[this._groupByExpressions.size()][];
            block12: for (int i = 0; i < this._groupByExpressions.size(); ++i) {
                blockValSet = valueBlock.getBlockValueSet(this._groupByExpressions.get(i));
                switch (blockValSet.getValueType()) {
                    case JSON: 
                    case STRING: {
                        tagValues[i] = blockValSet.getStringValuesSV();
                        continue block12;
                    }
                    case LONG: {
                        tagValues[i] = ArrayUtils.toObject((long[])blockValSet.getLongValuesSV());
                        continue block12;
                    }
                    case INT: {
                        tagValues[i] = ArrayUtils.toObject((int[])blockValSet.getIntValuesSV());
                        continue block12;
                    }
                    default: {
                        throw new NotImplementedException("Can't handle types other than string and long");
                    }
                }
            }
            BlockValSet valueExpressionBlockValSet = valueBlock.getBlockValueSet(this._valueExpression);
            switch (valueExpressionBlockValSet.getValueType()) {
                case LONG: {
                    this.processLongExpression(valueExpressionBlockValSet, seriesBuilderMap, timeValueIndexes, tagValues, numDocs);
                    break;
                }
                case INT: {
                    this.processIntExpression(valueExpressionBlockValSet, seriesBuilderMap, timeValueIndexes, tagValues, numDocs);
                    break;
                }
                case DOUBLE: {
                    this.processDoubleExpression(valueExpressionBlockValSet, seriesBuilderMap, timeValueIndexes, tagValues, numDocs);
                    break;
                }
                case STRING: {
                    this.processStringExpression(valueExpressionBlockValSet, seriesBuilderMap, timeValueIndexes, tagValues, numDocs);
                    break;
                }
                default: {
                    throw new IllegalStateException("Don't yet support value expression of type: " + valueExpressionBlockValSet.getValueType());
                }
            }
            Preconditions.checkState(((long)seriesBuilderMap.size() * (long)this._timeBuckets.getNumBuckets() <= this._maxDataPointsLimit ? 1 : 0) != 0, (String)"Exceeded max data point limit per server. Limit: %s. Data points in current segment so far: %s", (long)this._maxDataPointsLimit, (int)(seriesBuilderMap.size() * this._timeBuckets.getNumBuckets()));
            Preconditions.checkState((seriesBuilderMap.size() <= this._maxSeriesLimit ? 1 : 0) != 0, (String)"Exceeded max unique series limit per server. Limit: %s. Series in current segment so far: %s", (int)this._maxSeriesLimit, (int)seriesBuilderMap.size());
        }
        return new TimeSeriesResultsBlock(new TimeSeriesBuilderBlock(this._timeBuckets, seriesBuilderMap));
    }

    @Override
    public List<? extends Operator> getChildOperators() {
        return ImmutableList.of(this._projectOperator);
    }

    @Override
    @Nullable
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._projectOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = this._numDocsScanned * (long)this._projectOperator.getNumColumnsProjected();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, this._numTotalDocs);
    }

    @VisibleForTesting
    protected int[] getTimeValueIndex(long[] actualTimeValues, int numDocs) {
        if (this._storedTimeUnit == TimeUnit.MILLISECONDS) {
            return this.getTimeValueIndexMillis(actualTimeValues, numDocs);
        }
        int[] timeIndexes = new int[numDocs];
        long reference = this._timeBuckets.getTimeRangeStartExclusive();
        long divisor = this._timeBuckets.getBucketSize().getSeconds();
        for (int index = 0; index < numDocs; ++index) {
            timeIndexes[index] = (int)((actualTimeValues[index] - reference - 1L) / divisor);
        }
        return timeIndexes;
    }

    private int[] getTimeValueIndexMillis(long[] actualTimeValues, int numDocs) {
        int[] timeIndexes = new int[numDocs];
        long reference = this._timeBuckets.getTimeRangeStartExclusive() * 1000L;
        long divisor = this._timeBuckets.getBucketSize().toMillis();
        for (int index = 0; index < numDocs; ++index) {
            timeIndexes[index] = (int)((actualTimeValues[index] - reference - 1L) / divisor);
        }
        return timeIndexes;
    }

    public void processLongExpression(BlockValSet blockValSet, Map<Long, BaseTimeSeriesBuilder> seriesBuilderMap, int[] timeValueIndexes, Object[][] tagValues, int numDocs) {
        long[] valueColumnValues = blockValSet.getLongValuesSV();
        for (int docIdIndex = 0; docIdIndex < numDocs; ++docIdIndex) {
            Object[] tagValuesForDoc = new Object[this._groupByExpressions.size()];
            for (int tagIndex = 0; tagIndex < tagValues.length; ++tagIndex) {
                tagValuesForDoc[tagIndex] = tagValues[tagIndex][docIdIndex];
            }
            long hash = TimeSeries.hash((Object[])tagValuesForDoc);
            seriesBuilderMap.computeIfAbsent(hash, k -> this._seriesBuilderFactory.newTimeSeriesBuilder(this._aggInfo, Long.toString(hash), this._timeBuckets, this._groupByExpressions, tagValuesForDoc)).addValueAtIndex(timeValueIndexes[docIdIndex], Double.valueOf(valueColumnValues[docIdIndex]));
        }
    }

    public void processIntExpression(BlockValSet blockValSet, Map<Long, BaseTimeSeriesBuilder> seriesBuilderMap, int[] timeValueIndexes, Object[][] tagValues, int numDocs) {
        int[] valueColumnValues = blockValSet.getIntValuesSV();
        for (int docIdIndex = 0; docIdIndex < numDocs; ++docIdIndex) {
            Object[] tagValuesForDoc = new Object[this._groupByExpressions.size()];
            for (int tagIndex = 0; tagIndex < tagValues.length; ++tagIndex) {
                tagValuesForDoc[tagIndex] = tagValues[tagIndex][docIdIndex];
            }
            long hash = TimeSeries.hash((Object[])tagValuesForDoc);
            seriesBuilderMap.computeIfAbsent(hash, k -> this._seriesBuilderFactory.newTimeSeriesBuilder(this._aggInfo, Long.toString(hash), this._timeBuckets, this._groupByExpressions, tagValuesForDoc)).addValueAtIndex(timeValueIndexes[docIdIndex], Double.valueOf(valueColumnValues[docIdIndex]));
        }
    }

    public void processDoubleExpression(BlockValSet blockValSet, Map<Long, BaseTimeSeriesBuilder> seriesBuilderMap, int[] timeValueIndexes, Object[][] tagValues, int numDocs) {
        double[] valueColumnValues = blockValSet.getDoubleValuesSV();
        for (int docIdIndex = 0; docIdIndex < numDocs; ++docIdIndex) {
            Object[] tagValuesForDoc = new Object[this._groupByExpressions.size()];
            for (int tagIndex = 0; tagIndex < tagValues.length; ++tagIndex) {
                tagValuesForDoc[tagIndex] = tagValues[tagIndex][docIdIndex];
            }
            long hash = TimeSeries.hash((Object[])tagValuesForDoc);
            seriesBuilderMap.computeIfAbsent(hash, k -> this._seriesBuilderFactory.newTimeSeriesBuilder(this._aggInfo, Long.toString(hash), this._timeBuckets, this._groupByExpressions, tagValuesForDoc)).addValueAtIndex(timeValueIndexes[docIdIndex], Double.valueOf(valueColumnValues[docIdIndex]));
        }
    }

    public void processStringExpression(BlockValSet blockValSet, Map<Long, BaseTimeSeriesBuilder> seriesBuilderMap, int[] timeValueIndexes, Object[][] tagValues, int numDocs) {
        String[] valueColumnValues = blockValSet.getStringValuesSV();
        for (int docIdIndex = 0; docIdIndex < numDocs; ++docIdIndex) {
            Object[] tagValuesForDoc = new Object[this._groupByExpressions.size()];
            for (int tagIndex = 0; tagIndex < tagValues.length; ++tagIndex) {
                tagValuesForDoc[tagIndex] = tagValues[tagIndex][docIdIndex];
            }
            long hash = TimeSeries.hash((Object[])tagValuesForDoc);
            seriesBuilderMap.computeIfAbsent(hash, k -> this._seriesBuilderFactory.newTimeSeriesBuilder(this._aggInfo, Long.toString(hash), this._timeBuckets, this._groupByExpressions, tagValuesForDoc)).addValueAtIndex(timeValueIndexes[docIdIndex], valueColumnValues[docIdIndex]);
        }
    }

    private void applyTimeOffset(long[] timeValues, int numDocs) {
        if (this._timeOffset == 0L) {
            return;
        }
        for (int index = 0; index < numDocs; ++index) {
            timeValues[index] = timeValues[index] + this._timeOffset;
        }
    }
}

