/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;

public class ArrayAverageTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "arrayAverage";
    private TransformFunction _argument;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Exactly 1 argument is required for ArrayAverage transform function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The argument of ArrayAverage transform function must be a multi-valued column or a transform function");
        }
        if (!firstArgument.getResultMetadata().getDataType().getStoredType().isNumeric()) {
            throw new IllegalArgumentException("The argument of ArrayAverage transform function must be numeric");
        }
        this._argument = firstArgument;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initDoubleValuesSV(length);
        switch (this._argument.getResultMetadata().getDataType().getStoredType()) {
            case INT: {
                int[][] intValuesMV = this._argument.transformToIntValuesMV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    double sumRes = 0.0;
                    for (int value : intValuesMV[i]) {
                        sumRes += (double)value;
                    }
                    this._doubleValuesSV[i] = sumRes / (double)intValuesMV[i].length;
                }
                break;
            }
            case LONG: {
                long[][] longValuesMV = this._argument.transformToLongValuesMV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    double sumRes = 0.0;
                    for (long value : longValuesMV[i]) {
                        sumRes += (double)value;
                    }
                    this._doubleValuesSV[i] = sumRes / (double)longValuesMV[i].length;
                }
                break;
            }
            case FLOAT: {
                float[][] floatValuesMV = this._argument.transformToFloatValuesMV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    double sumRes = 0.0;
                    for (float value : floatValuesMV[i]) {
                        sumRes += (double)value;
                    }
                    this._doubleValuesSV[i] = sumRes / (double)floatValuesMV[i].length;
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValuesMV = this._argument.transformToDoubleValuesMV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    double sumRes = 0.0;
                    for (double value : doubleValuesMV[i]) {
                        sumRes += value;
                    }
                    this._doubleValuesSV[i] = sumRes / (double)doubleValuesMV[i].length;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._doubleValuesSV;
    }
}

