/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import com.yscope.clp.compressorfrontend.MessageDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.IdentifierTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLPDecodeTransformFunction
extends BaseTransformFunction {
    private static final Logger _logger = LoggerFactory.getLogger(CLPDecodeTransformFunction.class);
    private final List<TransformFunction> _transformFunctions = new ArrayList<TransformFunction>();
    private String _defaultValue = "null";

    @Override
    public String getName() {
        return TransformFunctionType.CLP_DECODE.getName();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        TransformFunction f;
        int i;
        super.init(arguments, columnContextMap);
        int numArgs = arguments.size();
        Preconditions.checkArgument((3 == numArgs || 4 == numArgs ? 1 : 0) != 0, (Object)"Syntax error: clpDecode takes 3 or 4 arguments - clpDecode(ColumnGroupName_logtype, ColumnGroupName_dictionaryVars, ColumnGroupName_encodedVars, defaultValue)");
        for (i = 0; i < 3; ++i) {
            f = arguments.get(i);
            Preconditions.checkArgument((boolean)(f instanceof IdentifierTransformFunction), (Object)("Argument " + i + " must be a column name (identifier)"));
            this._transformFunctions.add(f);
        }
        if (i < numArgs) {
            f = arguments.get(i++);
            Preconditions.checkArgument((boolean)(f instanceof LiteralTransformFunction), (Object)("Argument " + i + " must be a default value (literal)"));
            this._defaultValue = ((LiteralTransformFunction)f).getStringLiteral();
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return new TransformResultMetadata(FieldSpec.DataType.STRING, true, false);
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initStringValuesSV(length);
        int functionIdx = 0;
        TransformFunction logtypeTransformFunction = this._transformFunctions.get(functionIdx++);
        TransformFunction dictionaryVarsTransformFunction = this._transformFunctions.get(functionIdx++);
        TransformFunction encodedVarsTransformFunction = this._transformFunctions.get(functionIdx);
        String[] logtypes = logtypeTransformFunction.transformToStringValuesSV(valueBlock);
        String[][] dictionaryVars = dictionaryVarsTransformFunction.transformToStringValuesMV(valueBlock);
        long[][] encodedVars = encodedVarsTransformFunction.transformToLongValuesMV(valueBlock);
        MessageDecoder clpMessageDecoder = new MessageDecoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
        for (int i = 0; i < length; ++i) {
            try {
                this._stringValuesSV[i] = null == logtypes[i] ? null : clpMessageDecoder.decodeMessage(logtypes[i], dictionaryVars[i], encodedVars[i]);
                continue;
            }
            catch (Exception ex) {
                _logger.error("Failed to decode CLP-encoded field.", (Throwable)ex);
                this._stringValuesSV[i] = this._defaultValue;
            }
        }
        return this._stringValuesSV;
    }
}

