/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.ComputeDifferentlyWhenNullHandlingEnabledTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.TimestampUtils;
import org.roaringbitmap.RoaringBitmap;

public class CaseTransformFunction
extends ComputeDifferentlyWhenNullHandlingEnabledTransformFunction {
    public static final String FUNCTION_NAME = "case";
    private List<TransformFunction> _whenStatements = new ArrayList<TransformFunction>();
    private List<TransformFunction> _thenStatements = new ArrayList<TransformFunction>();
    private TransformFunction _elseStatement;
    private TransformResultMetadata _resultMetadata;
    private boolean[] _computeThenStatements;
    private int[] _selectedResults;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap, boolean nullHandlingEnabled) {
        super.init(arguments, columnContextMap, nullHandlingEnabled);
        if (arguments.size() < 2) {
            throw new IllegalArgumentException("At least two arguments are required for CASE-WHEN function");
        }
        int numWhenStatements = arguments.size() / 2;
        this._whenStatements = new ArrayList<TransformFunction>(numWhenStatements);
        this._thenStatements = new ArrayList<TransformFunction>(numWhenStatements);
        for (int i = 0; i < numWhenStatements; ++i) {
            this._whenStatements.add(arguments.get(i * 2));
            this._thenStatements.add(arguments.get(i * 2 + 1));
        }
        if (arguments.size() % 2 != 0 && !this.isNullLiteral(arguments.get(arguments.size() - 1))) {
            this._elseStatement = arguments.get(arguments.size() - 1);
        }
        this._resultMetadata = new TransformResultMetadata(this.calculateResultType(), true, false);
        this._computeThenStatements = new boolean[numWhenStatements];
    }

    private boolean isNullLiteral(TransformFunction function) {
        return function instanceof LiteralTransformFunction && ((LiteralTransformFunction)function).isNull();
    }

    private FieldSpec.DataType calculateResultType() {
        FieldSpec.DataType dataType;
        MutablePair typeAndUnresolvedLiterals = new MutablePair((Object)FieldSpec.DataType.UNKNOWN, new ArrayList());
        for (TransformFunction thenStatement : this._thenStatements) {
            this.upcast((MutablePair<FieldSpec.DataType, List<String>>)typeAndUnresolvedLiterals, thenStatement);
        }
        if (this._elseStatement != null) {
            this.upcast((MutablePair<FieldSpec.DataType, List<String>>)typeAndUnresolvedLiterals, this._elseStatement);
        }
        return (dataType = (FieldSpec.DataType)typeAndUnresolvedLiterals.getLeft()) != FieldSpec.DataType.UNKNOWN ? dataType : FieldSpec.DataType.STRING;
    }

    private void upcast(MutablePair<FieldSpec.DataType, List<String>> currentTypeAndUnresolvedLiterals, TransformFunction newFunction) {
        boolean isNewFunctionStringLiteral;
        TransformResultMetadata newMetadata = newFunction.getResultMetadata();
        Preconditions.checkArgument((boolean)newMetadata.isSingleValue(), (Object)"Unsupported multi-value expression in THEN/ELSE clause");
        FieldSpec.DataType newType = newMetadata.getDataType();
        if (newType == FieldSpec.DataType.UNKNOWN) {
            return;
        }
        FieldSpec.DataType currentType = (FieldSpec.DataType)currentTypeAndUnresolvedLiterals.getLeft();
        if (currentType == newType) {
            return;
        }
        List unresolvedLiterals = (List)currentTypeAndUnresolvedLiterals.getRight();
        boolean bl = isNewFunctionStringLiteral = newFunction instanceof LiteralTransformFunction && newType == FieldSpec.DataType.STRING;
        if (currentType == FieldSpec.DataType.UNKNOWN) {
            if (isNewFunctionStringLiteral) {
                unresolvedLiterals.add(((LiteralTransformFunction)newFunction).getStringLiteral());
            } else {
                currentTypeAndUnresolvedLiterals.setLeft((Object)newType);
                for (String unresolvedLiteral : unresolvedLiterals) {
                    this.checkLiteral(newType, unresolvedLiteral);
                }
                unresolvedLiterals.clear();
            }
        } else {
            assert (unresolvedLiterals.isEmpty());
            if (isNewFunctionStringLiteral) {
                this.checkLiteral(currentType, ((LiteralTransformFunction)newFunction).getStringLiteral());
            } else {
                Preconditions.checkArgument((currentType.isNumeric() && newType.isNumeric() ? 1 : 0) != 0, (String)"Cannot upcast from %s to %s", (Object)currentType, (Object)newType);
                if (newType.ordinal() > currentType.ordinal()) {
                    currentTypeAndUnresolvedLiterals.setLeft((Object)newType);
                }
            }
        }
    }

    private void checkLiteral(FieldSpec.DataType dataType, String literal) {
        switch (dataType) {
            case INT: {
                try {
                    Integer.parseInt(literal);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid literal: " + literal + " for INT");
                }
            }
            case LONG: {
                try {
                    Long.parseLong(literal);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid literal: " + literal + " for LONG");
                }
            }
            case FLOAT: {
                try {
                    Float.parseFloat(literal);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid literal: " + literal + " for FLOAT");
                }
            }
            case DOUBLE: {
                try {
                    Double.parseDouble(literal);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid literal: " + literal + " for DOUBLE");
                }
            }
            case BIG_DECIMAL: {
                try {
                    new BigDecimal(literal);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid literal: " + literal + " for BIG_DECIMAL");
                }
            }
            case BOOLEAN: {
                Preconditions.checkArgument((literal.equalsIgnoreCase("true") || literal.equalsIgnoreCase("false") || literal.equals("1") || literal.equals("0") ? 1 : 0) != 0, (String)"Invalid literal: %s for BOOLEAN", (Object)literal);
                break;
            }
            case TIMESTAMP: {
                try {
                    TimestampUtils.toTimestamp((String)literal);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid literal: " + literal + " for TIMESTAMP");
                }
            }
            case STRING: 
            case JSON: {
                break;
            }
            case BYTES: {
                try {
                    BytesUtils.toBytes((String)literal);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid literal: " + literal + " for BYTES");
                }
            }
            default: {
                throw new IllegalStateException("Unsupported data type: " + dataType);
            }
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    private int[] getSelectedArray(ValueBlock valueBlock, boolean nullHandlingEnabled) {
        int i;
        int numDocs = valueBlock.getNumDocs();
        if (this._selectedResults == null || this._selectedResults.length < numDocs) {
            this._selectedResults = new int[numDocs];
        }
        Arrays.fill(this._selectedResults, -1);
        Arrays.fill(this._computeThenStatements, false);
        BitSet unselectedDocs = new BitSet();
        unselectedDocs.set(0, numDocs);
        int numWhenStatements = this._whenStatements.size();
        for (i = 0; i < numWhenStatements; ++i) {
            TransformFunction whenStatement = this._whenStatements.get(i);
            int[] conditions = CaseTransformFunction.getWhenConditions(whenStatement, valueBlock, nullHandlingEnabled);
            int docId = unselectedDocs.nextSetBit(0);
            while (docId >= 0) {
                if (conditions[docId] == 1) {
                    unselectedDocs.clear(docId);
                    this._selectedResults[docId] = i;
                }
                docId = unselectedDocs.nextSetBit(docId + 1);
            }
            if (unselectedDocs.isEmpty()) break;
        }
        for (i = 0; i < numDocs; ++i) {
            if (this._selectedResults[i] == -1) continue;
            this._computeThenStatements[this._selectedResults[i]] = true;
        }
        return this._selectedResults;
    }

    private static int[] getWhenConditions(TransformFunction whenStatement, ValueBlock valueBlock, boolean nullHandlingEnabled) {
        if (!nullHandlingEnabled) {
            return whenStatement.transformToIntValuesSV(valueBlock);
        }
        int[] intResult = whenStatement.transformToIntValuesSV(valueBlock);
        RoaringBitmap bitmap = whenStatement.getNullBitmap(valueBlock);
        if (bitmap != null) {
            Iterator iterator = bitmap.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                intResult[i] = 0;
            }
        }
        return intResult;
    }

    @Override
    protected int[] transformToIntValuesSVUsingValue(ValueBlock valueBlock) {
        block6: {
            int docId;
            int[] selected = this.getSelectedArray(valueBlock, false);
            int numDocs = valueBlock.getNumDocs();
            this.initIntValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, int[]> thenStatementsIndexToValues = new HashMap<Integer, int[]>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, this._thenStatements.get(i).transformToIntValuesSV(valueBlock));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                this._intValuesSV[docId] = ((int[])thenStatementsIndexToValues.get(selected[docId]))[docId];
                unselectedDocs.clear(docId);
            }
            if (unselectedDocs.isEmpty()) break block6;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._intValuesSV[docId] = 0;
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                int[] intValues = this._elseStatement.transformToIntValuesSV(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._intValuesSV[docId2] = intValues[docId2];
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._intValuesSV;
    }

    @Override
    protected int[] transformToIntValuesSVUsingValueAndNull(ValueBlock valueBlock) {
        block8: {
            int docId;
            RoaringBitmap bitmap = new RoaringBitmap();
            int[] selected = this.getSelectedArray(valueBlock, true);
            int numDocs = valueBlock.getNumDocs();
            this.initIntValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, ImmutablePair> thenStatementsIndexToValues = new HashMap<Integer, ImmutablePair>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, ImmutablePair.of((Object)this._thenStatements.get(i).transformToIntValuesSV(valueBlock), (Object)this._thenStatements.get(i).getNullBitmap(valueBlock)));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                Pair nullValuePair = (Pair)thenStatementsIndexToValues.get(selected[docId]);
                this._intValuesSV[docId] = ((int[])nullValuePair.getLeft())[docId];
                RoaringBitmap nullBitmap = (RoaringBitmap)nullValuePair.getRight();
                if (nullBitmap != null && nullBitmap.contains(docId)) {
                    bitmap.add(docId);
                }
                unselectedDocs.clear(docId);
                if (unselectedDocs.isEmpty()) break;
            }
            if (unselectedDocs.isEmpty()) break block8;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._intValuesSV[docId] = 0;
                    bitmap.add(docId);
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                int[] intValues = this._elseStatement.transformToIntValuesSV(valueBlock);
                RoaringBitmap nullBitmap = this._elseStatement.getNullBitmap(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._intValuesSV[docId2] = intValues[docId2];
                    if (nullBitmap != null && nullBitmap.contains(docId2)) {
                        bitmap.add(docId2);
                    }
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._intValuesSV;
    }

    @Override
    protected long[] transformToLongValuesSVUsingValue(ValueBlock valueBlock) {
        block6: {
            int docId;
            int[] selected = this.getSelectedArray(valueBlock, false);
            int numDocs = valueBlock.getNumDocs();
            this.initLongValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, long[]> thenStatementsIndexToValues = new HashMap<Integer, long[]>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, this._thenStatements.get(i).transformToLongValuesSV(valueBlock));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                this._longValuesSV[docId] = ((long[])thenStatementsIndexToValues.get(selected[docId]))[docId];
                unselectedDocs.clear(docId);
            }
            if (unselectedDocs.isEmpty()) break block6;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._longValuesSV[docId] = 0L;
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                long[] longValues = this._elseStatement.transformToLongValuesSV(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._longValuesSV[docId2] = longValues[docId2];
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._longValuesSV;
    }

    @Override
    protected long[] transformToLongValuesSVUsingValueAndNull(ValueBlock valueBlock) {
        block8: {
            int docId;
            RoaringBitmap bitmap = new RoaringBitmap();
            int[] selected = this.getSelectedArray(valueBlock, true);
            int numDocs = valueBlock.getNumDocs();
            this.initLongValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, ImmutablePair> thenStatementsIndexToValues = new HashMap<Integer, ImmutablePair>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, ImmutablePair.of((Object)this._thenStatements.get(i).transformToLongValuesSV(valueBlock), (Object)this._thenStatements.get(i).getNullBitmap(valueBlock)));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                Pair nullValuePair = (Pair)thenStatementsIndexToValues.get(selected[docId]);
                this._longValuesSV[docId] = ((long[])nullValuePair.getLeft())[docId];
                RoaringBitmap nullBitmap = (RoaringBitmap)nullValuePair.getRight();
                if (nullBitmap != null && nullBitmap.contains(docId)) {
                    bitmap.add(docId);
                }
                unselectedDocs.clear(docId);
                if (unselectedDocs.isEmpty()) break;
            }
            if (unselectedDocs.isEmpty()) break block8;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._longValuesSV[docId] = 0L;
                    bitmap.add(docId);
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                long[] longValues = this._elseStatement.transformToLongValuesSV(valueBlock);
                RoaringBitmap nullBitmap = this._elseStatement.getNullBitmap(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._longValuesSV[docId2] = longValues[docId2];
                    if (nullBitmap != null && nullBitmap.contains(docId2)) {
                        bitmap.add(docId2);
                    }
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._longValuesSV;
    }

    @Override
    protected float[] transformToFloatValuesSVUsingValue(ValueBlock valueBlock) {
        block6: {
            int docId;
            int[] selected = this.getSelectedArray(valueBlock, false);
            int numDocs = valueBlock.getNumDocs();
            this.initFloatValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, float[]> thenStatementsIndexToValues = new HashMap<Integer, float[]>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, this._thenStatements.get(i).transformToFloatValuesSV(valueBlock));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                this._floatValuesSV[docId] = ((float[])thenStatementsIndexToValues.get(selected[docId]))[docId];
                unselectedDocs.clear(docId);
            }
            if (unselectedDocs.isEmpty()) break block6;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._floatValuesSV[docId] = 0.0f;
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                float[] floatValues = this._elseStatement.transformToFloatValuesSV(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._floatValuesSV[docId2] = floatValues[docId2];
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._floatValuesSV;
    }

    @Override
    protected float[] transformToFloatValuesSVUsingValueAndNull(ValueBlock valueBlock) {
        block8: {
            int docId;
            RoaringBitmap bitmap = new RoaringBitmap();
            int[] selected = this.getSelectedArray(valueBlock, true);
            int numDocs = valueBlock.getNumDocs();
            this.initFloatValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, ImmutablePair> thenStatementsIndexToValues = new HashMap<Integer, ImmutablePair>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, ImmutablePair.of((Object)this._thenStatements.get(i).transformToFloatValuesSV(valueBlock), (Object)this._thenStatements.get(i).getNullBitmap(valueBlock)));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                Pair nullValuePair = (Pair)thenStatementsIndexToValues.get(selected[docId]);
                this._floatValuesSV[docId] = ((float[])nullValuePair.getLeft())[docId];
                RoaringBitmap nullBitmap = (RoaringBitmap)nullValuePair.getRight();
                if (nullBitmap != null && nullBitmap.contains(docId)) {
                    bitmap.add(docId);
                }
                unselectedDocs.clear(docId);
                if (unselectedDocs.isEmpty()) break;
            }
            if (unselectedDocs.isEmpty()) break block8;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._floatValuesSV[docId] = 0.0f;
                    bitmap.add(docId);
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                float[] floatValues = this._elseStatement.transformToFloatValuesSV(valueBlock);
                RoaringBitmap nullBitmap = this._elseStatement.getNullBitmap(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._floatValuesSV[docId2] = floatValues[docId2];
                    if (nullBitmap != null && nullBitmap.contains(docId2)) {
                        bitmap.add(docId2);
                    }
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._floatValuesSV;
    }

    @Override
    protected double[] transformToDoubleValuesSVUsingValue(ValueBlock valueBlock) {
        block6: {
            int docId;
            int[] selected = this.getSelectedArray(valueBlock, false);
            int numDocs = valueBlock.getNumDocs();
            this.initDoubleValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, double[]> thenStatementsIndexToValues = new HashMap<Integer, double[]>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, this._thenStatements.get(i).transformToDoubleValuesSV(valueBlock));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                this._doubleValuesSV[docId] = ((double[])thenStatementsIndexToValues.get(selected[docId]))[docId];
                unselectedDocs.clear(docId);
            }
            if (unselectedDocs.isEmpty()) break block6;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._doubleValuesSV[docId] = 0.0;
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                double[] doubleValues = this._elseStatement.transformToDoubleValuesSV(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._doubleValuesSV[docId2] = doubleValues[docId2];
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._doubleValuesSV;
    }

    @Override
    protected double[] transformToDoubleValuesSVUsingValueAndNull(ValueBlock valueBlock) {
        block8: {
            int docId;
            RoaringBitmap bitmap = new RoaringBitmap();
            int[] selected = this.getSelectedArray(valueBlock, true);
            int numDocs = valueBlock.getNumDocs();
            this.initDoubleValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, ImmutablePair> thenStatementsIndexToValues = new HashMap<Integer, ImmutablePair>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, ImmutablePair.of((Object)this._thenStatements.get(i).transformToDoubleValuesSV(valueBlock), (Object)this._thenStatements.get(i).getNullBitmap(valueBlock)));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                Pair nullValuePair = (Pair)thenStatementsIndexToValues.get(selected[docId]);
                this._doubleValuesSV[docId] = ((double[])nullValuePair.getLeft())[docId];
                RoaringBitmap nullBitmap = (RoaringBitmap)nullValuePair.getRight();
                if (nullBitmap != null && nullBitmap.contains(docId)) {
                    bitmap.add(docId);
                }
                unselectedDocs.clear(docId);
                if (unselectedDocs.isEmpty()) break;
            }
            if (unselectedDocs.isEmpty()) break block8;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._doubleValuesSV[docId] = 0.0;
                    bitmap.add(docId);
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                double[] doubleValues = this._elseStatement.transformToDoubleValuesSV(valueBlock);
                RoaringBitmap nullBitmap = this._elseStatement.getNullBitmap(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._doubleValuesSV[docId2] = doubleValues[docId2];
                    if (nullBitmap != null && nullBitmap.contains(docId2)) {
                        bitmap.add(docId2);
                    }
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._doubleValuesSV;
    }

    @Override
    protected BigDecimal[] transformToBigDecimalValuesSVUsingValue(ValueBlock valueBlock) {
        block6: {
            int docId;
            int[] selected = this.getSelectedArray(valueBlock, false);
            int numDocs = valueBlock.getNumDocs();
            this.initBigDecimalValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, BigDecimal[]> thenStatementsIndexToValues = new HashMap<Integer, BigDecimal[]>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, this._thenStatements.get(i).transformToBigDecimalValuesSV(valueBlock));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                this._bigDecimalValuesSV[docId] = ((BigDecimal[])thenStatementsIndexToValues.get(selected[docId]))[docId];
                unselectedDocs.clear(docId);
            }
            if (unselectedDocs.isEmpty()) break block6;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._bigDecimalValuesSV[docId] = CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                BigDecimal[] bigDecimalValues = this._elseStatement.transformToBigDecimalValuesSV(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._bigDecimalValuesSV[docId2] = bigDecimalValues[docId2];
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._bigDecimalValuesSV;
    }

    @Override
    protected BigDecimal[] transformToBigDecimalValuesSVUsingValueAndNull(ValueBlock valueBlock) {
        block8: {
            int docId;
            RoaringBitmap bitmap = new RoaringBitmap();
            int[] selected = this.getSelectedArray(valueBlock, true);
            int numDocs = valueBlock.getNumDocs();
            this.initBigDecimalValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, ImmutablePair> thenStatementsIndexToValues = new HashMap<Integer, ImmutablePair>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, ImmutablePair.of((Object)this._thenStatements.get(i).transformToBigDecimalValuesSV(valueBlock), (Object)this._thenStatements.get(i).getNullBitmap(valueBlock)));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                Pair nullValuePair = (Pair)thenStatementsIndexToValues.get(selected[docId]);
                this._bigDecimalValuesSV[docId] = ((BigDecimal[])nullValuePair.getLeft())[docId];
                RoaringBitmap nullBitmap = (RoaringBitmap)nullValuePair.getRight();
                if (nullBitmap != null && nullBitmap.contains(docId)) {
                    bitmap.add(docId);
                }
                unselectedDocs.clear(docId);
                if (unselectedDocs.isEmpty()) break;
            }
            if (unselectedDocs.isEmpty()) break block8;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._bigDecimalValuesSV[docId] = CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
                    bitmap.add(docId);
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                BigDecimal[] bigDecimalValues = this._elseStatement.transformToBigDecimalValuesSV(valueBlock);
                RoaringBitmap nullBitmap = this._elseStatement.getNullBitmap(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._bigDecimalValuesSV[docId2] = bigDecimalValues[docId2];
                    if (nullBitmap != null && nullBitmap.contains(docId2)) {
                        bitmap.add(docId2);
                    }
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._bigDecimalValuesSV;
    }

    @Override
    protected String[] transformToStringValuesSVUsingValue(ValueBlock valueBlock) {
        block6: {
            int docId;
            int[] selected = this.getSelectedArray(valueBlock, false);
            int numDocs = valueBlock.getNumDocs();
            this.initStringValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, String[]> thenStatementsIndexToValues = new HashMap<Integer, String[]>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, this._thenStatements.get(i).transformToStringValuesSV(valueBlock));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                this._stringValuesSV[docId] = ((String[])thenStatementsIndexToValues.get(selected[docId]))[docId];
                unselectedDocs.clear(docId);
            }
            if (unselectedDocs.isEmpty()) break block6;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._stringValuesSV[docId] = "";
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                String[] stringValues = this._elseStatement.transformToStringValuesSV(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._stringValuesSV[docId2] = stringValues[docId2];
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._stringValuesSV;
    }

    @Override
    protected String[] transformToStringValuesSVUsingValueAndNull(ValueBlock valueBlock) {
        block8: {
            int docId;
            RoaringBitmap bitmap = new RoaringBitmap();
            int[] selected = this.getSelectedArray(valueBlock, true);
            int numDocs = valueBlock.getNumDocs();
            this.initStringValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, ImmutablePair> thenStatementsIndexToValues = new HashMap<Integer, ImmutablePair>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, ImmutablePair.of((Object)this._thenStatements.get(i).transformToStringValuesSV(valueBlock), (Object)this._thenStatements.get(i).getNullBitmap(valueBlock)));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                Pair nullValuePair = (Pair)thenStatementsIndexToValues.get(selected[docId]);
                this._stringValuesSV[docId] = ((String[])nullValuePair.getLeft())[docId];
                RoaringBitmap nullBitmap = (RoaringBitmap)nullValuePair.getRight();
                if (nullBitmap != null && nullBitmap.contains(docId)) {
                    bitmap.add(docId);
                }
                unselectedDocs.clear(docId);
                if (unselectedDocs.isEmpty()) break;
            }
            if (unselectedDocs.isEmpty()) break block8;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._stringValuesSV[docId] = "";
                    bitmap.add(docId);
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                String[] stringValues = this._elseStatement.transformToStringValuesSV(valueBlock);
                RoaringBitmap nullBitmap = this._elseStatement.getNullBitmap(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._stringValuesSV[docId2] = stringValues[docId2];
                    if (nullBitmap != null && nullBitmap.contains(docId2)) {
                        bitmap.add(docId2);
                    }
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._stringValuesSV;
    }

    @Override
    protected byte[][] transformToBytesValuesSVUsingValue(ValueBlock valueBlock) {
        block6: {
            int docId;
            int[] selected = this.getSelectedArray(valueBlock, false);
            int numDocs = valueBlock.getNumDocs();
            this.initBytesValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, byte[][]> thenStatementsIndexToValues = new HashMap<Integer, byte[][]>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, this._thenStatements.get(i).transformToBytesValuesSV(valueBlock));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                this._bytesValuesSV[docId] = ((byte[][])thenStatementsIndexToValues.get(selected[docId]))[docId];
                unselectedDocs.clear(docId);
            }
            if (unselectedDocs.isEmpty()) break block6;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._bytesValuesSV[docId] = CommonConstants.NullValuePlaceHolder.BYTES;
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                byte[][] bytesValues = this._elseStatement.transformToBytesValuesSV(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._bytesValuesSV[docId2] = bytesValues[docId2];
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._bytesValuesSV;
    }

    @Override
    protected byte[][] transformToBytesValuesSVUsingValueAndNull(ValueBlock valueBlock) {
        block8: {
            int docId;
            RoaringBitmap bitmap = new RoaringBitmap();
            int[] selected = this.getSelectedArray(valueBlock, true);
            int numDocs = valueBlock.getNumDocs();
            this.initStringValuesSV(numDocs);
            int numThenStatements = this._thenStatements.size();
            BitSet unselectedDocs = new BitSet();
            unselectedDocs.set(0, numDocs);
            HashMap<Integer, ImmutablePair> thenStatementsIndexToValues = new HashMap<Integer, ImmutablePair>();
            for (int i = 0; i < numThenStatements; ++i) {
                if (!this._computeThenStatements[i]) continue;
                thenStatementsIndexToValues.put(i, ImmutablePair.of((Object)this._thenStatements.get(i).transformToBytesValuesSV(valueBlock), (Object)this._thenStatements.get(i).getNullBitmap(valueBlock)));
            }
            for (docId = 0; docId < numDocs; ++docId) {
                if (selected[docId] < 0) continue;
                Pair nullValuePair = (Pair)thenStatementsIndexToValues.get(selected[docId]);
                this._bytesValuesSV[docId] = ((byte[][])nullValuePair.getLeft())[docId];
                RoaringBitmap nullBitmap = (RoaringBitmap)nullValuePair.getRight();
                if (nullBitmap != null && nullBitmap.contains(docId)) {
                    bitmap.add(docId);
                }
                unselectedDocs.clear(docId);
                if (unselectedDocs.isEmpty()) break;
            }
            if (unselectedDocs.isEmpty()) break block8;
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    this._bytesValuesSV[docId] = CommonConstants.NullValuePlaceHolder.BYTES;
                    bitmap.add(docId);
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                byte[][] bytesValues = this._elseStatement.transformToBytesValuesSV(valueBlock);
                RoaringBitmap nullBitmap = this._elseStatement.getNullBitmap(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    this._bytesValuesSV[docId2] = bytesValues[docId2];
                    if (nullBitmap != null && nullBitmap.contains(docId2)) {
                        bitmap.add(docId2);
                    }
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        return this._bytesValuesSV;
    }

    @Override
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        int docId;
        int[] selected = this.getSelectedArray(valueBlock, true);
        int numDocs = valueBlock.getNumDocs();
        int numThenStatements = this._thenStatements.size();
        BitSet unselectedDocs = new BitSet();
        unselectedDocs.set(0, numDocs);
        RoaringBitmap bitmap = new RoaringBitmap();
        HashMap<Integer, RoaringBitmap> thenStatementsIndexToValues = new HashMap<Integer, RoaringBitmap>();
        for (int i = 0; i < numThenStatements; ++i) {
            if (!this._computeThenStatements[i]) continue;
            thenStatementsIndexToValues.put(i, this._thenStatements.get(i).getNullBitmap(valueBlock));
        }
        for (docId = 0; docId < numDocs; ++docId) {
            if (selected[docId] < 0) continue;
            RoaringBitmap nullBitmap = (RoaringBitmap)thenStatementsIndexToValues.get(selected[docId]);
            if (nullBitmap != null && nullBitmap.contains(docId)) {
                bitmap.add(docId);
            }
            unselectedDocs.clear(docId);
        }
        if (!unselectedDocs.isEmpty()) {
            if (this._elseStatement == null) {
                docId = unselectedDocs.nextSetBit(0);
                while (docId >= 0) {
                    bitmap.add(docId);
                    docId = unselectedDocs.nextSetBit(docId + 1);
                }
            } else {
                RoaringBitmap nullBitmap = this._elseStatement.getNullBitmap(valueBlock);
                int docId2 = unselectedDocs.nextSetBit(0);
                while (docId2 >= 0) {
                    if (nullBitmap != null && nullBitmap.contains(docId2)) {
                        bitmap.add(docId2);
                    }
                    docId2 = unselectedDocs.nextSetBit(docId2 + 1);
                }
            }
        }
        if (bitmap.isEmpty()) {
            return null;
        }
        return bitmap;
    }
}

