/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import com.yscope.clp.compressorfrontend.AbstractClpEncodedSubquery;
import com.yscope.clp.compressorfrontend.EightByteClpEncodedSubquery;
import com.yscope.clp.compressorfrontend.EightByteClpWildcardQueryEncoder;
import com.yscope.clp.compressorfrontend.MessageDecoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.IdentifierTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClpEncodedVarsMatchTransformFunction
extends BaseTransformFunction {
    private static final Logger _logger = LoggerFactory.getLogger(ClpEncodedVarsMatchTransformFunction.class);
    private final List<TransformFunction> _transformFunctions = new ArrayList<TransformFunction>();
    private byte[] _serializedVarTypes;
    private byte[] _serializedVarWildcardQueries;
    private int[] _varWildcardQueryEndIndexes;

    @Override
    public String getName() {
        return TransformFunctionType.CLP_ENCODED_VARS_MATCH.getName();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        Preconditions.checkArgument((arguments.size() == 4 ? 1 : 0) != 0, (Object)"Syntax error: clpEncodedVarsMatch takes 4 arguments - clpEncodedVarsMatch(columnGroupName_logtype, columnGroupName_encodedVars, wildcardQuery, subQueryIndex");
        Iterator<TransformFunction> argsIter = arguments.iterator();
        TransformFunction f = argsIter.next();
        Preconditions.checkArgument((boolean)(f instanceof IdentifierTransformFunction), (Object)"1st argument must be an identifier");
        this._transformFunctions.add(f);
        f = argsIter.next();
        Preconditions.checkArgument((boolean)(f instanceof IdentifierTransformFunction), (Object)"2nd argument must be an identifier");
        this._transformFunctions.add(f);
        f = argsIter.next();
        Preconditions.checkArgument((boolean)(f instanceof LiteralTransformFunction), (Object)"3rd argument must be a string literal");
        String wildcardQuery = ((LiteralTransformFunction)f).getStringLiteral();
        f = argsIter.next();
        Preconditions.checkArgument((boolean)(f instanceof LiteralTransformFunction), (Object)"4th argument must be a long literal");
        long subqueryIndex = ((LiteralTransformFunction)f).getLongLiteral();
        EightByteClpWildcardQueryEncoder queryEncoder = new EightByteClpWildcardQueryEncoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
        EightByteClpEncodedSubquery[] subqueries = queryEncoder.encode(wildcardQuery);
        if (subqueryIndex < 0L || subqueryIndex > (long)subqueries.length) {
            throw new IllegalArgumentException("Invalid subquery index.");
        }
        EightByteClpEncodedSubquery subquery = subqueries[(int)subqueryIndex];
        int numEncodedVarWildcardQueries = subquery.getNumEncodedVarWildcardQueries();
        if (0 == numEncodedVarWildcardQueries) {
            throw new IllegalArgumentException("Subquery doesn't contain any wildcard queries for encoded variables.");
        }
        try {
            ByteArrayOutputStream serializedVarTypes = new ByteArrayOutputStream();
            ByteArrayOutputStream serializedWildcardQueries = new ByteArrayOutputStream();
            ArrayList<Integer> serializedWildcardQueryEndIndices = new ArrayList<Integer>();
            for (AbstractClpEncodedSubquery.VariableWildcardQuery q : subquery.getEncodedVarWildcardQueries()) {
                serializedVarTypes.write(q.getType());
                serializedWildcardQueries.write(q.getQuery().toByteArray());
                serializedWildcardQueryEndIndices.add(serializedWildcardQueries.size());
            }
            this._serializedVarTypes = serializedVarTypes.toByteArray();
            this._serializedVarWildcardQueries = serializedWildcardQueries.toByteArray();
            this._varWildcardQueryEndIndexes = ArrayUtils.toPrimitive((Integer[])serializedWildcardQueryEndIndices.toArray(new Integer[0]));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Wildcard query could not be serialized", e);
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return new TransformResultMetadata(FieldSpec.DataType.BOOLEAN, true, false);
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        if (null == this._intValuesSV) {
            this._intValuesSV = new int[length];
        }
        int functionIdx = 0;
        TransformFunction logtypeTransformFunction = this._transformFunctions.get(functionIdx++);
        TransformFunction encodedVarsTransformFunction = this._transformFunctions.get(functionIdx++);
        byte[][] logtypes = logtypeTransformFunction.transformToBytesValuesSV(valueBlock);
        long[][] encodedVars = encodedVarsTransformFunction.transformToLongValuesMV(valueBlock);
        MessageDecoder clpMessageDecoder = new MessageDecoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
        try {
            clpMessageDecoder.batchEncodedVarsWildcardMatch(logtypes, encodedVars, this._serializedVarTypes, this._serializedVarWildcardQueries, this._varWildcardQueryEndIndexes, this._intValuesSV);
        }
        catch (IOException ex) {
            _logger.error("Failed to perform wildcard match on (CLP) encoded variables field.", (Throwable)ex);
            Arrays.fill(this._intValuesSV, 0);
        }
        return this._intValuesSV;
    }
}

