/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.CommonConstants;
import org.roaringbitmap.RoaringBitmap;

public class CoalesceTransformFunction
extends BaseTransformFunction {
    private TransformFunction[] _transformFunctions;
    private FieldSpec.DataType _dataType;
    private TransformResultMetadata _resultMetadata;

    private static RoaringBitmap[] getNullBitMaps(ValueBlock valueBlock, TransformFunction[] transformFunctions) {
        RoaringBitmap[] roaringBitmaps = new RoaringBitmap[transformFunctions.length];
        for (int i = 0; i < roaringBitmaps.length; ++i) {
            TransformFunction func = transformFunctions[i];
            roaringBitmaps[i] = func.getNullBitmap(valueBlock);
        }
        return roaringBitmaps;
    }

    private static FieldSpec.DataType getCompatibleType(FieldSpec.DataType left, FieldSpec.DataType right) {
        if (left.isNumeric() && right.isNumeric()) {
            if (left == FieldSpec.DataType.BIG_DECIMAL || right == FieldSpec.DataType.BIG_DECIMAL) {
                return FieldSpec.DataType.BIG_DECIMAL;
            }
            if (left == FieldSpec.DataType.DOUBLE || right == FieldSpec.DataType.DOUBLE) {
                return FieldSpec.DataType.DOUBLE;
            }
            if (left == FieldSpec.DataType.FLOAT || right == FieldSpec.DataType.FLOAT) {
                return FieldSpec.DataType.FLOAT;
            }
            if (left == FieldSpec.DataType.LONG || right == FieldSpec.DataType.LONG) {
                return FieldSpec.DataType.LONG;
            }
            return FieldSpec.DataType.INT;
        }
        if (left == FieldSpec.DataType.UNKNOWN) {
            return right;
        }
        if (right == FieldSpec.DataType.UNKNOWN) {
            return left;
        }
        return FieldSpec.DataType.STRING;
    }

    private int[] getIntTransformResults(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initIntValuesSV(length);
        int width = this._transformFunctions.length;
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(valueBlock, this._transformFunctions);
        int[][] data = new int[width][];
        for (int i = 0; i < length; ++i) {
            boolean hasNonNullValue = false;
            for (int j = 0; j < width; ++j) {
                if (nullBitMaps[j] != null && nullBitMaps[j].contains(i)) continue;
                if (data[j] == null) {
                    data[j] = this._transformFunctions[j].transformToIntValuesSV(valueBlock);
                }
                hasNonNullValue = true;
                this._intValuesSV[i] = data[j][i];
                break;
            }
            if (hasNonNullValue) continue;
            this._intValuesSV[i] = 0;
        }
        return this._intValuesSV;
    }

    private long[] getLongTransformResults(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initLongValuesSV(length);
        int width = this._transformFunctions.length;
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(valueBlock, this._transformFunctions);
        long[][] data = new long[width][];
        for (int i = 0; i < length; ++i) {
            boolean hasNonNullValue = false;
            for (int j = 0; j < width; ++j) {
                if (nullBitMaps[j] != null && nullBitMaps[j].contains(i)) continue;
                if (data[j] == null) {
                    data[j] = this._transformFunctions[j].transformToLongValuesSV(valueBlock);
                }
                hasNonNullValue = true;
                this._longValuesSV[i] = data[j][i];
                break;
            }
            if (hasNonNullValue) continue;
            this._longValuesSV[i] = 0L;
        }
        return this._longValuesSV;
    }

    private float[] getFloatTransformResults(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initFloatValuesSV(length);
        int width = this._transformFunctions.length;
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(valueBlock, this._transformFunctions);
        float[][] data = new float[width][];
        for (int i = 0; i < length; ++i) {
            boolean hasNonNullValue = false;
            for (int j = 0; j < width; ++j) {
                if (nullBitMaps[j] != null && nullBitMaps[j].contains(i)) continue;
                if (data[j] == null) {
                    data[j] = this._transformFunctions[j].transformToFloatValuesSV(valueBlock);
                }
                hasNonNullValue = true;
                this._floatValuesSV[i] = data[j][i];
                break;
            }
            if (hasNonNullValue) continue;
            this._floatValuesSV[i] = 0.0f;
        }
        return this._floatValuesSV;
    }

    private double[] getDoubleTransformResults(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initDoubleValuesSV(length);
        int width = this._transformFunctions.length;
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(valueBlock, this._transformFunctions);
        double[][] data = new double[width][];
        for (int i = 0; i < length; ++i) {
            boolean hasNonNullValue = false;
            for (int j = 0; j < width; ++j) {
                if (nullBitMaps[j] != null && nullBitMaps[j].contains(i)) continue;
                if (data[j] == null) {
                    data[j] = this._transformFunctions[j].transformToDoubleValuesSV(valueBlock);
                }
                hasNonNullValue = true;
                this._doubleValuesSV[i] = data[j][i];
                break;
            }
            if (hasNonNullValue) continue;
            this._doubleValuesSV[i] = 0.0;
        }
        return this._doubleValuesSV;
    }

    private BigDecimal[] getBigDecimalTransformResults(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initBigDecimalValuesSV(length);
        int width = this._transformFunctions.length;
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(valueBlock, this._transformFunctions);
        BigDecimal[][] data = new BigDecimal[width][];
        for (int i = 0; i < length; ++i) {
            boolean hasNonNullValue = false;
            for (int j = 0; j < width; ++j) {
                if (nullBitMaps[j] != null && nullBitMaps[j].contains(i)) continue;
                if (data[j] == null) {
                    data[j] = this._transformFunctions[j].transformToBigDecimalValuesSV(valueBlock);
                }
                hasNonNullValue = true;
                this._bigDecimalValuesSV[i] = data[j][i];
                break;
            }
            if (hasNonNullValue) continue;
            this._bigDecimalValuesSV[i] = CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
        }
        return this._bigDecimalValuesSV;
    }

    private String[] getStringTransformResults(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initStringValuesSV(length);
        int width = this._transformFunctions.length;
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(valueBlock, this._transformFunctions);
        String[][] data = new String[width][];
        for (int i = 0; i < length; ++i) {
            boolean hasNonNullValue = false;
            for (int j = 0; j < width; ++j) {
                if (nullBitMaps[j] != null && nullBitMaps[j].contains(i)) continue;
                if (data[j] == null) {
                    data[j] = this._transformFunctions[j].transformToStringValuesSV(valueBlock);
                }
                hasNonNullValue = true;
                this._stringValuesSV[i] = data[j][i];
                break;
            }
            if (hasNonNullValue) continue;
            this._stringValuesSV[i] = "";
        }
        return this._stringValuesSV;
    }

    @Override
    public String getName() {
        return TransformFunctionType.COALESCE.getName();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        int argSize = arguments.size();
        Preconditions.checkArgument((argSize > 0 ? 1 : 0) != 0, (Object)"COALESCE needs to have at least one argument.");
        this._transformFunctions = new TransformFunction[argSize];
        for (int i = 0; i < argSize; ++i) {
            TransformFunction func = arguments.get(i);
            FieldSpec.DataType dataType = func.getResultMetadata().getDataType();
            this._dataType = this._dataType != null ? CoalesceTransformFunction.getCompatibleType(this._dataType, dataType) : dataType;
            this._transformFunctions[i] = func;
        }
        switch (this._dataType) {
            case INT: {
                this._resultMetadata = INT_SV_NO_DICTIONARY_METADATA;
                break;
            }
            case LONG: {
                this._resultMetadata = LONG_SV_NO_DICTIONARY_METADATA;
                break;
            }
            case FLOAT: {
                this._resultMetadata = FLOAT_SV_NO_DICTIONARY_METADATA;
                break;
            }
            case DOUBLE: {
                this._resultMetadata = DOUBLE_SV_NO_DICTIONARY_METADATA;
                break;
            }
            case BIG_DECIMAL: {
                this._resultMetadata = BIG_DECIMAL_SV_NO_DICTIONARY_METADATA;
                break;
            }
            case STRING: {
                this._resultMetadata = STRING_SV_NO_DICTIONARY_METADATA;
                break;
            }
            case UNKNOWN: {
                this._resultMetadata = UNKNOWN_METADATA;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Coalesce only supports numerical and string data type");
            }
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        if (this._dataType != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(valueBlock);
        }
        return this.getIntTransformResults(valueBlock);
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        if (this._dataType != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(valueBlock);
        }
        return this.getLongTransformResults(valueBlock);
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        if (this._dataType != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(valueBlock);
        }
        return this.getFloatTransformResults(valueBlock);
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        if (this._dataType != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(valueBlock);
        }
        return this.getDoubleTransformResults(valueBlock);
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        if (this._dataType != FieldSpec.DataType.BIG_DECIMAL) {
            return super.transformToBigDecimalValuesSV(valueBlock);
        }
        return this.getBigDecimalTransformResults(valueBlock);
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        if (this._dataType != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(valueBlock);
        }
        return this.getStringTransformResults(valueBlock);
    }

    @Override
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(valueBlock, this._transformFunctions);
        RoaringBitmap bitmap = nullBitMaps[0];
        if (bitmap == null || bitmap.isEmpty()) {
            return null;
        }
        for (int i = 1; i < nullBitMaps.length; ++i) {
            RoaringBitmap curBitmap = nullBitMaps[i];
            if (curBitmap == null || curBitmap.isEmpty()) {
                return null;
            }
            bitmap.and(curBitmap);
        }
        if (bitmap == null || bitmap.isEmpty()) {
            return null;
        }
        return bitmap;
    }
}

