/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.operator.transform.transformer.datetime.BaseDateTimeTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetime.DateTimeTransformerFactory;
import org.apache.pinot.core.operator.transform.transformer.datetime.EpochToEpochTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetime.EpochToSDFTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetime.SDFToEpochTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetime.SDFToSDFTransformer;
import org.roaringbitmap.RoaringBitmap;

public class DateTimeConversionTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "dateTimeConvert";
    private TransformFunction _mainTransformFunction;
    private BaseDateTimeTransformer<?, ?> _dateTimeTransformer;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        String bucketTimeZone;
        super.init(arguments, columnContextMap);
        if (arguments.size() == 5) {
            bucketTimeZone = ((LiteralTransformFunction)arguments.get(4)).getStringLiteral();
        } else if (arguments.size() == 4) {
            bucketTimeZone = null;
        } else {
            throw new IllegalArgumentException("Exactly 4 or 5 arguments are required for DATE_TIME_CONVERT transform function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || !firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The first argument of DATE_TIME_CONVERT transform function must be a single-valued column or a transform function");
        }
        this._mainTransformFunction = firstArgument;
        this._dateTimeTransformer = DateTimeTransformerFactory.getDateTimeTransformer(((LiteralTransformFunction)arguments.get(1)).getStringLiteral(), ((LiteralTransformFunction)arguments.get(2)).getStringLiteral(), ((LiteralTransformFunction)arguments.get(3)).getStringLiteral(), bucketTimeZone);
        this._resultMetadata = this._dateTimeTransformer instanceof EpochToEpochTransformer || this._dateTimeTransformer instanceof SDFToEpochTransformer ? LONG_SV_NO_DICTIONARY_METADATA : STRING_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata != LONG_SV_NO_DICTIONARY_METADATA) {
            return super.transformToLongValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initLongValuesSV(length);
        if (this._dateTimeTransformer instanceof EpochToEpochTransformer) {
            EpochToEpochTransformer transformer = (EpochToEpochTransformer)this._dateTimeTransformer;
            transformer.transform(this._mainTransformFunction.transformToLongValuesSV(valueBlock), this._longValuesSV, length);
        } else {
            SDFToEpochTransformer transformer = (SDFToEpochTransformer)this._dateTimeTransformer;
            transformer.transform(this._mainTransformFunction.transformToStringValuesSV(valueBlock), this._longValuesSV, length);
        }
        return this._longValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata != STRING_SV_NO_DICTIONARY_METADATA) {
            return super.transformToStringValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initStringValuesSV(length);
        if (this._dateTimeTransformer instanceof EpochToSDFTransformer) {
            EpochToSDFTransformer transformer = (EpochToSDFTransformer)this._dateTimeTransformer;
            transformer.transform(this._mainTransformFunction.transformToLongValuesSV(valueBlock), this._stringValuesSV, length);
        } else {
            SDFToSDFTransformer transformer = (SDFToSDFTransformer)this._dateTimeTransformer;
            transformer.transform(this._mainTransformFunction.transformToStringValuesSV(valueBlock), this._stringValuesSV, length);
        }
        return this._stringValuesSV;
    }

    @Override
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        return this._mainTransformFunction.getNullBitmap(valueBlock);
    }
}

