/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.pinot.common.function.DateTimeUtils;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.roaringbitmap.RoaringBitmap;

public class ExtractTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "extract";
    private TransformFunction _mainTransformFunction;
    private DateTimeUtils.ExtractFieldType _field;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for EXTRACT transform function");
        }
        this._field = DateTimeUtils.ExtractFieldType.valueOf((String)((LiteralTransformFunction)arguments.get(0)).getStringLiteral());
        this._mainTransformFunction = arguments.get(1);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return INT_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        this.initIntValuesSV(numDocs);
        long[] timestamps = this._mainTransformFunction.transformToLongValuesSV(valueBlock);
        IntStream.range(0, numDocs).forEach(i -> {
            this._intValuesSV[i] = DateTimeUtils.extract((DateTimeUtils.ExtractFieldType)this._field, (long)timestamps[i]);
        });
        return this._intValuesSV;
    }

    @Override
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        return this._mainTransformFunction.getNullBitmap(valueBlock);
    }
}

