/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class GenerateArrayTransformFunction
implements TransformFunction {
    public static final String FUNCTION_NAME = "generateArray";
    private final FieldSpec.DataType _dataType;
    private final int[] _intArrayLiteral;
    private final long[] _longArrayLiteral;
    private final float[] _floatArrayLiteral;
    private final double[] _doubleArrayLiteral;
    private volatile int[][] _intArrayResult;
    private volatile long[][] _longArrayResult;
    private volatile float[][] _floatArrayResult;
    private volatile double[][] _doubleArrayResult;

    public GenerateArrayTransformFunction(List<ExpressionContext> literalContexts) {
        Preconditions.checkNotNull(literalContexts);
        if (literalContexts.isEmpty()) {
            this._dataType = FieldSpec.DataType.UNKNOWN;
            this._intArrayLiteral = new int[0];
            this._longArrayLiteral = new long[0];
            this._floatArrayLiteral = new float[0];
            this._doubleArrayLiteral = new double[0];
            return;
        }
        Preconditions.checkState((literalContexts.size() == 2 || literalContexts.size() == 3 ? 1 : 0) != 0, (String)"GenerateArrayTransformFunction takes only 2 or 3 arguments, found: %s", (int)literalContexts.size());
        for (ExpressionContext literalContext : literalContexts) {
            Preconditions.checkState((literalContext.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"GenerateArrayTransformFunction only takes literals as arguments, found: %s", (Object)literalContext);
        }
        this._dataType = literalContexts.get(0).getLiteral().getType();
        switch (this._dataType) {
            case INT: {
                int startInt = literalContexts.get(0).getLiteral().getIntValue();
                int endInt = literalContexts.get(1).getLiteral().getIntValue();
                int incInt = literalContexts.size() == 3 ? literalContexts.get(2).getLiteral().getIntValue() : 1;
                Preconditions.checkState((endInt > startInt && incInt > 0 || startInt > endInt && incInt < 0 ? 1 : 0) != 0, (Object)"Incorrect Step value.");
                int size = (endInt - startInt) / incInt + 1;
                this._intArrayLiteral = new int[size];
                int i = 0;
                int value = startInt;
                while (i < size) {
                    this._intArrayLiteral[i] = value;
                    ++i;
                    value += incInt;
                }
                this._longArrayLiteral = null;
                this._floatArrayLiteral = null;
                this._doubleArrayLiteral = null;
                break;
            }
            case LONG: {
                long startLong = Long.parseLong(literalContexts.get(0).getLiteral().getStringValue());
                long endLong = Long.parseLong(literalContexts.get(1).getLiteral().getStringValue());
                long incLong = literalContexts.size() == 3 ? Long.parseLong(literalContexts.get(2).getLiteral().getStringValue()) : 1L;
                Preconditions.checkState((endLong > startLong && incLong > 0L || startLong > endLong && incLong < 0L ? 1 : 0) != 0, (Object)"Incorrect Step value.");
                int size = (int)((endLong - startLong) / incLong + 1L);
                this._longArrayLiteral = new long[size];
                int i = 0;
                while (i < size) {
                    this._longArrayLiteral[i] = startLong;
                    ++i;
                    startLong += incLong;
                }
                this._intArrayLiteral = null;
                this._floatArrayLiteral = null;
                this._doubleArrayLiteral = null;
                break;
            }
            case FLOAT: {
                float startFloat = Float.parseFloat(literalContexts.get(0).getLiteral().getStringValue());
                float endFloat = Float.parseFloat(literalContexts.get(1).getLiteral().getStringValue());
                float incFloat = literalContexts.size() == 3 ? Float.parseFloat(literalContexts.get(2).getLiteral().getStringValue()) : 1.0f;
                Preconditions.checkState((endFloat > startFloat && incFloat > 0.0f || startFloat > endFloat && incFloat < 0.0f ? 1 : 0) != 0, (Object)"Incorrect Step value.");
                int size = (int)((endFloat - startFloat) / incFloat + 1.0f);
                this._floatArrayLiteral = new float[size];
                int i = 0;
                while (i < size) {
                    this._floatArrayLiteral[i] = startFloat;
                    ++i;
                    startFloat += incFloat;
                }
                this._intArrayLiteral = null;
                this._longArrayLiteral = null;
                this._doubleArrayLiteral = null;
                break;
            }
            case DOUBLE: {
                double startDouble = Double.parseDouble(literalContexts.get(0).getLiteral().getStringValue());
                double endDouble = Double.parseDouble(literalContexts.get(1).getLiteral().getStringValue());
                double incDouble = literalContexts.size() == 3 ? Double.parseDouble(literalContexts.get(2).getLiteral().getStringValue()) : 1.0;
                Preconditions.checkState((endDouble > startDouble && incDouble > 0.0 || startDouble > endDouble && incDouble < 0.0 ? 1 : 0) != 0, (Object)"Incorrect Step value.");
                int size = (int)((endDouble - startDouble) / incDouble + 1.0);
                this._doubleArrayLiteral = new double[size];
                int i = 0;
                while (i < size) {
                    this._doubleArrayLiteral[i] = startDouble;
                    ++i;
                    startDouble += incDouble;
                }
                this._intArrayLiteral = null;
                this._longArrayLiteral = null;
                this._floatArrayLiteral = null;
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for GenerateArrayTransformFunction: " + this._dataType + ", literal contexts: " + Arrays.toString(literalContexts.toArray()));
            }
        }
    }

    public int[] getIntArrayLiteral() {
        return this._intArrayLiteral;
    }

    public long[] getLongArrayLiteral() {
        return this._longArrayLiteral;
    }

    public float[] getFloatArrayLiteral() {
        return this._floatArrayLiteral;
    }

    public double[] getDoubleArrayLiteral() {
        return this._doubleArrayLiteral;
    }

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        if (arguments.size() < 2) {
            throw new IllegalArgumentException("At least 2 arguments are required for generateArray function");
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return new TransformResultMetadata(this._dataType, false, false);
    }

    @Override
    @Nullable
    public Dictionary getDictionary() {
        return null;
    }

    @Override
    public int[] transformToDictIdsSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToDictIdsMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[][] transformToBytesValuesSV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToIntValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        Object intArrayResult = this._intArrayResult;
        if (intArrayResult == null || ((int[][])intArrayResult).length < numDocs) {
            intArrayResult = new int[numDocs][];
            int[] intArrayLiteral = this._intArrayLiteral;
            if (intArrayLiteral == null) {
                switch (this._dataType) {
                    case LONG: {
                        intArrayLiteral = new int[this._longArrayLiteral.length];
                        for (int i = 0; i < this._longArrayLiteral.length; ++i) {
                            intArrayLiteral[i] = (int)this._longArrayLiteral[i];
                        }
                        break;
                    }
                    case FLOAT: {
                        intArrayLiteral = new int[this._floatArrayLiteral.length];
                        for (int i = 0; i < this._floatArrayLiteral.length; ++i) {
                            intArrayLiteral[i] = (int)this._floatArrayLiteral[i];
                        }
                        break;
                    }
                    case DOUBLE: {
                        intArrayLiteral = new int[this._doubleArrayLiteral.length];
                        for (int i = 0; i < this._doubleArrayLiteral.length; ++i) {
                            intArrayLiteral[i] = (int)this._doubleArrayLiteral[i];
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unable to convert data type: " + this._dataType + " to in array");
                    }
                }
            }
            Arrays.fill((Object[])intArrayResult, intArrayLiteral);
            this._intArrayResult = intArrayResult;
        }
        return intArrayResult;
    }

    @Override
    public long[][] transformToLongValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        Object longArrayResult = this._longArrayResult;
        if (longArrayResult == null || ((long[][])longArrayResult).length < numDocs) {
            longArrayResult = new long[numDocs][];
            long[] longArrayLiteral = this._longArrayLiteral;
            if (longArrayLiteral == null) {
                switch (this._dataType) {
                    case INT: {
                        longArrayLiteral = new long[this._intArrayLiteral.length];
                        for (int i = 0; i < this._intArrayLiteral.length; ++i) {
                            longArrayLiteral[i] = this._intArrayLiteral[i];
                        }
                        break;
                    }
                    case FLOAT: {
                        longArrayLiteral = new long[this._floatArrayLiteral.length];
                        for (int i = 0; i < this._floatArrayLiteral.length; ++i) {
                            longArrayLiteral[i] = (long)this._floatArrayLiteral[i];
                        }
                        break;
                    }
                    case DOUBLE: {
                        longArrayLiteral = new long[this._doubleArrayLiteral.length];
                        for (int i = 0; i < this._doubleArrayLiteral.length; ++i) {
                            longArrayLiteral[i] = (long)this._doubleArrayLiteral[i];
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unable to convert data type: " + this._dataType + " to long array");
                    }
                }
            }
            Arrays.fill((Object[])longArrayResult, longArrayLiteral);
            this._longArrayResult = longArrayResult;
        }
        return longArrayResult;
    }

    @Override
    public float[][] transformToFloatValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        Object floatArrayResult = this._floatArrayResult;
        if (floatArrayResult == null || ((float[][])floatArrayResult).length < numDocs) {
            floatArrayResult = new float[numDocs][];
            float[] floatArrayLiteral = this._floatArrayLiteral;
            if (floatArrayLiteral == null) {
                switch (this._dataType) {
                    case INT: {
                        floatArrayLiteral = new float[this._intArrayLiteral.length];
                        for (int i = 0; i < this._intArrayLiteral.length; ++i) {
                            floatArrayLiteral[i] = this._intArrayLiteral[i];
                        }
                        break;
                    }
                    case LONG: {
                        floatArrayLiteral = new float[this._longArrayLiteral.length];
                        for (int i = 0; i < this._longArrayLiteral.length; ++i) {
                            floatArrayLiteral[i] = this._longArrayLiteral[i];
                        }
                        break;
                    }
                    case DOUBLE: {
                        floatArrayLiteral = new float[this._doubleArrayLiteral.length];
                        for (int i = 0; i < this._doubleArrayLiteral.length; ++i) {
                            floatArrayLiteral[i] = (float)this._doubleArrayLiteral[i];
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unable to convert data type: " + this._dataType + " to float array");
                    }
                }
            }
            Arrays.fill((Object[])floatArrayResult, floatArrayLiteral);
            this._floatArrayResult = floatArrayResult;
        }
        return floatArrayResult;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ValueBlock valueBlock) {
        int numDocs = valueBlock.getNumDocs();
        Object doubleArrayResult = this._doubleArrayResult;
        if (doubleArrayResult == null || ((double[][])doubleArrayResult).length < numDocs) {
            doubleArrayResult = new double[numDocs][];
            double[] doubleArrayLiteral = this._doubleArrayLiteral;
            if (doubleArrayLiteral == null) {
                switch (this._dataType) {
                    case INT: {
                        doubleArrayLiteral = new double[this._intArrayLiteral.length];
                        for (int i = 0; i < this._intArrayLiteral.length; ++i) {
                            doubleArrayLiteral[i] = this._intArrayLiteral[i];
                        }
                        break;
                    }
                    case LONG: {
                        doubleArrayLiteral = new double[this._longArrayLiteral.length];
                        for (int i = 0; i < this._longArrayLiteral.length; ++i) {
                            doubleArrayLiteral[i] = this._longArrayLiteral[i];
                        }
                        break;
                    }
                    case FLOAT: {
                        doubleArrayLiteral = new double[this._floatArrayLiteral.length];
                        for (int i = 0; i < this._floatArrayLiteral.length; ++i) {
                            doubleArrayLiteral[i] = this._floatArrayLiteral[i];
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unable to convert data type: " + this._dataType + " to double array");
                    }
                }
            }
            Arrays.fill((Object[])doubleArrayResult, doubleArrayLiteral);
            this._doubleArrayResult = doubleArrayResult;
        }
        return doubleArrayResult;
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[][][] transformToBytesValuesMV(ValueBlock valueBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public RoaringBitmap getNullBitmap(ValueBlock block) {
        if (this._dataType != FieldSpec.DataType.UNKNOWN) {
            return null;
        }
        int length = block.getNumDocs();
        RoaringBitmap bitmap = new RoaringBitmap();
        bitmap.add(0L, (long)length);
        return bitmap;
    }
}

