/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.roaringbitmap.RoaringBitmap;

public class IdentifierTransformFunction
implements TransformFunction {
    private final String _columnName;
    private final Dictionary _dictionary;
    private final TransformResultMetadata _resultMetadata;

    public IdentifierTransformFunction(String columnName, ColumnContext columnContext) {
        this._columnName = columnName;
        this._dictionary = columnContext.getDictionary();
        this._resultMetadata = new TransformResultMetadata(columnContext.getDataType(), columnContext.isSingleValue(), this._dictionary != null);
    }

    public String getColumnName() {
        return this._columnName;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    @Nullable
    public Dictionary getDictionary() {
        return this._dictionary;
    }

    @Override
    public int[] transformToDictIdsSV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getDictionaryIdsSV();
    }

    @Override
    public int[][] transformToDictIdsMV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getDictionaryIdsMV();
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getIntValuesSV();
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getLongValuesSV();
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getFloatValuesSV();
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getDoubleValuesSV();
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getBigDecimalValuesSV();
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getStringValuesSV();
    }

    @Override
    public byte[][] transformToBytesValuesSV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getBytesValuesSV();
    }

    @Override
    public int[][] transformToIntValuesMV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getIntValuesMV();
    }

    @Override
    public long[][] transformToLongValuesMV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getLongValuesMV();
    }

    @Override
    public float[][] transformToFloatValuesMV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getFloatValuesMV();
    }

    @Override
    public double[][] transformToDoubleValuesMV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getDoubleValuesMV();
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getStringValuesMV();
    }

    @Override
    public byte[][][] transformToBytesValuesMV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getBytesValuesMV();
    }

    @Override
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._columnName).getNullBitmap();
    }
}

