/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.query.utils.idset.IdSet;
import org.apache.pinot.core.query.utils.idset.IdSets;
import org.apache.pinot.spi.data.FieldSpec;

public class InIdSetTransformFunction
extends BaseTransformFunction {
    private TransformFunction _transformFunction;
    private IdSet _idSet;

    @Override
    public String getName() {
        return TransformFunctionType.IN_ID_SET.getName();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0, (Object)"2 arguments are required for IN_ID_SET transform function: expression, base64 encoded IdSet");
        Preconditions.checkArgument((boolean)arguments.get(0).getResultMetadata().isSingleValue(), (Object)"First argument for IN_ID_SET transform function must be a single-value expression");
        Preconditions.checkArgument((boolean)(arguments.get(1) instanceof LiteralTransformFunction), (Object)"Second argument for IN_ID_SET transform function must be a literal string of the base64 encoded IdSet");
        this._transformFunction = arguments.get(0);
        try {
            this._idSet = IdSets.fromBase64String(((LiteralTransformFunction)arguments.get(1)).getStringLiteral());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Caught exception while deserializing IdSet", e);
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initIntValuesSV(length);
        FieldSpec.DataType storedType = this._transformFunction.getResultMetadata().getDataType().getStoredType();
        switch (storedType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._intValuesSV[i] = this._idSet.contains(intValues[i]) ? 1 : 0;
                }
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._intValuesSV[i] = this._idSet.contains(longValues[i]) ? 1 : 0;
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._intValuesSV[i] = this._idSet.contains(floatValues[i]) ? 1 : 0;
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._intValuesSV[i] = this._idSet.contains(doubleValues[i]) ? 1 : 0;
                }
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._intValuesSV[i] = this._idSet.contains(stringValues[i]) ? 1 : 0;
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = this._transformFunction.transformToBytesValuesSV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._intValuesSV[i] = this._idSet.contains(bytesValues[i]) ? 1 : 0;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._intValuesSV;
    }
}

