/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.roaringbitmap.RoaringBitmap;

public class IsNullTransformFunction
extends BaseTransformFunction {
    private TransformFunction _transformFunction;

    @Override
    public String getName() {
        return TransformFunctionType.IS_NULL.getName();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (Object)"Exact 1 argument is required for IS_NULL");
        this._transformFunction = arguments.get(0);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        RoaringBitmap bitmap = this._transformFunction.getNullBitmap(valueBlock);
        int length = valueBlock.getNumDocs();
        this.initIntValuesSV(length);
        Arrays.fill(this._intValuesSV, this.getIsNullValue() ^ 1);
        if (bitmap != null) {
            bitmap.forEach(i -> {
                this._intValuesSV[i] = this.getIsNullValue();
            });
        }
        return this._intValuesSV;
    }

    @Override
    public RoaringBitmap getNullBitmap(ValueBlock valueBlock) {
        return null;
    }

    protected int getIsNullValue() {
        return 1;
    }
}

