/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.IdentifierTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.MapDataSource;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class ItemTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "item";
    String _column;
    String _key;
    String[] _keyPath;
    TransformFunction _mapValue;
    TransformFunction _keyValue;
    Dictionary _keyDictionary;
    private TransformResultMetadata _resultMetadata;

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 1 argument is required for Vector transform function");
        }
        this._mapValue = arguments.get(0);
        Preconditions.checkArgument((boolean)(this._mapValue instanceof IdentifierTransformFunction), (Object)"Map Item: Left operandmust be an identifier");
        this._column = ((IdentifierTransformFunction)this._mapValue).getColumnName();
        if (this._column == null) {
            throw new IllegalArgumentException("Map Item: left operand resolved to a null column name");
        }
        this._keyValue = arguments.get(1);
        Preconditions.checkArgument((boolean)(this._keyValue instanceof LiteralTransformFunction), (Object)"Map Item: Right operandmust be a literal");
        this._key = ((LiteralTransformFunction)arguments.get(1)).getStringLiteral();
        Preconditions.checkArgument((this._key != null ? 1 : 0) != 0, (Object)"Map Item: Right operandmust be a string literal");
        this._keyPath = new String[]{this._column, this._key};
        DataSource dataSource = columnContextMap.get(this._column).getDataSource();
        if (!(dataSource instanceof MapDataSource)) {
            throw new RuntimeException("The left operand for a MAP ITEM operation must resolve to a Map Data Source");
        }
        MapDataSource mapDS = (MapDataSource)dataSource;
        DataSource keyDS = mapDS.getKeyDataSource(this._key);
        FieldSpec.DataType keyType = keyDS.getDataSourceMetadata().getDataType().getStoredType();
        this._keyDictionary = keyDS.getDictionary();
        this._resultMetadata = new TransformResultMetadata(keyType, keyDS.getDataSourceMetadata().isSingleValue(), this._keyDictionary != null);
    }

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return new TransformResultMetadata(this._resultMetadata.getDataType().getStoredType(), true, this._resultMetadata.hasDictionary());
    }

    @Override
    public Dictionary getDictionary() {
        return this._keyDictionary;
    }

    @Override
    public int[] transformToDictIdsSV(ValueBlock valueBlock) {
        return this.transformToIntValuesSV(valueBlock);
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._keyPath).getIntValuesSV();
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._keyPath).getLongValuesSV();
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._keyPath).getDoubleValuesSV();
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        return valueBlock.getBlockValueSet(this._keyPath).getStringValuesSV();
    }
}

