/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.JsonPathCache;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;

public class JsonExtractKeyTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "jsonExtractKey";
    private static final ParseContext JSON_PARSER_CONTEXT = JsonPath.using((Configuration)new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new JacksonJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.AS_PATH_LIST, Option.SUPPRESS_EXCEPTIONS}).build());
    private TransformFunction _jsonFieldTransformFunction;
    private JsonPath _jsonPath;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for transform function: jsonExtractKey(jsonFieldName, 'jsonPath')");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || !firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The first argument of jsonExtractKey transform function must be a single-valued column or a transform function");
        }
        this._jsonFieldTransformFunction = firstArgument;
        this._jsonPath = JsonPathCache.INSTANCE.getOrCompute(((LiteralTransformFunction)arguments.get(1)).getStringLiteral());
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return STRING_MV_NO_DICTIONARY_METADATA;
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initStringValuesMV(length);
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        for (int i = 0; i < length; ++i) {
            List values = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            this._stringValuesMV[i] = values.toArray(new String[0]);
        }
        return this._stringValuesMV;
    }
}

