/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.pinot.common.function.JsonPathCache;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.util.NumberUtils;
import org.apache.pinot.core.util.NumericException;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;

public class JsonExtractScalarTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "jsonExtractScalar";
    private static final ObjectMapper OBJECT_MAPPER_WITH_BIG_DECIMAL = new ObjectMapper().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    private static final ParseContext JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL = JsonPath.using((Configuration)new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new JacksonJsonProvider(OBJECT_MAPPER_WITH_BIG_DECIMAL)).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());
    private static final ParseContext JSON_PARSER_CONTEXT = JsonPath.using((Configuration)new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new JacksonJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());
    private TransformFunction _jsonFieldTransformFunction;
    private JsonPath _jsonPath;
    private Object _defaultValue;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        FieldSpec.DataType dataType;
        super.init(arguments, columnContextMap);
        if (arguments.size() < 3 || arguments.size() > 4) {
            throw new IllegalArgumentException("Expected 3/4 arguments for transform function: jsonExtractScalar(jsonFieldName, 'jsonPath', 'resultsType', ['defaultValue'])");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || !firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The first argument of jsonExtractScalar transform function must be a single-valued column or a transform function");
        }
        this._jsonFieldTransformFunction = firstArgument;
        String jsonPathString = ((LiteralTransformFunction)arguments.get(1)).getStringLiteral();
        this._jsonPath = JsonPathCache.INSTANCE.getOrCompute(jsonPathString);
        String resultsType = ((LiteralTransformFunction)arguments.get(2)).getStringLiteral().toUpperCase();
        boolean isSingleValue = !resultsType.endsWith("_ARRAY");
        try {
            dataType = FieldSpec.DataType.valueOf((String)(isSingleValue ? resultsType : resultsType.substring(0, resultsType.length() - 6)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Unsupported results type: %s for jsonExtractScalar function. Supported types are: INT/LONG/FLOAT/DOUBLE/BOOLEAN/BIG_DECIMAL/TIMESTAMP/STRING/INT_ARRAY/LONG_ARRAY/FLOAT_ARRAY/DOUBLE_ARRAY/STRING_ARRAY", resultsType));
        }
        if (arguments.size() == 4) {
            this._defaultValue = dataType.convert(((LiteralTransformFunction)arguments.get(3)).getStringLiteral());
        }
        this._resultMetadata = new TransformResultMetadata(dataType, isSingleValue, false);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(valueBlock);
        }
        this.initIntValuesSV(valueBlock.getNumDocs());
        IntFunction resultExtractor = this.getResultExtractor(valueBlock);
        int defaultValue = 0;
        if (this._defaultValue != null) {
            defaultValue = this._defaultValue instanceof Number ? ((Number)this._defaultValue).intValue() : Integer.parseInt(this._defaultValue.toString());
        }
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = resultExtractor.apply(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._intValuesSV[i] = defaultValue;
                    continue;
                }
                throw new IllegalArgumentException("Cannot resolve JSON path on some records. Consider setting a default value.");
            }
            this._intValuesSV[i] = result instanceof Number ? ((Number)result).intValue() : Integer.parseInt(result.toString());
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(valueBlock);
        }
        this.initLongValuesSV(valueBlock.getNumDocs());
        IntFunction resultExtractor = this.getResultExtractor(valueBlock);
        long defaultValue = 0L;
        if (this._defaultValue != null) {
            defaultValue = this._defaultValue instanceof Number ? ((Number)this._defaultValue).longValue() : Long.parseLong(this._defaultValue.toString());
        }
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = resultExtractor.apply(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._longValuesSV[i] = defaultValue;
                    continue;
                }
                throw new IllegalArgumentException("Cannot resolve JSON path on some records. Consider setting a default value.");
            }
            if (result instanceof Number) {
                this._longValuesSV[i] = ((Number)result).longValue();
                continue;
            }
            try {
                this._longValuesSV[i] = NumberUtils.parseJsonLong(result.toString());
                continue;
            }
            catch (NumericException nfe) {
                throw new NumberFormatException("For input string: \"" + result + "\"");
            }
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        this.initFloatValuesSV(valueBlock.getNumDocs());
        IntFunction resultExtractor = this.getResultExtractor(valueBlock);
        float defaultValue = 0.0f;
        if (this._defaultValue != null) {
            defaultValue = this._defaultValue instanceof Number ? ((Number)this._defaultValue).floatValue() : Float.parseFloat(this._defaultValue.toString());
        }
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = resultExtractor.apply(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._floatValuesSV[i] = defaultValue;
                    continue;
                }
                throw new IllegalArgumentException("Cannot resolve JSON path on some records. Consider setting a default value.");
            }
            this._floatValuesSV[i] = result instanceof Number ? ((Number)result).floatValue() : Float.parseFloat(result.toString());
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        this.initDoubleValuesSV(valueBlock.getNumDocs());
        IntFunction resultExtractor = this.getResultExtractor(valueBlock);
        double defaultValue = 0.0;
        if (this._defaultValue != null) {
            defaultValue = this._defaultValue instanceof Number ? ((Number)this._defaultValue).doubleValue() : Double.parseDouble(this._defaultValue.toString());
        }
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = resultExtractor.apply(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._doubleValuesSV[i] = defaultValue;
                    continue;
                }
                throw new IllegalArgumentException("Cannot resolve JSON path on some records. Consider setting a default value.");
            }
            this._doubleValuesSV[i] = result instanceof Number ? ((Number)result).doubleValue() : Double.parseDouble(result.toString());
        }
        return this._doubleValuesSV;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        this.initBigDecimalValuesSV(valueBlock.getNumDocs());
        IntFunction resultExtractor = this.getResultExtractor(valueBlock, JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL);
        BigDecimal defaultValue = null;
        if (this._defaultValue != null) {
            defaultValue = this._defaultValue instanceof BigDecimal ? (BigDecimal)this._defaultValue : new BigDecimal(this._defaultValue.toString());
        }
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = resultExtractor.apply(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._bigDecimalValuesSV[i] = defaultValue;
                    continue;
                }
                throw new IllegalArgumentException("Cannot resolve JSON path on some records. Consider setting a default value.");
            }
            this._bigDecimalValuesSV[i] = result instanceof BigDecimal ? (BigDecimal)result : new BigDecimal(result.toString());
        }
        return this._bigDecimalValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        this.initStringValuesSV(valueBlock.getNumDocs());
        IntFunction resultExtractor = this.getResultExtractor(valueBlock, JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL);
        String defaultValue = null;
        if (this._defaultValue != null) {
            defaultValue = this._defaultValue.toString();
        }
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = resultExtractor.apply(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._stringValuesSV[i] = defaultValue;
                    continue;
                }
                throw new IllegalArgumentException("Cannot resolve JSON path on some records. Consider setting a default value.");
            }
            this._stringValuesSV[i] = result instanceof String ? (String)result : JsonUtils.objectToJsonNode(result).toString();
        }
        return this._stringValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ValueBlock valueBlock) {
        this.initIntValuesMV(valueBlock.getNumDocs());
        IntFunction resultExtractor = this.getResultExtractor(valueBlock);
        int numDocs = valueBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            List result = null;
            try {
                result = (List)resultExtractor.apply(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._intValuesMV[i] = new int[0];
                continue;
            }
            int numValues = result.size();
            int[] values = new int[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (Integer)result.get(j);
            }
            this._intValuesMV[i] = values;
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ValueBlock valueBlock) {
        this.initLongValuesMV(valueBlock.getNumDocs());
        IntFunction resultExtractor = this.getResultExtractor(valueBlock);
        int length = valueBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)resultExtractor.apply(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._longValuesMV[i] = new long[0];
                continue;
            }
            int numValues = result.size();
            long[] values = new long[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (Long)result.get(j);
            }
            this._longValuesMV[i] = values;
        }
        return this._longValuesMV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ValueBlock valueBlock) {
        this.initFloatValuesMV(valueBlock.getNumDocs());
        IntFunction resultExtractor = this.getResultExtractor(valueBlock);
        int length = valueBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)resultExtractor.apply(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._floatValuesMV[i] = new float[0];
                continue;
            }
            int numValues = result.size();
            float[] values = new float[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = ((Float)result.get(j)).floatValue();
            }
            this._floatValuesMV[i] = values;
        }
        return this._floatValuesMV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ValueBlock valueBlock) {
        this.initDoubleValuesMV(valueBlock.getNumDocs());
        IntFunction resultExtractor = this.getResultExtractor(valueBlock);
        int length = valueBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)resultExtractor.apply(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._doubleValuesMV[i] = new double[0];
                continue;
            }
            int numValues = result.size();
            double[] values = new double[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (Double)result.get(j);
            }
            this._doubleValuesMV[i] = values;
        }
        return this._doubleValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        this.initStringValuesMV(valueBlock.getNumDocs());
        IntFunction resultExtractor = this.getResultExtractor(valueBlock);
        int length = valueBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)resultExtractor.apply(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._stringValuesMV[i] = new String[0];
                continue;
            }
            int numValues = result.size();
            String[] values = new String[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (String)result.get(j);
            }
            this._stringValuesMV[i] = values;
        }
        return this._stringValuesMV;
    }

    private <T> IntFunction<T> getResultExtractor(ValueBlock valueBlock, ParseContext parseContext) {
        if (this._jsonFieldTransformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BYTES) {
            byte[][] jsonBytes = this._jsonFieldTransformFunction.transformToBytesValuesSV(valueBlock);
            return i -> parseContext.parseUtf8(jsonBytes[i]).read(this._jsonPath);
        }
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(valueBlock);
        return i -> parseContext.parse(jsonStrings[i]).read(this._jsonPath);
    }

    private <T> IntFunction<T> getResultExtractor(ValueBlock valueBlock) {
        return this.getResultExtractor(valueBlock, JSON_PARSER_CONTEXT);
    }
}

