/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.data.manager.offline.DimensionTableDataManager;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class LookupTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "lookUp";
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static final long[] EMPTY_LONGS = new long[0];
    private static final float[] EMPTY_FLOATS = new float[0];
    private static final double[] EMPTY_DOUBLES = new double[0];
    private static final String[] EMPTY_STRINGS = new String[0];
    private String _dimColumnName;
    private final List<String> _joinKeys = new ArrayList<String>();
    private final List<FieldSpec> _joinValueFieldSpecs = new ArrayList<FieldSpec>();
    private final List<TransformFunction> _joinValueFunctions = new ArrayList<TransformFunction>();
    private DimensionTableDataManager _dataManager;
    private FieldSpec _lookupColumnFieldSpec;
    private int _nullIntValue;
    private long _nullLongValue;
    private float _nullFloatValue;
    private double _nullDoubleValue;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        Preconditions.checkArgument((arguments.size() >= 4 ? 1 : 0) != 0, (Object)"At least 4 arguments are required for LOOKUP transform function: LOOKUP(TableName, ColumnName, JoinKey, JoinValue [, JoinKey2, JoinValue2 ...])");
        Preconditions.checkArgument((arguments.size() % 2 == 0 ? 1 : 0) != 0, (Object)"Should have the same number of JoinKey and JoinValue arguments");
        TransformFunction dimTableNameFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)(dimTableNameFunction instanceof LiteralTransformFunction), (Object)"First argument must be a literal(string) representing the dimension table name");
        String dimTableName = TableNameBuilder.OFFLINE.tableNameWithType(((LiteralTransformFunction)dimTableNameFunction).getStringLiteral());
        TransformFunction dimColumnFunction = arguments.get(1);
        Preconditions.checkArgument((boolean)(dimColumnFunction instanceof LiteralTransformFunction), (Object)"Second argument must be a literal(string) representing the column name from dimension table to lookup");
        this._dimColumnName = ((LiteralTransformFunction)dimColumnFunction).getStringLiteral();
        List<TransformFunction> joinArguments = arguments.subList(2, arguments.size());
        int numJoinArguments = joinArguments.size();
        for (int i = 0; i < numJoinArguments / 2; ++i) {
            TransformFunction dimJoinKeyFunction = joinArguments.get(i * 2);
            Preconditions.checkArgument((boolean)(dimJoinKeyFunction instanceof LiteralTransformFunction), (Object)"JoinKey argument must be a literal(string) representing the primary key for the dimension table");
            this._joinKeys.add(((LiteralTransformFunction)dimJoinKeyFunction).getStringLiteral());
            TransformFunction factJoinValueFunction = joinArguments.get(i * 2 + 1);
            TransformResultMetadata factJoinValueFunctionResultMetadata = factJoinValueFunction.getResultMetadata();
            Preconditions.checkArgument((boolean)factJoinValueFunctionResultMetadata.isSingleValue(), (Object)"JoinValue argument must be a single value expression");
            this._joinValueFunctions.add(factJoinValueFunction);
        }
        this._dataManager = DimensionTableDataManager.getInstanceByTableName(dimTableName);
        Preconditions.checkArgument((this._dataManager != null ? 1 : 0) != 0, (String)"Dimension table does not exist: %s", (Object)dimTableName);
        Preconditions.checkArgument((boolean)this._dataManager.isPopulated(), (String)"Dimension table is not populated: %s", (Object)dimTableName);
        this._lookupColumnFieldSpec = this._dataManager.getColumnFieldSpec(this._dimColumnName);
        Preconditions.checkArgument((this._lookupColumnFieldSpec != null ? 1 : 0) != 0, (String)"Column does not exist in dimension table: %s:%s", (Object)dimTableName, (Object)this._dimColumnName);
        for (String joinKey : this._joinKeys) {
            FieldSpec pkColumnSpec = this._dataManager.getColumnFieldSpec(joinKey);
            Preconditions.checkArgument((pkColumnSpec != null ? 1 : 0) != 0, (String)"Primary key column doesn't exist in dimension table: %s:%s", (Object)dimTableName, (Object)joinKey);
            this._joinValueFieldSpecs.add(pkColumnSpec);
        }
        List<String> tablePrimaryKeyColumns = this._dataManager.getPrimaryKeyColumns();
        Preconditions.checkArgument((boolean)this._joinKeys.equals(tablePrimaryKeyColumns), (String)"Provided join keys (%s) must be the same as table primary keys: %s", this._joinKeys, tablePrimaryKeyColumns);
        Object defaultNullValue = this._lookupColumnFieldSpec.getDefaultNullValue();
        if (defaultNullValue instanceof Number) {
            this._nullIntValue = ((Number)defaultNullValue).intValue();
            this._nullLongValue = ((Number)defaultNullValue).longValue();
            this._nullFloatValue = ((Number)defaultNullValue).floatValue();
            this._nullDoubleValue = ((Number)defaultNullValue).intValue();
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return new TransformResultMetadata(this._lookupColumnFieldSpec.getDataType(), this._lookupColumnFieldSpec.isSingleValueField(), false);
    }

    private void lookup(ValueBlock valueBlock, ValueAcceptor valueAcceptor) {
        int numPkColumns = this._joinKeys.size();
        int numDocuments = valueBlock.getNumDocs();
        Object[] pkColumns = new Object[numPkColumns];
        block8: for (int c = 0; c < numPkColumns; ++c) {
            FieldSpec.DataType storedType = this._joinValueFieldSpecs.get(c).getDataType().getStoredType();
            TransformFunction tf = this._joinValueFunctions.get(c);
            switch (storedType) {
                case INT: {
                    pkColumns[c] = tf.transformToIntValuesSV(valueBlock);
                    continue block8;
                }
                case LONG: {
                    pkColumns[c] = tf.transformToLongValuesSV(valueBlock);
                    continue block8;
                }
                case FLOAT: {
                    pkColumns[c] = tf.transformToFloatValuesSV(valueBlock);
                    continue block8;
                }
                case DOUBLE: {
                    pkColumns[c] = tf.transformToDoubleValuesSV(valueBlock);
                    continue block8;
                }
                case STRING: {
                    pkColumns[c] = tf.transformToStringValuesSV(valueBlock);
                    continue block8;
                }
                case BYTES: {
                    pkColumns[c] = tf.transformToBytesValuesSV(valueBlock);
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unknown column type for primary key");
                }
            }
        }
        Object[] pkValues = new Object[numPkColumns];
        PrimaryKey primaryKey = new PrimaryKey(pkValues);
        for (int i = 0; i < numDocuments; ++i) {
            for (int c = 0; c < numPkColumns; ++c) {
                if (pkColumns[c] instanceof int[]) {
                    pkValues[c] = ((int[])pkColumns[c])[i];
                    continue;
                }
                if (pkColumns[c] instanceof long[]) {
                    pkValues[c] = ((long[])pkColumns[c])[i];
                    continue;
                }
                if (pkColumns[c] instanceof String[]) {
                    pkValues[c] = ((String[])pkColumns[c])[i];
                    continue;
                }
                if (pkColumns[c] instanceof float[]) {
                    pkValues[c] = Float.valueOf(((float[])pkColumns[c])[i]);
                    continue;
                }
                if (pkColumns[c] instanceof double[]) {
                    pkValues[c] = ((double[])pkColumns[c])[i];
                    continue;
                }
                if (!(pkColumns[c] instanceof byte[][])) continue;
                pkValues[c] = new ByteArray(((byte[][])pkColumns[c])[i]);
            }
            Object value = this._dataManager.lookupValue(primaryKey, this._dimColumnName);
            valueAcceptor.accept(i, value);
        }
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        if (this._lookupColumnFieldSpec.getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(valueBlock);
        }
        this.initIntValuesSV(valueBlock.getNumDocs());
        this.lookup(valueBlock, this::setIntSV);
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        if (this._lookupColumnFieldSpec.getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(valueBlock);
        }
        this.initLongValuesSV(valueBlock.getNumDocs());
        this.lookup(valueBlock, this::setLongSV);
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        if (this._lookupColumnFieldSpec.getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(valueBlock);
        }
        this.initFloatValuesSV(valueBlock.getNumDocs());
        this.lookup(valueBlock, this::setFloatSV);
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        if (this._lookupColumnFieldSpec.getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(valueBlock);
        }
        this.initDoubleValuesSV(valueBlock.getNumDocs());
        this.lookup(valueBlock, this::setDoubleSV);
        return this._doubleValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        if (this._lookupColumnFieldSpec.getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(valueBlock);
        }
        this.initStringValuesSV(valueBlock.getNumDocs());
        this.lookup(valueBlock, this::setStringSV);
        return this._stringValuesSV;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ValueBlock valueBlock) {
        if (this._lookupColumnFieldSpec.getDataType().getStoredType() != FieldSpec.DataType.BYTES) {
            return super.transformToBytesValuesSV(valueBlock);
        }
        this.initBytesValuesSV(valueBlock.getNumDocs());
        this.lookup(valueBlock, this::setBytesSV);
        return this._bytesValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ValueBlock valueBlock) {
        if (this._lookupColumnFieldSpec.getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesMV(valueBlock);
        }
        this.initIntValuesMV(valueBlock.getNumDocs());
        this.lookup(valueBlock, this::setIntMV);
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ValueBlock valueBlock) {
        if (this._lookupColumnFieldSpec.getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesMV(valueBlock);
        }
        this.initLongValuesMV(valueBlock.getNumDocs());
        this.lookup(valueBlock, this::setLongMV);
        return this._longValuesMV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ValueBlock valueBlock) {
        if (this._lookupColumnFieldSpec.getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesMV(valueBlock);
        }
        this.initFloatValuesMV(valueBlock.getNumDocs());
        this.lookup(valueBlock, this::setFloatMV);
        return this._floatValuesMV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ValueBlock valueBlock) {
        if (this._lookupColumnFieldSpec.getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesMV(valueBlock);
        }
        this.initDoubleValuesMV(valueBlock.getNumDocs());
        this.lookup(valueBlock, this::setDoubleMV);
        return this._doubleValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        if (this._lookupColumnFieldSpec.getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesMV(valueBlock);
        }
        this.initStringValuesMV(valueBlock.getNumDocs());
        this.lookup(valueBlock, this::setStringMV);
        return this._stringValuesMV;
    }

    private void setIntSV(int index, Object value) {
        this._intValuesSV[index] = value instanceof Number ? ((Number)value).intValue() : this._nullIntValue;
    }

    private void setLongSV(int index, Object value) {
        this._longValuesSV[index] = value instanceof Number ? ((Number)value).longValue() : this._nullLongValue;
    }

    private void setFloatSV(int index, Object value) {
        this._floatValuesSV[index] = value instanceof Number ? ((Number)value).floatValue() : this._nullFloatValue;
    }

    private void setDoubleSV(int index, Object value) {
        this._doubleValuesSV[index] = value instanceof Number ? ((Number)value).doubleValue() : this._nullDoubleValue;
    }

    private void setStringSV(int index, Object value) {
        this._stringValuesSV[index] = value != null ? String.valueOf(value) : this._lookupColumnFieldSpec.getDefaultNullValueString();
    }

    private void setBytesSV(int index, Object value) {
        this._bytesValuesSV[index] = value instanceof byte[] ? (byte[])value : EMPTY_BYTES;
    }

    private void setIntMV(int index, Object value) {
        this._intValuesMV[index] = value instanceof int[] ? (int[])value : EMPTY_INTS;
    }

    private void setLongMV(int index, Object value) {
        this._longValuesMV[index] = value instanceof long[] ? (long[])value : EMPTY_LONGS;
    }

    private void setFloatMV(int index, Object value) {
        this._floatValuesMV[index] = value instanceof float[] ? (float[])value : EMPTY_FLOATS;
    }

    private void setDoubleMV(int index, Object value) {
        this._doubleValuesMV[index] = value instanceof double[] ? (double[])value : EMPTY_DOUBLES;
    }

    private void setStringMV(int index, Object value) {
        this._stringValuesMV[index] = value instanceof String[] ? (String[])value : EMPTY_STRINGS;
    }

    @FunctionalInterface
    private static interface ValueAcceptor {
        public void accept(int var1, @Nullable Object var2);
    }
}

