/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;

public class PowerTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "power";
    private TransformFunction _leftTransformFunction;
    private TransformFunction _rightTransformFunction;
    private double _exponent;
    private boolean _fixedExponent;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for power transform function");
        }
        this._fixedExponent = false;
        this._leftTransformFunction = arguments.get(0);
        this._rightTransformFunction = arguments.get(1);
        if (this._rightTransformFunction instanceof LiteralTransformFunction) {
            this._exponent = ((LiteralTransformFunction)this._rightTransformFunction).getDoubleLiteral();
            this._fixedExponent = true;
        }
        Preconditions.checkArgument((this._leftTransformFunction.getResultMetadata().isSingleValue() || this._rightTransformFunction.getResultMetadata().isSingleValue() ? 1 : 0) != 0, (String)"Argument must be single-valued for transform function: %s", (Object)this.getName());
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initDoubleValuesSV(length);
        double[] leftValues = this._leftTransformFunction.transformToDoubleValuesSV(valueBlock);
        if (this._fixedExponent) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.pow(leftValues[i], this._exponent);
            }
        } else {
            double[] rightValues = this._rightTransformFunction.transformToDoubleValuesSV(valueBlock);
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.pow(leftValues[i], rightValues[i]);
            }
        }
        return this._doubleValuesSV;
    }
}

