/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionInvoker;
import org.apache.pinot.common.function.FunctionUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.CommonConstants;

public class ScalarTransformFunctionWrapper
extends BaseTransformFunction {
    private final String _name;
    private final FunctionInvoker _functionInvoker;
    private final DataSchema.ColumnDataType _resultType;
    private final TransformResultMetadata _resultMetadata;
    private Object[] _scalarArguments;
    private int _numNonLiteralArguments;
    private int[] _nonLiteralIndices;
    private TransformFunction[] _nonLiteralFunctions;
    private Object[][] _nonLiteralValues;

    public ScalarTransformFunctionWrapper(FunctionInfo functionInfo) {
        this._name = functionInfo.getMethod().getName();
        this._functionInvoker = new FunctionInvoker(functionInfo);
        Class[] parameterClasses = this._functionInvoker.getParameterClasses();
        PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
        int numParameters = parameterClasses.length;
        for (int i = 0; i < numParameters; ++i) {
            Preconditions.checkArgument((parameterTypes[i] != null ? 1 : 0) != 0, (String)"Unsupported parameter class: %s for method: %s", (Object)parameterClasses[i], (Object)functionInfo.getMethod());
        }
        Class resultClass = this._functionInvoker.getResultClass();
        DataSchema.ColumnDataType resultType = FunctionUtils.getColumnDataType((Class)resultClass);
        if (resultType != null) {
            this._resultType = resultType;
            this._resultMetadata = new TransformResultMetadata(resultType.toDataType(), !this._resultType.isArray(), false);
        } else {
            this._resultType = DataSchema.ColumnDataType.STRING;
            this._resultMetadata = new TransformResultMetadata(FieldSpec.DataType.STRING, true, false);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        int numArguments = arguments.size();
        PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
        Preconditions.checkArgument((numArguments == parameterTypes.length ? 1 : 0) != 0, (String)"Wrong number of arguments for method: %s, expected: %s, actual: %s", (Object)this._functionInvoker.getMethod(), (Object)parameterTypes.length, (Object)numArguments);
        this._scalarArguments = new Object[numArguments];
        this._nonLiteralIndices = new int[numArguments];
        this._nonLiteralFunctions = new TransformFunction[numArguments];
        for (int i = 0; i < numArguments; ++i) {
            TransformFunction transformFunction = arguments.get(i);
            if (transformFunction instanceof LiteralTransformFunction) {
                LiteralTransformFunction literalTransformFunction = (LiteralTransformFunction)transformFunction;
                FieldSpec.DataType dataType = literalTransformFunction.getResultMetadata().getDataType();
                switch (dataType) {
                    case BOOLEAN: {
                        this._scalarArguments[i] = parameterTypes[i].convert((Object)literalTransformFunction.getBooleanLiteral(), PinotDataType.BOOLEAN);
                        break;
                    }
                    case INT: {
                        this._scalarArguments[i] = parameterTypes[i].convert((Object)literalTransformFunction.getIntLiteral(), PinotDataType.INTEGER);
                        break;
                    }
                    case LONG: {
                        this._scalarArguments[i] = parameterTypes[i].convert((Object)literalTransformFunction.getLongLiteral(), PinotDataType.LONG);
                        break;
                    }
                    case FLOAT: {
                        this._scalarArguments[i] = parameterTypes[i].convert((Object)Float.valueOf(literalTransformFunction.getFloatLiteral()), PinotDataType.FLOAT);
                        break;
                    }
                    case DOUBLE: {
                        this._scalarArguments[i] = parameterTypes[i].convert((Object)literalTransformFunction.getDoubleLiteral(), PinotDataType.DOUBLE);
                        break;
                    }
                    case BIG_DECIMAL: {
                        if (parameterTypes[i] == PinotDataType.STRING) {
                            this._scalarArguments[i] = literalTransformFunction.getStringLiteral();
                            break;
                        }
                        this._scalarArguments[i] = parameterTypes[i].convert((Object)literalTransformFunction.getBigDecimalLiteral(), PinotDataType.BIG_DECIMAL);
                        break;
                    }
                    case TIMESTAMP: {
                        if (parameterTypes[i] == PinotDataType.STRING) {
                            this._scalarArguments[i] = literalTransformFunction.getStringLiteral();
                            break;
                        }
                        this._scalarArguments[i] = parameterTypes[i].convert((Object)literalTransformFunction.getLongLiteral(), PinotDataType.TIMESTAMP);
                        break;
                    }
                    case STRING: {
                        this._scalarArguments[i] = parameterTypes[i].convert((Object)literalTransformFunction.getStringLiteral(), PinotDataType.STRING);
                        break;
                    }
                    case UNKNOWN: {
                        this._scalarArguments[i] = null;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported data type:" + dataType);
                    }
                }
                continue;
            }
            this._nonLiteralIndices[this._numNonLiteralArguments] = i;
            this._nonLiteralFunctions[this._numNonLiteralArguments] = transformFunction;
            ++this._numNonLiteralArguments;
        }
        this._nonLiteralValues = new Object[this._numNonLiteralArguments][];
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initIntValuesSV(length);
        this.getNonLiteralValues(valueBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._scalarArguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            Object value = this._functionInvoker.invoke(this._scalarArguments);
            this._intValuesSV[i] = value != null ? (Integer)this._resultType.toInternal(value) : 0;
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initLongValuesSV(length);
        this.getNonLiteralValues(valueBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._scalarArguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            Object value = this._functionInvoker.invoke(this._scalarArguments);
            this._longValuesSV[i] = value != null ? (Long)this._resultType.toInternal(value) : 0L;
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initFloatValuesSV(length);
        this.getNonLiteralValues(valueBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._scalarArguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            Object value = this._functionInvoker.invoke(this._scalarArguments);
            this._floatValuesSV[i] = value != null ? ((Float)this._resultType.toInternal(value)).floatValue() : 0.0f;
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initDoubleValuesSV(length);
        this.getNonLiteralValues(valueBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._scalarArguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            Object value = this._functionInvoker.invoke(this._scalarArguments);
            this._doubleValuesSV[i] = value != null ? (Double)this._resultType.toInternal(value) : 0.0;
        }
        return this._doubleValuesSV;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.BIG_DECIMAL) {
            return super.transformToBigDecimalValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initBigDecimalValuesSV(length);
        this.getNonLiteralValues(valueBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._scalarArguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            Object value = this._functionInvoker.invoke(this._scalarArguments);
            this._bigDecimalValuesSV[i] = value != null ? (BigDecimal)this._resultType.toInternal(value) : CommonConstants.NullValuePlaceHolder.BIG_DECIMAL;
        }
        return this._bigDecimalValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initStringValuesSV(length);
        this.getNonLiteralValues(valueBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._scalarArguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            Object value = this._functionInvoker.invoke(this._scalarArguments);
            this._stringValuesSV[i] = value != null ? (String)this._resultType.toInternal(value) : "";
        }
        return this._stringValuesSV;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.BYTES) {
            return super.transformToBytesValuesSV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initBytesValuesSV(length);
        this.getNonLiteralValues(valueBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._scalarArguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            Object value = this._functionInvoker.invoke(this._scalarArguments);
            byte[] bytes = value != null ? ((ByteArray)this._resultType.toInternal(value)).getBytes() : CommonConstants.NullValuePlaceHolder.BYTES;
            this._bytesValuesSV[i] = bytes;
        }
        return this._bytesValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesMV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initIntValuesMV(length);
        this.getNonLiteralValues(valueBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._scalarArguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._intValuesMV[i] = (int[])this._resultType.toInternal(this._functionInvoker.invoke(this._scalarArguments));
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesMV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initLongValuesMV(length);
        this.getNonLiteralValues(valueBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._scalarArguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._longValuesMV[i] = (long[])this._resultType.toInternal(this._functionInvoker.invoke(this._scalarArguments));
        }
        return this._longValuesMV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesMV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initFloatValuesMV(length);
        this.getNonLiteralValues(valueBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._scalarArguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._floatValuesMV[i] = (float[])this._resultType.toInternal(this._functionInvoker.invoke(this._scalarArguments));
        }
        return this._floatValuesMV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesMV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initDoubleValuesMV(length);
        this.getNonLiteralValues(valueBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._scalarArguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._doubleValuesMV[i] = (double[])this._resultType.toInternal(this._functionInvoker.invoke(this._scalarArguments));
        }
        return this._doubleValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ValueBlock valueBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesMV(valueBlock);
        }
        int length = valueBlock.getNumDocs();
        this.initStringValuesMV(length);
        this.getNonLiteralValues(valueBlock);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._scalarArguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._stringValuesMV[i] = (String[])this._resultType.toInternal(this._functionInvoker.invoke(this._scalarArguments));
        }
        return this._stringValuesMV;
    }

    private void getNonLiteralValues(ValueBlock valueBlock) {
        PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
        block16: for (int i = 0; i < this._numNonLiteralArguments; ++i) {
            PinotDataType parameterType = parameterTypes[this._nonLiteralIndices[i]];
            TransformFunction transformFunction = this._nonLiteralFunctions[i];
            switch (parameterType) {
                case INTEGER: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((int[])transformFunction.transformToIntValuesSV(valueBlock));
                    continue block16;
                }
                case LONG: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((long[])transformFunction.transformToLongValuesSV(valueBlock));
                    continue block16;
                }
                case FLOAT: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((float[])transformFunction.transformToFloatValuesSV(valueBlock));
                    continue block16;
                }
                case DOUBLE: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((double[])transformFunction.transformToDoubleValuesSV(valueBlock));
                    continue block16;
                }
                case BIG_DECIMAL: {
                    this._nonLiteralValues[i] = transformFunction.transformToBigDecimalValuesSV(valueBlock);
                    continue block16;
                }
                case BOOLEAN: {
                    int j;
                    int[] intValues = transformFunction.transformToIntValuesSV(valueBlock);
                    int numValues = intValues.length;
                    Boolean[] booleanValues = new Boolean[numValues];
                    for (j = 0; j < numValues; ++j) {
                        booleanValues[j] = intValues[j] == 1;
                    }
                    this._nonLiteralValues[i] = booleanValues;
                    continue block16;
                }
                case TIMESTAMP: {
                    int j;
                    long[] longValues = transformFunction.transformToLongValuesSV(valueBlock);
                    int numValues = longValues.length;
                    Timestamp[] timestampValues = new Timestamp[numValues];
                    for (j = 0; j < numValues; ++j) {
                        timestampValues[j] = new Timestamp(longValues[j]);
                    }
                    this._nonLiteralValues[i] = timestampValues;
                    continue block16;
                }
                case STRING: {
                    this._nonLiteralValues[i] = transformFunction.transformToStringValuesSV(valueBlock);
                    continue block16;
                }
                case BYTES: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToBytesValuesSV(valueBlock);
                    continue block16;
                }
                case PRIMITIVE_INT_ARRAY: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToIntValuesMV(valueBlock);
                    continue block16;
                }
                case PRIMITIVE_LONG_ARRAY: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToLongValuesMV(valueBlock);
                    continue block16;
                }
                case PRIMITIVE_FLOAT_ARRAY: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToFloatValuesMV(valueBlock);
                    continue block16;
                }
                case PRIMITIVE_DOUBLE_ARRAY: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToDoubleValuesMV(valueBlock);
                    continue block16;
                }
                case STRING_ARRAY: {
                    this._nonLiteralValues[i] = transformFunction.transformToStringValuesMV(valueBlock);
                    continue block16;
                }
                default: {
                    throw new IllegalStateException("Unsupported parameter type: " + parameterType);
                }
            }
        }
    }
}

