/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ArrayCopyUtils;

public class SubtractionTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "sub";
    private FieldSpec.DataType _resultDataType;
    private double[] _doubleLiterals;
    private BigDecimal[] _bigDecimalLiterals;
    private TransformFunction _firstTransformFunction;
    private TransformFunction _secondTransformFunction;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, ColumnContext> columnContextMap) {
        super.init(arguments, columnContextMap);
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for SUB transform function");
        }
        this._resultDataType = FieldSpec.DataType.DOUBLE;
        for (TransformFunction argument : arguments) {
            if (argument.getResultMetadata().getDataType() != FieldSpec.DataType.BIG_DECIMAL) continue;
            this._resultDataType = FieldSpec.DataType.BIG_DECIMAL;
            break;
        }
        if (this._resultDataType == FieldSpec.DataType.BIG_DECIMAL) {
            this._bigDecimalLiterals = new BigDecimal[2];
        } else {
            this._doubleLiterals = new double[2];
        }
        for (int i = 0; i < arguments.size(); ++i) {
            TransformFunction argument;
            argument = arguments.get(i);
            if (argument instanceof LiteralTransformFunction) {
                LiteralTransformFunction literalTransformFunction = (LiteralTransformFunction)argument;
                if (this._resultDataType == FieldSpec.DataType.BIG_DECIMAL) {
                    this._bigDecimalLiterals[i] = literalTransformFunction.getBigDecimalLiteral();
                    continue;
                }
                this._doubleLiterals[i] = ((LiteralTransformFunction)argument).getDoubleLiteral();
                continue;
            }
            if (!argument.getResultMetadata().isSingleValue()) {
                throw new IllegalArgumentException("every argument of SUB transform function must be single-valued");
            }
            if (i == 0) {
                this._firstTransformFunction = argument;
                continue;
            }
            this._secondTransformFunction = argument;
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        if (this._resultDataType == FieldSpec.DataType.BIG_DECIMAL) {
            return BIG_DECIMAL_SV_NO_DICTIONARY_METADATA;
        }
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initDoubleValuesSV(length);
        if (this._resultDataType == FieldSpec.DataType.BIG_DECIMAL) {
            BigDecimal[] values = this.transformToBigDecimalValuesSV(valueBlock);
            ArrayCopyUtils.copy((BigDecimal[])values, (double[])this._doubleValuesSV, (int)length);
        } else {
            double[] values;
            if (this._firstTransformFunction == null) {
                Arrays.fill(this._doubleValuesSV, 0, length, this._doubleLiterals[0]);
            } else {
                values = this._firstTransformFunction.transformToDoubleValuesSV(valueBlock);
                System.arraycopy(values, 0, this._doubleValuesSV, 0, length);
            }
            if (this._secondTransformFunction == null) {
                int i = 0;
                while (i < length) {
                    int n = i++;
                    this._doubleValuesSV[n] = this._doubleValuesSV[n] - this._doubleLiterals[1];
                }
            } else {
                values = this._secondTransformFunction.transformToDoubleValuesSV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    int n = i;
                    this._doubleValuesSV[n] = this._doubleValuesSV[n] - values[i];
                }
            }
        }
        return this._doubleValuesSV;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ValueBlock valueBlock) {
        int length = valueBlock.getNumDocs();
        this.initBigDecimalValuesSV(length);
        if (this._resultDataType == FieldSpec.DataType.DOUBLE) {
            double[] values = this.transformToDoubleValuesSV(valueBlock);
            ArrayCopyUtils.copy((double[])values, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
        } else {
            BigDecimal[] values;
            if (this._firstTransformFunction == null) {
                Arrays.fill(this._bigDecimalValuesSV, 0, length, this._bigDecimalLiterals[0]);
            } else {
                values = this._firstTransformFunction.transformToBigDecimalValuesSV(valueBlock);
                System.arraycopy(values, 0, this._bigDecimalValuesSV, 0, length);
            }
            if (this._secondTransformFunction == null) {
                for (int i = 0; i < length; ++i) {
                    this._bigDecimalValuesSV[i] = this._bigDecimalValuesSV[i].subtract(this._bigDecimalLiterals[1]);
                }
            } else {
                values = this._secondTransformFunction.transformToBigDecimalValuesSV(valueBlock);
                for (int i = 0; i < length; ++i) {
                    this._bigDecimalValuesSV[i] = this._bigDecimalValuesSV[i].subtract(values[i]);
                }
            }
        }
        return this._bigDecimalValuesSV;
    }
}

