/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.transformer.datetime;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.core.operator.transform.transformer.DataTransformer;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeFormatUnitSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;

public abstract class BaseDateTimeTransformer<I, O>
implements DataTransformer<I, O> {
    private final int _inputTimeSize;
    private final TimeUnit _inputTimeUnit;
    private final DateTimeFormatter _inputDateTimeFormatter;
    private final int _outputTimeSize;
    private final DateTimeFormatUnitSpec.DateTimeTransformUnit _outputTimeUnit;
    private final DateTimeFormatter _outputDateTimeFormatter;
    private final DateTimeGranularitySpec _outputGranularity;
    private final long _outputGranularityMillis;
    private final SDFDateTimeTruncate _sdfDateTimeTruncate;
    private final MillisDateTimeTruncate _millisDateTimeTruncate;
    private final Chronology _bucketingChronology;
    private final MutableDateTime _dateTime;
    private final StringBuilder _printBuffer;

    public BaseDateTimeTransformer(DateTimeFormatSpec inputFormat, DateTimeFormatSpec outputFormat, DateTimeGranularitySpec outputGranularity, @Nullable DateTimeZone bucketingTimeZone) {
        this._inputTimeSize = inputFormat.getColumnSize();
        this._inputTimeUnit = inputFormat.getColumnUnit();
        this._inputDateTimeFormatter = inputFormat.getDateTimeFormatter();
        this._outputTimeSize = outputFormat.getColumnSize();
        this._outputTimeUnit = outputFormat.getColumnDateTimeTransformUnit();
        this._outputDateTimeFormatter = outputFormat.getDateTimeFormatter();
        this._outputGranularity = outputGranularity;
        this._outputGranularityMillis = outputGranularity.granularityToMillis();
        this._bucketingChronology = bucketingTimeZone != null ? ISOChronology.getInstance((DateTimeZone)bucketingTimeZone) : null;
        this._dateTime = new MutableDateTime(0L, DateTimeZone.UTC);
        this._printBuffer = new StringBuilder();
        int size = this._outputGranularity.getSize();
        switch (this._outputGranularity.getTimeUnit()) {
            case MILLISECONDS: {
                if (size != 1) {
                    this._sdfDateTimeTruncate = dateTime -> {
                        dateTime.setMillisOfSecond(dateTime.getMillisOfSecond() / size * size);
                        return this.print(dateTime);
                    };
                    this._millisDateTimeTruncate = dateTime -> {
                        dateTime.setMillisOfSecond(dateTime.getMillisOfSecond() / size * size);
                        return dateTime.getMillis();
                    };
                    break;
                }
                this._sdfDateTimeTruncate = dateTime -> this.print(dateTime);
                this._millisDateTimeTruncate = dateTime -> dateTime.getMillis();
                break;
            }
            case SECONDS: {
                if (size != 1) {
                    this._sdfDateTimeTruncate = dateTime -> {
                        dateTime.setSecondOfMinute(dateTime.getSecondOfMinute() / size * size);
                        dateTime.secondOfMinute().roundFloor();
                        return this.print(dateTime);
                    };
                    this._millisDateTimeTruncate = dateTime -> {
                        dateTime.setSecondOfMinute(dateTime.getSecondOfMinute() / size * size);
                        dateTime.secondOfMinute().roundFloor();
                        return dateTime.getMillis();
                    };
                    break;
                }
                this._sdfDateTimeTruncate = dateTime -> {
                    dateTime.secondOfMinute().roundFloor();
                    return this.print(dateTime);
                };
                this._millisDateTimeTruncate = dateTime -> {
                    dateTime.secondOfMinute().roundFloor();
                    return dateTime.getMillis();
                };
                break;
            }
            case MINUTES: {
                if (size != 1) {
                    this._sdfDateTimeTruncate = dateTime -> {
                        dateTime.setMinuteOfHour(dateTime.getMinuteOfHour() / size * size);
                        dateTime.minuteOfHour().roundFloor();
                        return this.print(dateTime);
                    };
                    this._millisDateTimeTruncate = dateTime -> {
                        dateTime.setMinuteOfHour(dateTime.getMinuteOfHour() / size * size);
                        dateTime.minuteOfHour().roundFloor();
                        return dateTime.getMillis();
                    };
                    break;
                }
                this._sdfDateTimeTruncate = dateTime -> {
                    dateTime.minuteOfHour().roundFloor();
                    return this.print(dateTime);
                };
                this._millisDateTimeTruncate = dateTime -> {
                    dateTime.minuteOfHour().roundFloor();
                    return dateTime.getMillis();
                };
                break;
            }
            case HOURS: {
                if (size != 1) {
                    this._sdfDateTimeTruncate = dateTime -> {
                        dateTime.setHourOfDay(dateTime.getHourOfDay() / size * size);
                        dateTime.hourOfDay().roundFloor();
                        return this.print(dateTime);
                    };
                    this._millisDateTimeTruncate = dateTime -> {
                        dateTime.setHourOfDay(dateTime.getHourOfDay() / size * size);
                        dateTime.hourOfDay().roundFloor();
                        return dateTime.getMillis();
                    };
                    break;
                }
                this._sdfDateTimeTruncate = dateTime -> {
                    dateTime.hourOfDay().roundFloor();
                    return this.print(dateTime);
                };
                this._millisDateTimeTruncate = dateTime -> {
                    dateTime.hourOfDay().roundFloor();
                    return dateTime.getMillis();
                };
                break;
            }
            case DAYS: {
                if (size != 1) {
                    this._sdfDateTimeTruncate = dateTime -> {
                        dateTime.setDayOfMonth((dateTime.getDayOfMonth() - 1) / size * size + 1);
                        dateTime.dayOfMonth().roundFloor();
                        return this.print(dateTime);
                    };
                    this._millisDateTimeTruncate = dateTime -> {
                        dateTime.setDayOfMonth((dateTime.getDayOfMonth() - 1) / size * size + 1);
                        dateTime.dayOfMonth().roundFloor();
                        return dateTime.getMillis();
                    };
                    break;
                }
                this._sdfDateTimeTruncate = dateTime -> {
                    dateTime.dayOfMonth().roundFloor();
                    return this.print(dateTime);
                };
                this._millisDateTimeTruncate = dateTime -> {
                    dateTime.dayOfMonth().roundFloor();
                    return dateTime.getMillis();
                };
                break;
            }
            default: {
                this._sdfDateTimeTruncate = arg_0 -> ((DateTimeFormatter)this._outputDateTimeFormatter).print(arg_0);
                this._millisDateTimeTruncate = dateTime -> dateTime.getMillis();
            }
        }
    }

    private String print(MutableDateTime dateTime) {
        this._printBuffer.setLength(0);
        this._outputDateTimeFormatter.printTo(this._printBuffer, (ReadableInstant)dateTime);
        return this._printBuffer.toString();
    }

    protected long transformEpochToMillis(long epochTime) {
        return this._inputTimeUnit.toMillis(epochTime * (long)this._inputTimeSize);
    }

    protected MutableDateTime toDateWithTZ(long millis) {
        this._dateTime.setMillis(millis);
        this._dateTime.setChronology(this._bucketingChronology);
        return this._dateTime;
    }

    protected long transformSDFToMillis(@Nonnull String sdfTime) {
        return this._inputDateTimeFormatter.parseMillis(sdfTime);
    }

    protected long transformMillisToEpoch(long millisSinceEpoch) {
        return this._outputTimeUnit.fromMillis(millisSinceEpoch) / (long)this._outputTimeSize;
    }

    protected String transformMillisToSDF(long millisSinceEpoch) {
        this._dateTime.setZone(this._outputDateTimeFormatter.getZone());
        this._dateTime.setMillis(millisSinceEpoch);
        return this._sdfDateTimeTruncate.truncate(this._dateTime);
    }

    protected String truncateDateToSDF(MutableDateTime dateTime) {
        return this._sdfDateTimeTruncate.truncate(dateTime);
    }

    protected long truncateToMillis(MutableDateTime dateTime) {
        return this._millisDateTimeTruncate.truncate(dateTime);
    }

    protected long transformToOutputGranularity(long millisSinceEpoch) {
        return millisSinceEpoch / this._outputGranularityMillis * this._outputGranularityMillis;
    }

    protected boolean useCustomBucketingTimeZone() {
        return this._bucketingChronology != null;
    }

    private static interface MillisDateTimeTruncate {
        public long truncate(MutableDateTime var1);
    }

    private static interface SDFDateTimeTruncate {
        public String truncate(MutableDateTime var1);
    }
}

