/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.transformer.datetime;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.pinot.core.operator.transform.transformer.datetime.BaseDateTimeTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetime.EpochToEpochTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetime.EpochToSDFTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetime.SDFToEpochTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetime.SDFToSDFTransformer;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;
import org.joda.time.DateTimeZone;

public class DateTimeTransformerFactory {
    private DateTimeTransformerFactory() {
    }

    public static BaseDateTimeTransformer getDateTimeTransformer(String inputFormatStr, String outputFormatStr, String outputGranularityStr) {
        return DateTimeTransformerFactory.getDateTimeTransformer(inputFormatStr, outputFormatStr, outputGranularityStr, null);
    }

    public static BaseDateTimeTransformer getDateTimeTransformer(String inputFormatStr, String outputFormatStr, String outputGranularityStr, @Nullable String bucketTimeZoneStr) {
        DateTimeFormatSpec inputFormat = new DateTimeFormatSpec(inputFormatStr);
        DateTimeFormatSpec outputFormat = new DateTimeFormatSpec(outputFormatStr);
        DateTimeGranularitySpec outputGranularity = new DateTimeGranularitySpec(outputGranularityStr);
        DateTimeZone bucketingTz = null;
        if (bucketTimeZoneStr != null) {
            try {
                bucketingTz = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(ZoneId.of(bucketTimeZoneStr)));
            }
            catch (DateTimeException dte) {
                throw new IllegalArgumentException("Error parsing bucketing time zone: " + dte.getMessage(), dte);
            }
        }
        DateTimeFieldSpec.TimeFormat inputTimeFormat = inputFormat.getTimeFormat();
        DateTimeFieldSpec.TimeFormat outputTimeFormat = outputFormat.getTimeFormat();
        if (inputTimeFormat == DateTimeFieldSpec.TimeFormat.EPOCH || inputTimeFormat == DateTimeFieldSpec.TimeFormat.TIMESTAMP) {
            if (outputTimeFormat == DateTimeFieldSpec.TimeFormat.EPOCH || outputTimeFormat == DateTimeFieldSpec.TimeFormat.TIMESTAMP) {
                return new EpochToEpochTransformer(inputFormat, outputFormat, outputGranularity, bucketingTz);
            }
            return new EpochToSDFTransformer(inputFormat, outputFormat, outputGranularity, bucketingTz);
        }
        if (outputTimeFormat == DateTimeFieldSpec.TimeFormat.EPOCH || outputTimeFormat == DateTimeFieldSpec.TimeFormat.TIMESTAMP) {
            return new SDFToEpochTransformer(inputFormat, outputFormat, outputGranularity, bucketingTz);
        }
        return new SDFToSDFTransformer(inputFormat, outputFormat, outputGranularity, bucketingTz);
    }
}

