/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.transformer.datetime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.core.operator.transform.transformer.datetime.BaseDateTimeTransformer;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;
import org.joda.time.DateTimeZone;

public class EpochToSDFTransformer
extends BaseDateTimeTransformer<long[], String[]> {
    public EpochToSDFTransformer(DateTimeFormatSpec inputFormat, DateTimeFormatSpec outputFormat, DateTimeGranularitySpec outputGranularity, @Nullable DateTimeZone bucketingTimeZone) {
        super(inputFormat, outputFormat, outputGranularity, bucketingTimeZone);
    }

    @Override
    public void transform(@Nonnull long[] input, @Nonnull String[] output, int length) {
        if (this.useCustomBucketingTimeZone()) {
            for (int i = 0; i < length; ++i) {
                output[i] = this.truncateDateToSDF(this.toDateWithTZ(this.transformEpochToMillis(input[i])));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                output[i] = this.transformMillisToSDF(this.transformEpochToMillis(input[i]));
            }
        }
    }
}

