/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.transformer.datetimehop;

import java.util.List;
import org.apache.pinot.core.operator.transform.transformer.datetimehop.BaseDateTimeWindowHopTransformer;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;

public class EpochToEpochWindowHopTransformer
extends BaseDateTimeWindowHopTransformer<long[], long[][]> {
    public EpochToEpochWindowHopTransformer(DateTimeFormatSpec inputFormat, DateTimeFormatSpec outputFormat, DateTimeGranularitySpec outputGranularity, DateTimeGranularitySpec hopSize) {
        super(inputFormat, outputFormat, outputGranularity, hopSize);
    }

    @Override
    public void transform(long[] input, long[][] output, int length) {
        for (int i = 0; i < length; ++i) {
            long epochTime = input[i];
            long millisSinceEpoch = this.transformEpochToMillis(epochTime);
            List<Long> hopWindows = this.hopWindows(millisSinceEpoch);
            long[] transformedArray = new long[hopWindows.size()];
            for (int j = 0; j < hopWindows.size(); ++j) {
                long millis = hopWindows.get(j);
                transformedArray[j] = this.transformMillisToEpoch(millis);
            }
            output[i] = transformedArray;
        }
    }
}

