/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.transformer.datetimehop;

import java.util.List;
import org.apache.pinot.core.operator.transform.transformer.datetimehop.BaseDateTimeWindowHopTransformer;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;

public class SDFToSDFWindowHopTransformer
extends BaseDateTimeWindowHopTransformer<String[], String[][]> {
    public SDFToSDFWindowHopTransformer(DateTimeFormatSpec inputFormat, DateTimeFormatSpec outputFormat, DateTimeGranularitySpec outputGranularity, DateTimeGranularitySpec hopWindowSize) {
        super(inputFormat, outputFormat, outputGranularity, hopWindowSize);
    }

    @Override
    public void transform(String[] input, String[][] output, int length) {
        for (int i = 0; i < length; ++i) {
            String sdfTime = input[i];
            long millisSinceEpoch = this.transformSDFToMillis(sdfTime);
            List<Long> hopWindows = this.hopWindows(millisSinceEpoch);
            String[] transformedStrings = new String[hopWindows.size()];
            for (int j = 0; j < hopWindows.size(); ++j) {
                transformedStrings[j] = this.transformMillisToSDF(hopWindows.get(j));
            }
            output[i] = transformedStrings;
        }
    }
}

